/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaFormatter;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class JavaDocContext
extends CompilationUnitContext {
    private static final char HTML_TAG_BEGIN = '<';
    private static final char HTML_TAG_END = '>';
    private static final char JAVADOC_TAG_BEGIN = '@';

    public JavaDocContext(TemplateContextType templateContextType, IDocument iDocument, int n, int n2, ICompilationUnit iCompilationUnit) {
        super(templateContextType, iDocument, n, n2, iCompilationUnit);
    }

    public JavaDocContext(TemplateContextType templateContextType, IDocument iDocument, Position position, ICompilationUnit iCompilationUnit) {
        super(templateContextType, iDocument, position, iCompilationUnit);
    }

    public boolean canEvaluate(Template template) {
        String string = this.getKey();
        if (this.fForceEvaluation) {
            return true;
        }
        return template.matches(string, this.getContextType().getId()) && string.length() != 0 && template.getName().toLowerCase().startsWith(string.toLowerCase());
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument iDocument = this.getDocument();
            if (this.getCompletionLength() == 0) {
                int n = this.getCompletionOffset();
                if (n != 0 && iDocument.getChar(n - 1) == '>') {
                    --n;
                }
                while (n != 0 && !Character.isWhitespace(iDocument.getChar(n - 1))) {
                    --n;
                }
                if (n != 0 && !Character.isWhitespace(iDocument.getChar(n - 1))) {
                    --n;
                }
                if (n != 0 && (iDocument.getChar(n - 1) == '<' || iDocument.getChar(n - 1) == '@')) {
                    --n;
                }
                return n;
            }
            int n = this.getCompletionOffset();
            int n2 = this.getCompletionOffset() + this.getCompletionLength();
            while (n != 0 && !Character.isWhitespace(iDocument.getChar(n - 1))) {
                --n;
            }
            while (n != n2 && Character.isWhitespace(iDocument.getChar(n))) {
                ++n;
            }
            if (n == n2) {
                n = this.getCompletionOffset();
            }
            return n;
        }
        catch (BadLocationException badLocationException) {
            return this.getCompletionOffset();
        }
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getCompletionOffset();
            int n2 = this.getCompletionOffset() + this.getCompletionLength();
            while (n != n2 && Character.isWhitespace(iDocument.getChar(n2 - 1))) {
                --n2;
            }
            return n2;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getStart();
            int n2 = this.getCompletionOffset();
            return n <= n2 ? iDocument.get(n, n2 - n) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateTranslator templateTranslator = new TemplateTranslator();
        TemplateBuffer templateBuffer = templateTranslator.translate(template);
        this.getContextType().resolve(templateBuffer, (TemplateContext)this);
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.template.format");
        IJavaProject iJavaProject = this.getJavaProject();
        JavaFormatter javaFormatter = new JavaFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentation(), bl, iJavaProject);
        javaFormatter.format(templateBuffer, (TemplateContext)this);
        return templateBuffer;
    }

    private int getIndentation() {
        int n = this.getStart();
        IDocument iDocument = this.getDocument();
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            IJavaProject iJavaProject = this.getJavaProject();
            return Strings.computeIndentUnits(string, iJavaProject);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }
}

