/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;

public abstract class JavaElementResourceMapping
extends ResourceMapping {
    protected JavaElementResourceMapping() {
    }

    public IJavaElement getJavaElement() {
        Object object = this.getModelObject();
        if (object instanceof IJavaElement) {
            return (IJavaElement)object;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JavaElementResourceMapping)) {
            return false;
        }
        return this.getJavaElement().equals(((JavaElementResourceMapping)((Object)object)).getJavaElement());
    }

    public int hashCode() {
        IJavaElement iJavaElement = this.getJavaElement();
        if (iJavaElement == null) {
            return super.hashCode();
        }
        return iJavaElement.hashCode();
    }

    public String getModelProviderId() {
        return "org.eclipse.wst.jsdt.ui.modelProvider";
    }

    public boolean contains(ResourceMapping resourceMapping) {
        if (resourceMapping instanceof JavaElementResourceMapping) {
            JavaElementResourceMapping javaElementResourceMapping = (JavaElementResourceMapping)resourceMapping;
            IJavaElement iJavaElement = this.getJavaElement();
            IJavaElement iJavaElement2 = javaElementResourceMapping.getJavaElement();
            if (iJavaElement2 != null && iJavaElement != null) {
                return iJavaElement.getPath().isPrefixOf(iJavaElement2.getPath());
            }
        }
        return false;
    }

    private static IFile[] getPackageContent(IPackageFragment iPackageFragment) throws CoreException {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        IContainer iContainer = (IContainer)iPackageFragment.getResource();
        if (iContainer != null) {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IFile iFile;
                IResource iResource = iResourceArray[n];
                if (!(!(iResource instanceof IFile) || "class".equals((iFile = (IFile)iResource).getFileExtension()) && iFile.isDerived())) {
                    arrayList.add(iResource);
                }
                ++n;
            }
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    public static ResourceMapping create(IJavaElement iJavaElement) {
        switch (iJavaElement.getElementType()) {
            case 7: {
                return JavaElementResourceMapping.create((IType)iJavaElement);
            }
            case 5: {
                return JavaElementResourceMapping.create((ICompilationUnit)iJavaElement);
            }
            case 6: {
                return JavaElementResourceMapping.create((IClassFile)iJavaElement);
            }
            case 4: {
                return JavaElementResourceMapping.create((IPackageFragment)iJavaElement);
            }
            case 3: {
                return JavaElementResourceMapping.create((IPackageFragmentRoot)iJavaElement);
            }
            case 2: {
                return JavaElementResourceMapping.create((IJavaProject)iJavaElement);
            }
            case 1: {
                return JavaElementResourceMapping.create((IJavaModel)iJavaElement);
            }
        }
        return null;
    }

    public static ResourceMapping create(IJavaModel iJavaModel) {
        return new JavaModelResourceMapping(iJavaModel);
    }

    public static ResourceMapping create(IJavaProject iJavaProject) {
        return new JavaProjectResourceMapping(iJavaProject);
    }

    public static ResourceMapping create(IPackageFragmentRoot iPackageFragmentRoot) {
        if (iPackageFragmentRoot.isExternal()) {
            return null;
        }
        return new PackageFragementRootResourceMapping(iPackageFragmentRoot);
    }

    public static ResourceMapping create(IPackageFragment iPackageFragment) {
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getAncestor(3);
        if (!iPackageFragmentRoot.isArchive()) {
            return new PackageFragmentResourceMapping(iPackageFragment);
        }
        return null;
    }

    public static ResourceMapping create(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit == null) {
            return null;
        }
        return new CompilationUnitResourceMapping(iCompilationUnit.getPrimary());
    }

    public static ResourceMapping create(IClassFile iClassFile) {
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iClassFile.getAncestor(3);
        if (!iPackageFragmentRoot.isArchive()) {
            return new ClassFileResourceMapping(iClassFile);
        }
        return null;
    }

    public static ResourceMapping create(IType iType) {
        IJavaElement iJavaElement = iType.getParent();
        if (iJavaElement instanceof ICompilationUnit) {
            return JavaElementResourceMapping.create((ICompilationUnit)iJavaElement);
        }
        return null;
    }

    public static ResourceMapping create(LogicalPackage logicalPackage) {
        IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>(iPackageFragmentArray.length);
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragmentArray[n].getAncestor(3);
            if (!iPackageFragmentRoot.isArchive()) {
                arrayList.add(iPackageFragmentArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return new LogicalPackageResourceMapping(arrayList.toArray(new IPackageFragment[arrayList.size()]));
    }

    private static final class ClassFileResourceMapping
    extends JavaElementResourceMapping {
        private final IClassFile fClassFile;

        private ClassFileResourceMapping(IClassFile iClassFile) {
            this.fClassFile = iClassFile;
        }

        public Object getModelObject() {
            return this.fClassFile;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fClassFile.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fClassFile.getResource()}, 1, 0)};
        }
    }

    private static final class CompilationUnitResourceMapping
    extends JavaElementResourceMapping {
        private final ICompilationUnit fUnit;

        private CompilationUnitResourceMapping(ICompilationUnit iCompilationUnit) {
            Assert.isNotNull((Object)iCompilationUnit);
            this.fUnit = iCompilationUnit;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fUnit.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fUnit.getResource()}, 1, 0)};
        }
    }

    private static final class JavaModelResourceMapping
    extends JavaElementResourceMapping {
        private final IJavaModel fJavaModel;

        private JavaModelResourceMapping(IJavaModel iJavaModel) {
            Assert.isNotNull((Object)iJavaModel);
            this.fJavaModel = iJavaModel;
        }

        public Object getModelObject() {
            return this.fJavaModel;
        }

        public IProject[] getProjects() {
            IJavaProject[] iJavaProjectArray = null;
            try {
                iJavaProjectArray = this.fJavaModel.getJavaProjects();
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                return new IProject[0];
            }
            IProject[] iProjectArray = new IProject[iJavaProjectArray.length];
            int n = 0;
            while (n < iJavaProjectArray.length) {
                iProjectArray[n] = iJavaProjectArray[n].getProject();
                ++n;
            }
            return iProjectArray;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            IJavaProject[] iJavaProjectArray = this.fJavaModel.getJavaProjects();
            ResourceTraversal[] resourceTraversalArray = new ResourceTraversal[iJavaProjectArray.length];
            int n = 0;
            while (n < iJavaProjectArray.length) {
                resourceTraversalArray[n] = new ResourceTraversal(new IResource[]{iJavaProjectArray[n].getProject()}, 2, 0);
                ++n;
            }
            return resourceTraversalArray;
        }
    }

    private static final class JavaProjectResourceMapping
    extends JavaElementResourceMapping {
        private final IJavaProject fProject;

        private JavaProjectResourceMapping(IJavaProject iJavaProject) {
            Assert.isNotNull((Object)iJavaProject);
            this.fProject = iJavaProject;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fProject.getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fProject.getProject()}, 2, 0)};
        }
    }

    private static final class LocalPackageFragementTraversal
    extends ResourceTraversal {
        private final IPackageFragment fPack;

        public LocalPackageFragementTraversal(IPackageFragment iPackageFragment) throws CoreException {
            super(new IResource[]{iPackageFragment.getResource()}, 1, 0);
            this.fPack = iPackageFragment;
        }

        public void accept(IResourceVisitor iResourceVisitor) throws CoreException {
            IFile[] iFileArray = JavaElementResourceMapping.getPackageContent(this.fPack);
            IResource iResource = this.fPack.getResource();
            if (iResource != null) {
                iResourceVisitor.visit(iResource);
            }
            int n = 0;
            while (n < iFileArray.length) {
                iResourceVisitor.visit((IResource)iFileArray[n]);
                ++n;
            }
        }
    }

    private static final class LogicalPackageResourceMapping
    extends ResourceMapping {
        private final IPackageFragment[] fFragments;

        private LogicalPackageResourceMapping(IPackageFragment[] iPackageFragmentArray) {
            this.fFragments = iPackageFragmentArray;
        }

        public Object getModelObject() {
            return this.fFragments;
        }

        public IProject[] getProjects() {
            HashSet<IProject> hashSet = new HashSet<IProject>();
            int n = 0;
            while (n < this.fFragments.length) {
                hashSet.add(this.fFragments[n].getJavaProject().getProject());
                ++n;
            }
            return hashSet.toArray(new IProject[hashSet.size()]);
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            ArrayList<ResourceTraversal> arrayList = new ArrayList<ResourceTraversal>();
            if (resourceMappingContext instanceof RemoteResourceMappingContext) {
                int n = 0;
                while (n < this.fFragments.length) {
                    arrayList.add(new ResourceTraversal(new IResource[]{this.fFragments[n].getResource()}, 1, 0));
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.fFragments.length) {
                    arrayList.add(new LocalPackageFragementTraversal(this.fFragments[n]));
                    ++n;
                }
            }
            return arrayList.toArray(new ResourceTraversal[arrayList.size()]);
        }

        public String getModelProviderId() {
            return "org.eclipse.wst.jsdt.ui.modelProvider";
        }
    }

    private static final class PackageFragementRootResourceMapping
    extends JavaElementResourceMapping {
        private final IPackageFragmentRoot fRoot;

        private PackageFragementRootResourceMapping(IPackageFragmentRoot iPackageFragmentRoot) {
            Assert.isNotNull((Object)iPackageFragmentRoot);
            this.fRoot = iPackageFragmentRoot;
        }

        public Object getModelObject() {
            return this.fRoot;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fRoot.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fRoot.getResource()}, 2, 0)};
        }
    }

    private static final class PackageFragmentResourceMapping
    extends JavaElementResourceMapping {
        private final IPackageFragment fPack;

        private PackageFragmentResourceMapping(IPackageFragment iPackageFragment) {
            Assert.isNotNull((Object)iPackageFragment);
            this.fPack = iPackageFragment;
        }

        public Object getModelObject() {
            return this.fPack;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fPack.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
            if (resourceMappingContext instanceof RemoteResourceMappingContext) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fPack.getResource()}, 1, 0)};
            }
            return new ResourceTraversal[]{new LocalPackageFragementTraversal(this.fPack)};
        }

        public void accept(ResourceMappingContext resourceMappingContext, IResourceVisitor iResourceVisitor, IProgressMonitor iProgressMonitor) throws CoreException {
            if (resourceMappingContext instanceof RemoteResourceMappingContext) {
                super.accept(resourceMappingContext, iResourceVisitor, iProgressMonitor);
            } else {
                IFile[] iFileArray = JavaElementResourceMapping.getPackageContent(this.fPack);
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                iProgressMonitor.beginTask("", iFileArray.length + 1);
                IResource iResource = this.fPack.getResource();
                if (iResource != null) {
                    iResourceVisitor.visit(iResource);
                }
                iProgressMonitor.worked(1);
                int n = 0;
                while (n < iFileArray.length) {
                    iResourceVisitor.visit((IResource)iFileArray[n]);
                    iProgressMonitor.worked(1);
                    ++n;
                }
            }
        }
    }
}

