/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.LRUMap;

public class MethodOverrideTester {
    private final IType fFocusType;
    private final ITypeHierarchy fHierarchy;
    private Map fMethodSubstitutions;
    private Map fTypeVariableSubstitutions;

    public MethodOverrideTester(IType iType, ITypeHierarchy iTypeHierarchy) {
        if (iType == null || iTypeHierarchy == null) {
            throw new IllegalArgumentException();
        }
        this.fFocusType = iType;
        this.fHierarchy = iTypeHierarchy;
        this.fTypeVariableSubstitutions = null;
        this.fMethodSubstitutions = null;
    }

    public IType getFocusType() {
        return this.fFocusType;
    }

    public ITypeHierarchy getTypeHierarchy() {
        return this.fHierarchy;
    }

    public IMethod findDeclaringMethod(IMethod iMethod, boolean bl) throws JavaModelException {
        IMethod iMethod2 = null;
        IMethod iMethod3 = this.findOverriddenMethod(iMethod, bl);
        while (iMethod3 != null) {
            iMethod2 = iMethod3;
            iMethod3 = this.findOverriddenMethod(iMethod2, bl);
        }
        return iMethod2;
    }

    public IMethod findOverriddenMethod(IMethod iMethod, boolean bl) throws JavaModelException {
        IType[] iTypeArray;
        int n = iMethod.getFlags();
        if (Flags.isPrivate((int)n) || Flags.isStatic((int)n) || iMethod.isConstructor()) {
            return null;
        }
        IType iType = iMethod.getDeclaringType();
        if (iType == null) {
            return null;
        }
        IType iType2 = this.fHierarchy.getSuperclass(iType);
        if (!(iType2 == null || (iTypeArray = this.findOverriddenMethodInHierarchy(iType2, iMethod)) == null || Flags.isPrivate((int)iTypeArray.getFlags()) || bl && !JavaModelUtil.isVisibleInHierarchy((IMember)iTypeArray, iType.getPackageFragment()))) {
            return iTypeArray;
        }
        if (!iMethod.isConstructor()) {
            iTypeArray = this.fHierarchy.getSuperInterfaces(iType);
            int n2 = 0;
            while (n2 < iTypeArray.length) {
                IMethod iMethod2 = this.findOverriddenMethodInHierarchy(iTypeArray[n2], iMethod);
                if (iMethod2 != null) {
                    return iMethod2;
                }
                ++n2;
            }
        }
        return null;
    }

    public IMethod findOverriddenMethodInHierarchy(IType iType, IMethod iMethod) throws JavaModelException {
        IType[] iTypeArray;
        IMethod iMethod2 = this.findOverriddenMethodInType(iType, iMethod);
        if (iMethod2 != null) {
            return iMethod2;
        }
        IType iType2 = this.fHierarchy.getSuperclass(iType);
        if (iType2 != null && (iTypeArray = this.findOverriddenMethodInHierarchy(iType2, iMethod)) != null) {
            return iTypeArray;
        }
        if (!iMethod.isConstructor()) {
            iTypeArray = this.fHierarchy.getSuperInterfaces(iType);
            int n = 0;
            while (n < iTypeArray.length) {
                IMethod iMethod3 = this.findOverriddenMethodInHierarchy(iTypeArray[n], iMethod);
                if (iMethod3 != null) {
                    return iMethod3;
                }
                ++n;
            }
        }
        return iMethod2;
    }

    public IMethod findOverriddenMethodInType(IType iType, IMethod iMethod) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            if (this.isSubsignature(iMethod, iMethodArray[n])) {
                return iMethodArray[n];
            }
            ++n;
        }
        return null;
    }

    public IMethod findOverridingMethodInType(IType iType, IMethod iMethod) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            if (this.isSubsignature(iMethodArray[n], iMethod)) {
                return iMethodArray[n];
            }
            ++n;
        }
        return null;
    }

    public boolean isSubsignature(IMethod iMethod, IMethod iMethod2) throws JavaModelException {
        if (!iMethod2.getElementName().equals(iMethod.getElementName())) {
            return false;
        }
        int n = iMethod2.getNumberOfParameters();
        if (n != iMethod.getNumberOfParameters()) {
            return false;
        }
        if (!this.hasCompatibleTypeParameters(iMethod, iMethod2)) {
            return false;
        }
        return n == 0 || this.hasCompatibleParameterTypes(iMethod, iMethod2);
    }

    private boolean hasCompatibleTypeParameters(IMethod iMethod, IMethod iMethod2) throws JavaModelException {
        ITypeParameter[] iTypeParameterArray;
        int n;
        ITypeParameter[] iTypeParameterArray2 = iMethod2.getTypeParameters();
        if (iTypeParameterArray2.length != (n = (iTypeParameterArray = iMethod.getTypeParameters()).length)) {
            return n == 0;
        }
        Substitutions substitutions = this.getMethodSubstitions(iMethod2);
        Substitutions substitutions2 = this.getMethodSubstitions(iMethod);
        int n2 = 0;
        while (n2 < n) {
            String string = substitutions.getErasure(iTypeParameterArray2[n2].getElementName());
            String string2 = substitutions2.getErasure(iTypeParameterArray[n2].getElementName());
            if (string == null || !string.equals(string2)) {
                return false;
            }
            int n3 = iTypeParameterArray2[n2].getBounds().length;
            if (n3 > 1 && n3 != iTypeParameterArray[n2].getBounds().length) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean hasCompatibleParameterTypes(IMethod iMethod, IMethod iMethod2) throws JavaModelException {
        String string;
        String string2;
        String string3;
        String[] stringArray = iMethod2.getParameterTypes();
        String[] stringArray2 = iMethod.getParameterTypes();
        String[] stringArray3 = new String[stringArray2.length];
        boolean bl = false;
        int n = 0;
        while (n < stringArray2.length) {
            string3 = stringArray[n];
            string2 = this.getSubstitutedTypeName(string3, (IMember)iMethod2);
            stringArray3[n] = string = this.getSubstitutedTypeName(stringArray2[n], (IMember)iMethod);
            if (!string2.equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < stringArray2.length) {
                string3 = stringArray[n];
                string2 = this.getErasedTypeName(string3, (IMember)iMethod2);
                string = stringArray3[n];
                if (string == null) {
                    string = this.getSubstitutedTypeName(stringArray2[n], (IMember)iMethod);
                }
                if (!string2.equals(string)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private String getVariableSubstitution(IMember iMember, String string) throws JavaModelException {
        IType iType;
        String string2;
        if (iMember instanceof IMethod) {
            string2 = this.getMethodSubstitions((IMethod)iMember).getSubstitution(string);
            if (string2 != null) {
                return string2;
            }
            iType = iMember.getDeclaringType();
        } else {
            iType = (IType)iMember;
        }
        string2 = this.getTypeSubstitions(iType).getSubstitution(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private String getVariableErasure(IMember iMember, String string) throws JavaModelException {
        IType iType;
        String string2;
        if (iMember instanceof IMethod) {
            string2 = this.getMethodSubstitions((IMethod)iMember).getErasure(string);
            if (string2 != null) {
                return string2;
            }
            iType = iMember.getDeclaringType();
        } else {
            iType = (IType)iMember;
        }
        string2 = this.getTypeSubstitions(iType).getErasure(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private Substitutions getMethodSubstitions(IMethod iMethod) throws JavaModelException {
        Substitutions substitutions;
        if (this.fMethodSubstitutions == null) {
            this.fMethodSubstitutions = new LRUMap(3);
        }
        if ((substitutions = (Substitutions)this.fMethodSubstitutions.get(iMethod)) == null) {
            ITypeParameter[] iTypeParameterArray = iMethod.getTypeParameters();
            if (iTypeParameterArray.length == 0) {
                substitutions = Substitutions.EMPTY_SUBST;
            } else {
                IType iType = iMethod.getDeclaringType();
                substitutions = new Substitutions();
                int n = 0;
                while (n < iTypeParameterArray.length) {
                    ITypeParameter iTypeParameter = iTypeParameterArray[n];
                    substitutions.addSubstitution(iTypeParameter.getElementName(), String.valueOf('+') + String.valueOf(n), this.getTypeParameterErasure(iTypeParameter, iType));
                    ++n;
                }
            }
            this.fMethodSubstitutions.put(iMethod, substitutions);
        }
        return substitutions;
    }

    private Substitutions getTypeSubstitions(IType iType) throws JavaModelException {
        Substitutions substitutions;
        if (this.fTypeVariableSubstitutions == null) {
            this.fTypeVariableSubstitutions = new HashMap();
            this.computeSubstitutions(this.fFocusType, null, null);
        }
        if ((substitutions = (Substitutions)this.fTypeVariableSubstitutions.get(iType)) == null) {
            return Substitutions.EMPTY_SUBST;
        }
        return substitutions;
    }

    private void computeSubstitutions(IType iType, IType iType2, String[] stringArray) throws JavaModelException {
        int n;
        Object object;
        Object object2;
        ITypeParameter iTypeParameter;
        int n2;
        Substitutions substitutions = new Substitutions();
        this.fTypeVariableSubstitutions.put(iType, substitutions);
        ITypeParameter[] iTypeParameterArray = iType.getTypeParameters();
        if (iType2 == null) {
            n2 = 0;
            while (n2 < iTypeParameterArray.length) {
                iTypeParameter = iTypeParameterArray[n2];
                substitutions.addSubstitution(iTypeParameter.getElementName(), String.valueOf('*') + iTypeParameter.getElementName(), this.getTypeParameterErasure(iTypeParameter, iType));
                ++n2;
            }
        } else if (iTypeParameterArray.length == stringArray.length) {
            n2 = 0;
            while (n2 < iTypeParameterArray.length) {
                iTypeParameter = iTypeParameterArray[n2];
                object2 = this.getSubstitutedTypeName(stringArray[n2], (IMember)iType2);
                object = this.getErasedTypeName(stringArray[n2], (IMember)iType2);
                substitutions.addSubstitution(iTypeParameter.getElementName(), (String)object2, (String)object);
                ++n2;
            }
        } else if (stringArray.length == 0) {
            n2 = 0;
            while (n2 < iTypeParameterArray.length) {
                iTypeParameter = iTypeParameterArray[n2];
                object2 = this.getTypeParameterErasure(iTypeParameter, iType);
                substitutions.addSubstitution(iTypeParameter.getElementName(), (String)object2, (String)object2);
                ++n2;
            }
        }
        String string = iType.getSuperclassTypeSignature();
        if (string != null) {
            iTypeParameter = Signature.getTypeArguments((String)string);
            object2 = this.fHierarchy.getSuperclass(iType);
            if (object2 != null && !this.fTypeVariableSubstitutions.containsKey(object2)) {
                this.computeSubstitutions((IType)object2, iType, (String[])iTypeParameter);
            }
        }
        if ((n = ((ITypeParameter)(iTypeParameter = iType.getSuperInterfaceTypeSignatures())).length) > 0 && ((IType[])(object = this.fHierarchy.getSuperInterfaces(iType))).length == n) {
            int n3 = 0;
            while (n3 < n) {
                String[] stringArray2 = Signature.getTypeArguments((String)iTypeParameter[n3]);
                IType iType3 = object[n3];
                if (!this.fTypeVariableSubstitutions.containsKey(iType3)) {
                    this.computeSubstitutions(iType3, iType, stringArray2);
                }
                ++n3;
            }
        }
    }

    private String getTypeParameterErasure(ITypeParameter iTypeParameter, IType iType) throws JavaModelException {
        String[] stringArray = iTypeParameter.getBounds();
        if (stringArray.length > 0) {
            return this.getSubstitutedTypeName(Signature.createTypeSignature((String)stringArray[0], (boolean)false), (IMember)iType);
        }
        return "Object";
    }

    private String getSubstitutedTypeName(String string, IMember iMember) throws JavaModelException {
        return this.internalGetSubstitutedTypeName(string, iMember, false, new StringBuffer()).toString();
    }

    private String getErasedTypeName(String string, IMember iMember) throws JavaModelException {
        return this.internalGetSubstitutedTypeName(string, iMember, true, new StringBuffer()).toString();
    }

    private StringBuffer internalGetSubstitutedTypeName(String string, IMember iMember, boolean bl, StringBuffer stringBuffer) throws JavaModelException {
        int n = Signature.getTypeSignatureKind((String)string);
        switch (n) {
            case 2: {
                return stringBuffer.append(Signature.toString((String)string));
            }
            case 4: {
                this.internalGetSubstitutedTypeName(Signature.getElementType((String)string), iMember, bl, stringBuffer);
                int n2 = Signature.getArrayCount((String)string);
                while (n2 > 0) {
                    stringBuffer.append('[').append(']');
                    --n2;
                }
                return stringBuffer;
            }
            case 1: {
                String[] stringArray;
                String string2 = Signature.getTypeErasure((String)string);
                String string3 = Signature.getSimpleName((String)Signature.toString((String)string2));
                char c = string2.charAt(0);
                if (c == 'L') {
                    stringBuffer.append(string3);
                } else if (c == 'Q') {
                    if (bl) {
                        stringBuffer.append(this.getVariableErasure(iMember, string3));
                    } else {
                        stringBuffer.append(this.getVariableSubstitution(iMember, string3));
                    }
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown class type signature");
                }
                if (!bl && (stringArray = Signature.getTypeArguments((String)string)).length > 0) {
                    stringBuffer.append('<');
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (n3 > 0) {
                            stringBuffer.append(',');
                        }
                        this.internalGetSubstitutedTypeName(stringArray[n3], iMember, bl, stringBuffer);
                        ++n3;
                    }
                    stringBuffer.append('>');
                }
                return stringBuffer;
            }
            case 3: {
                String string4 = Signature.toString((String)string);
                if (bl) {
                    return stringBuffer.append(this.getVariableErasure(iMember, string4));
                }
                return stringBuffer.append(this.getVariableSubstitution(iMember, string4));
            }
            case 5: {
                stringBuffer.append('?');
                char c = string.charAt(0);
                if (c == '*') {
                    return stringBuffer;
                }
                if (c == '+') {
                    stringBuffer.append(" extends ");
                } else {
                    stringBuffer.append(" super ");
                }
                return this.internalGetSubstitutedTypeName(string.substring(1), iMember, bl, stringBuffer);
            }
            case 6: {
                return this.internalGetSubstitutedTypeName(string.substring(1), iMember, bl, stringBuffer);
            }
        }
        Assert.isTrue((boolean)false, (String)"Unhandled type signature kind");
        return stringBuffer;
    }

    private static class Substitutions {
        public static final Substitutions EMPTY_SUBST = new Substitutions();
        private HashMap fMap = null;

        public void addSubstitution(String string, String string2, String string3) {
            if (this.fMap == null) {
                this.fMap = new HashMap(3);
            }
            this.fMap.put(string, new String[]{string2, string3});
        }

        private String[] getSubstArray(String string) {
            if (this.fMap != null) {
                return (String[])this.fMap.get(string);
            }
            return null;
        }

        public String getSubstitution(String string) {
            String[] stringArray = this.getSubstArray(string);
            if (stringArray != null) {
                return stringArray[0];
            }
            return null;
        }

        public String getErasure(String string) {
            String[] stringArray = this.getSubstArray(string);
            if (stringArray != null) {
                return stringArray[1];
            }
            return null;
        }
    }
}

