/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.actions.BlockCommentAction;

public class AddBlockCommentAction
extends BlockCommentAction {
    public AddBlockCommentAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
        super(resourceBundle, string, iTextEditor);
    }

    protected void runInternal(ITextSelection iTextSelection, IDocumentExtension3 iDocumentExtension3, BlockCommentAction.Edit.EditFactory editFactory) throws BadLocationException, BadPartitioningException {
        int n = iTextSelection.getOffset();
        int n2 = n + iTextSelection.getLength();
        LinkedList linkedList = new LinkedList();
        ITypedRegion iTypedRegion = iDocumentExtension3.getPartition("___java_partitioning", n, false);
        this.handleFirstPartition(iTypedRegion, linkedList, editFactory, n);
        while (iTypedRegion.getOffset() + iTypedRegion.getLength() < n2) {
            iTypedRegion = this.handleInteriorPartition(iTypedRegion, linkedList, editFactory, iDocumentExtension3);
        }
        this.handleLastPartition(iTypedRegion, linkedList, editFactory, n2);
        this.executeEdits(linkedList);
    }

    private void handleFirstPartition(ITypedRegion iTypedRegion, List list, BlockCommentAction.Edit.EditFactory editFactory, int n) throws BadLocationException {
        int n2 = iTypedRegion.getOffset();
        String string = iTypedRegion.getType();
        Assert.isTrue((n2 <= n ? 1 : 0) != 0, (String)"illegal partition");
        if (string == "__dftl_partition_content_type") {
            list.add(editFactory.createEdit(n, 0, this.getCommentStart()));
        } else if (this.isSpecialPartition(string)) {
            list.add(editFactory.createEdit(n2, 0, this.getCommentStart()));
        }
    }

    private ITypedRegion handleInteriorPartition(ITypedRegion iTypedRegion, List list, BlockCommentAction.Edit.EditFactory editFactory, IDocumentExtension3 iDocumentExtension3) throws BadPartitioningException, BadLocationException {
        String string = iTypedRegion.getType();
        int n = iTypedRegion.getOffset() + iTypedRegion.getLength();
        int n2 = this.getCommentStart().length();
        boolean bl = false;
        if (string == "__java_javadoc") {
            bl = true;
        } else if (string == "__java_multiline_comment") {
            list.add(editFactory.createEdit(n - n2, n2, ""));
        }
        iTypedRegion = iDocumentExtension3.getPartition("___java_partitioning", n, false);
        string = iTypedRegion.getType();
        if (bl) {
            if (string == "__dftl_partition_content_type" || this.isSpecialPartition(string)) {
                list.add(editFactory.createEdit(iTypedRegion.getOffset(), 0, this.getCommentStart()));
            }
        } else if (string == "__java_javadoc") {
            list.add(editFactory.createEdit(iTypedRegion.getOffset(), 0, this.getCommentEnd()));
        } else if (string == "__java_multiline_comment") {
            list.add(editFactory.createEdit(iTypedRegion.getOffset(), this.getCommentStart().length(), ""));
        }
        return iTypedRegion;
    }

    private void handleLastPartition(ITypedRegion iTypedRegion, List list, BlockCommentAction.Edit.EditFactory editFactory, int n) throws BadLocationException {
        String string = iTypedRegion.getType();
        if (string == "__dftl_partition_content_type") {
            list.add(editFactory.createEdit(n, 0, this.getCommentEnd()));
        } else if (this.isSpecialPartition(string)) {
            list.add(editFactory.createEdit(iTypedRegion.getOffset() + iTypedRegion.getLength(), 0, this.getCommentEnd()));
        }
    }

    private boolean isSpecialPartition(String string) {
        return string == "__java_character" || string == "__java_string" || string == "__java_singleline_comment";
    }

    protected boolean isValidSelection(ITextSelection iTextSelection) {
        return iTextSelection != null && !iTextSelection.isEmpty() && iTextSelection.getLength() > 0;
    }
}

