/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.SearchBrokenNLSKeysUtil;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FindBrokenNLSKeysAction
extends SelectionDispatchAction {
    public static final String FIND_BROKEN_NLS_KEYS_ACTION_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.find.broken.nls.keys";
    public static final String ACTION_HANDLER_ID = "org.eclipse.wst.jsdt.ui.actions.FindNLSProblems";
    private JavaEditor fEditor;

    public FindBrokenNLSKeysAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.FindNLSProblemsAction_Name);
        this.setToolTipText(ActionMessages.FindNLSProblemsAction_ToolTip);
        this.setDescription(ActionMessages.FindNLSProblemsAction_Description);
    }

    public FindBrokenNLSKeysAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(FindBrokenNLSKeysAction.getCompilationUnit(javaEditor) != null);
    }

    public void run(ITextSelection iTextSelection) {
        ISelectionProvider iSelectionProvider = this.fEditor.getSelectionProvider();
        if (iSelectionProvider == null) {
            return;
        }
        this.run((IStructuredSelection)new StructuredSelection((Object)iSelectionProvider.getSelection()));
    }

    public void run(IStructuredSelection iStructuredSelection) {
        Object object;
        SearchPatternData[] searchPatternDataArray;
        if (iStructuredSelection.size() == 1 && (searchPatternDataArray = iStructuredSelection.getFirstElement()) instanceof IJavaElement) {
            object = (IJavaElement)searchPatternDataArray;
            if (!ActionUtil.isProcessable(this.getShell(), object)) {
                return;
            }
        }
        if ((searchPatternDataArray = this.getNLSFiles(iStructuredSelection)) == null || searchPatternDataArray.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.FindNLSProblemsAction_ErrorDialogTitle, (String)ActionMessages.FindNLSProblemsAction_NoPropertieFilesFoundErrorDescription);
            return;
        }
        object = "workspace";
        if (iStructuredSelection.size() == 1) {
            Object object2 = iStructuredSelection.getFirstElement();
            if (object2 instanceof IJavaElement) {
                object = ((IJavaElement)object2).getElementName();
            } else if (object2 instanceof IFile) {
                object = ((IFile)object2).getName();
            } else if (object2 instanceof IFolder) {
                object = ((IFolder)object2).getName();
            }
        }
        this.run(searchPatternDataArray, (String)object);
    }

    private void run(SearchPatternData[] searchPatternDataArray, String string) {
        IFile[] iFileArray;
        ArrayList<IType> arrayList = new ArrayList<IType>();
        ArrayList<IFile> arrayList2 = new ArrayList<IFile>();
        int n = 0;
        while (n < searchPatternDataArray.length) {
            iFileArray = searchPatternDataArray[n];
            if (iFileArray.getWrapperClass() != null || iFileArray.getPropertyFile() != null) {
                arrayList.add(iFileArray.getWrapperClass());
                arrayList2.add(iFileArray.getPropertyFile());
            }
            ++n;
        }
        IType[] iTypeArray = arrayList.toArray(new IType[arrayList.size()]);
        iFileArray = arrayList2.toArray(new IFile[arrayList2.size()]);
        SearchBrokenNLSKeysUtil.search(string, iTypeArray, iFileArray);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        ISelectionProvider iSelectionProvider = this.fEditor.getSelectionProvider();
        if (iSelectionProvider == null) {
            this.setEnabled(false);
        } else {
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)iSelectionProvider.getSelection()));
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.canEnable(iStructuredSelection));
    }

    private SearchPatternData[] getNLSFiles(IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        ArrayList arrayList = new ArrayList();
        this.collectNLSFiles(objectArray, arrayList);
        return arrayList.toArray(new SearchPatternData[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canEnable(IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            block14: {
                try {
                    IJavaElement iJavaElement;
                    if (objectArray[n] instanceof IJavaElement) {
                        iJavaElement = (IJavaElement)objectArray[n];
                        if (iJavaElement.exists()) {
                            switch (iJavaElement.getElementType()) {
                                case 7: {
                                    return iJavaElement.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: {
                                    return false;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                                    return iPackageFragmentRoot.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block14;
                    }
                    if (objectArray[n] instanceof LogicalPackage) {
                        return true;
                    }
                    if (objectArray[n] instanceof IFile && "properties".equalsIgnoreCase((iJavaElement = (IFile)objectArray[n]).getFileExtension())) {
                        return true;
                    }
                }
                catch (JavaModelException javaModelException) {
                    if (javaModelException.isDoesNotExist()) break block14;
                    JavaPlugin.log(javaModelException);
                }
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectNLSFiles(Object[] objectArray, List list) {
        try {
            int n = 0;
            while (true) {
                Object object;
                if (n >= objectArray.length) {
                    return;
                }
                if (objectArray[n] instanceof IJavaElement) {
                    object = (IJavaElement)objectArray[n];
                    if (object.exists()) {
                        switch (object.getElementType()) {
                            case 7: {
                                SearchPatternData searchPatternData;
                                if (object.getParent().getElementType() != 5 || (searchPatternData = this.tryIfPropertyCuSelected((ICompilationUnit)object.getParent())) == null) break;
                                list.add(searchPatternData);
                                break;
                            }
                            case 5: {
                                SearchPatternData searchPatternData = this.tryIfPropertyCuSelected((ICompilationUnit)object);
                                if (searchPatternData == null) break;
                                list.add(searchPatternData);
                                break;
                            }
                            case 12: {
                                break;
                            }
                            case 4: {
                                IPackageFragment iPackageFragment = (IPackageFragment)object;
                                if (iPackageFragment.getKind() != 1) break;
                                this.collectNLSFiles(new Object[]{iPackageFragment.getCorrespondingResource()}, list);
                                break;
                            }
                            case 3: {
                                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
                                if (iPackageFragmentRoot.getKind() != 1) break;
                                this.collectNLSFiles(new Object[]{iPackageFragmentRoot.getCorrespondingResource()}, list);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot iPackageFragmentRoot = (IJavaProject)object;
                                IPackageFragmentRoot[] iPackageFragmentRootArray = iPackageFragmentRoot.getAllPackageFragmentRoots();
                                int n2 = 0;
                                while (n2 < iPackageFragmentRootArray.length) {
                                    IPackageFragmentRoot iPackageFragmentRoot2 = iPackageFragmentRootArray[n2];
                                    if (iPackageFragmentRoot2.getKind() == 1 && iPackageFragmentRoot.equals(iPackageFragmentRoot2.getJavaProject())) {
                                        this.collectNLSFiles(new Object[]{iPackageFragmentRoot2.getCorrespondingResource()}, list);
                                    }
                                    ++n2;
                                }
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (objectArray[n] instanceof LogicalPackage) {
                    object = (LogicalPackage)((Object)objectArray[n]);
                    this.collectNLSFiles(new Object[]{((LogicalPackage)((Object)object)).getJavaProject()}, list);
                } else if (objectArray[n] instanceof IFolder) {
                    this.collectNLSFiles(((IFolder)objectArray[n]).members(), list);
                } else if (objectArray[n] instanceof IFile && (object = this.tryIfPropertyFileSelected((IFile)objectArray[n])) != null) {
                    list.add(object);
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            if (javaModelException.isDoesNotExist()) return;
            JavaPlugin.log(javaModelException);
            return;
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
    }

    private SearchPatternData tryIfPropertyCuSelected(ICompilationUnit iCompilationUnit) throws JavaModelException {
        if (iCompilationUnit == null) {
            return null;
        }
        if (!ActionUtil.isOnBuildPath((IJavaElement)iCompilationUnit)) {
            return null;
        }
        IType[] iTypeArray = iCompilationUnit.getTypes();
        if (iTypeArray.length > 1) {
            return null;
        }
        IStorage iStorage = NLSHintHelper.getResourceBundle(iCompilationUnit);
        if (!(iStorage instanceof IFile)) {
            return null;
        }
        return new SearchPatternData(iTypeArray[0], (IFile)iStorage);
    }

    private SearchPatternData tryIfPropertyFileSelected(IFile iFile) throws JavaModelException {
        if (!"properties".equalsIgnoreCase(iFile.getFileExtension())) {
            return null;
        }
        IPath iPath = iFile.getFullPath();
        String[] stringArray = JavaCore.getJavaLikeExtensions();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2;
            String string3;
            IType iType;
            ICompilationUnit iCompilationUnit;
            String string4;
            String string5 = stringArray[n];
            IPath iPath2 = iPath.removeFileExtension().addFileExtension(string5);
            IFile iFile2 = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(iPath2);
            if (iFile2 == null && (string4 = iPath2.removeFileExtension().lastSegment()) != null && string4.length() > 0) {
                string4 = String.valueOf(Character.toUpperCase(string4.charAt(0))) + string4.substring(1);
                iCompilationUnit = iPath.removeLastSegments(1).addTrailingSeparator();
                iPath2 = iCompilationUnit.append(string4).addFileExtension(string5);
                iFile2 = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(iPath2);
            }
            if (iFile2 != null && iFile2.exists() && (string4 = JavaCore.create((IFile)iFile2)) != null && string4.exists() && string4.getElementType() == 5 && ActionUtil.isOnBuildPath((IJavaElement)string4) && (iType = (iCompilationUnit = (ICompilationUnit)string4).findPrimaryType()) != null && (string3 = NLSHintHelper.getResourceBundleName(iCompilationUnit)) != null && (string2 = String.valueOf(string3) + ".properties").endsWith(string = iFile.getName())) {
                return new SearchPatternData(iType, iFile);
            }
            ++n;
        }
        return null;
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor javaEditor) {
        WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit iCompilationUnit = workingCopyManager.getWorkingCopy(javaEditor.getEditorInput());
        return iCompilationUnit;
    }

    private static class SearchPatternData {
        private final IType fAccessorType;
        private final IFile fPropertyFile;

        public SearchPatternData(IType iType, IFile iFile) {
            this.fAccessorType = iType;
            this.fPropertyFile = iFile;
        }

        public IFile getPropertyFile() {
            return this.fPropertyFile;
        }

        public IType getWrapperClass() {
            return this.fAccessorType;
        }
    }
}

