/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;

abstract class LogicalPackagesProvider
implements IPropertyChangeListener,
IElementChangedListener {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected Map fMapToLogicalPackage;
    protected Map fMapToPackageFragments;
    protected boolean fCompoundState;
    protected StructuredViewer fViewer;
    protected boolean fInputIsProject;

    public LogicalPackagesProvider(StructuredViewer structuredViewer) {
        this.fViewer = structuredViewer;
        this.fCompoundState = this.isInCompoundState();
        this.fInputIsProject = true;
        this.fMapToLogicalPackage = new HashMap();
        this.fMapToPackageFragments = new HashMap();
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void addFragmentsToMap(IPackageFragment[] iPackageFragmentArray) {
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            IPackageFragment iPackageFragment = iPackageFragmentArray[n];
            String string = this.getKey(iPackageFragment);
            this.fMapToPackageFragments.put(string, iPackageFragment);
            ++n;
        }
    }

    protected String getKey(IPackageFragment iPackageFragment) {
        return String.valueOf(iPackageFragment.getElementName()) + iPackageFragment.getJavaProject().getElementName();
    }

    public LogicalPackage findLogicalPackage(IPackageFragment iPackageFragment) {
        Assert.isNotNull((Object)iPackageFragment);
        if (this.isInCompoundState()) {
            return (LogicalPackage)((Object)this.fMapToLogicalPackage.get(this.getKey(iPackageFragment)));
        }
        return null;
    }

    protected Object[] combineSamePackagesIntoLogialPackages(IPackageFragment[] iPackageFragmentArray) {
        if (!this.fCompoundState) {
            return iPackageFragmentArray;
        }
        ArrayList<LogicalPackage> arrayList = new ArrayList<LogicalPackage>();
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            IPackageFragment iPackageFragment = iPackageFragmentArray[n];
            if (iPackageFragment != null) {
                LogicalPackage logicalPackage = this.findLogicalPackage(iPackageFragment);
                if (logicalPackage != null) {
                    if (logicalPackage.belongs(iPackageFragment)) {
                        logicalPackage.add(iPackageFragment);
                    }
                    if (!arrayList.contains((Object)logicalPackage)) {
                        arrayList.add(logicalPackage);
                    }
                } else {
                    String string = this.getKey(iPackageFragment);
                    IPackageFragment iPackageFragment2 = (IPackageFragment)this.fMapToPackageFragments.get(string);
                    if (iPackageFragment2 != null && !iPackageFragment.equals(iPackageFragment2)) {
                        logicalPackage = new LogicalPackage(iPackageFragment2);
                        logicalPackage.add(iPackageFragment);
                        arrayList.remove(iPackageFragment2);
                        arrayList.add(logicalPackage);
                        this.fMapToLogicalPackage.put(string, logicalPackage);
                        this.fMapToPackageFragments.remove(iPackageFragment2);
                    } else {
                        this.fMapToPackageFragments.put(string, iPackageFragment);
                        arrayList.add((LogicalPackage)iPackageFragment);
                    }
                }
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fCompoundState == this.isInCompoundState()) {
            return;
        }
        this.fCompoundState = this.isInCompoundState();
        if (!this.isInCompoundState()) {
            this.fMapToLogicalPackage.clear();
            this.fMapToPackageFragments.clear();
        }
        if (this.fViewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)this.fViewer;
            Object[] objectArray = treeViewer.getExpandedElements();
            treeViewer.refresh();
            treeViewer.setExpandedElements(objectArray);
        } else {
            this.fViewer.refresh();
        }
    }

    protected boolean isInCompoundState() {
        return true;
    }

    public void dispose() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fMapToLogicalPackage = null;
        this.fMapToPackageFragments = null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInputIsProject = object2 instanceof IJavaProject;
        if (viewer instanceof StructuredViewer) {
            this.fViewer = (StructuredViewer)viewer;
        }
    }

    protected abstract void processDelta(IJavaElementDelta var1) throws JavaModelException;

    protected boolean isClassPathChange(IJavaElementDelta iJavaElementDelta) {
        if (iJavaElementDelta.getElement().getElementType() != 3) {
            return false;
        }
        int n = iJavaElementDelta.getFlags();
        return iJavaElementDelta.getKind() == 4 && (n & 0x40) != 0 || (n & 0x80) != 0 || (n & 0x100) != 0;
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }
}

