/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;

class PackagesViewLabelProvider
extends AppearanceAwareLabelProvider {
    static final int HIERARCHICAL_VIEW_STATE = 0;
    static final int FLAT_VIEW_STATE = 1;
    private int fViewState;
    private ImageDescriptorRegistry fRegistry;
    private TreeHierarchyLayoutProblemsDecorator fDecorator;

    PackagesViewLabelProvider(int n) {
        this(n, 36421324767273L, 3);
    }

    PackagesViewLabelProvider(int n, long l, int n2) {
        super(l, n2);
        Assert.isTrue((boolean)this.isValidState(n));
        this.fViewState = n;
        this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        this.fDecorator = new TreeHierarchyLayoutProblemsDecorator(this.isFlatView());
        this.addLabelDecorator(this.fDecorator);
    }

    private boolean isValidState(int n) {
        return n == 1 || n == 0;
    }

    public Image getImage(Object object) {
        if (object instanceof LogicalPackage) {
            LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
            return this.getLogicalPackageImage(logicalPackage);
        }
        return super.getImage(object);
    }

    private Image getLogicalPackageImage(LogicalPackage logicalPackage) {
        IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            IPackageFragment iPackageFragment = iPackageFragmentArray[n];
            if (!this.isEmpty(iPackageFragment)) {
                return this.decorateCompoundElement(JavaPluginImages.DESC_OBJS_LOGICAL_PACKAGE, logicalPackage);
            }
            ++n;
        }
        return this.decorateCompoundElement(JavaPluginImages.DESC_OBJS_EMPTY_LOGICAL_PACKAGE, logicalPackage);
    }

    private Image decorateCompoundElement(ImageDescriptor imageDescriptor, LogicalPackage logicalPackage) {
        Image image = this.fRegistry.get(imageDescriptor);
        return this.decorateImage(image, (Object)logicalPackage);
    }

    private boolean isEmpty(IPackageFragment iPackageFragment) {
        try {
            return iPackageFragment.getCompilationUnits().length == 0 && iPackageFragment.getClassFiles().length == 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public String getText(Object object) {
        if (object instanceof IPackageFragment) {
            return this.getText((IPackageFragment)object);
        }
        if (object instanceof LogicalPackage) {
            return this.getText((LogicalPackage)((Object)object));
        }
        return super.getText(object);
    }

    public ColoredString getRichTextLabel(Object object) {
        if (object instanceof IPackageFragment || object instanceof LogicalPackage) {
            return new ColoredString(this.getText(object));
        }
        return super.getRichTextLabel(object);
    }

    private String getText(IPackageFragment iPackageFragment) {
        if (this.isFlatView()) {
            return this.getFlatText(iPackageFragment);
        }
        return this.getHierarchicalText(iPackageFragment);
    }

    private String getText(LogicalPackage logicalPackage) {
        IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
        return this.getText(iPackageFragmentArray[0]);
    }

    private String getFlatText(IPackageFragment iPackageFragment) {
        return super.getText(iPackageFragment);
    }

    private boolean isFlatView() {
        return this.fViewState == 1;
    }

    private String getHierarchicalText(IPackageFragment iPackageFragment) {
        if (iPackageFragment.isDefaultPackage()) {
            return super.getText(iPackageFragment);
        }
        IResource iResource = iPackageFragment.getResource();
        if (iResource != null && iResource.getType() != 1) {
            return this.decorateText(iResource.getName(), iPackageFragment);
        }
        return this.decorateText(this.calculateName(iPackageFragment), iPackageFragment);
    }

    private String calculateName(IPackageFragment iPackageFragment) {
        String string = iPackageFragment.getElementName();
        if (string.indexOf(".") != -1) {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        return string;
    }
}

