/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.search.LRUWorkingSetsList;
import org.eclipse.wst.jsdt.internal.ui.search.WorkingSetComparator;

public class SearchUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "CallHierarchySearchScope";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static IDialogSettings fgSettingsStore;

    public static void updateLRUWorkingSets(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray == null || iWorkingSetArray.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(iWorkingSetArray);
        SearchUtil.saveState();
    }

    private static void saveState() {
        Iterator iterator = fgLRUWorkingSets.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IWorkingSet[] iWorkingSetArray = (IWorkingSet[])iterator.next();
            String[] stringArray = new String[iWorkingSetArray.length];
            int n2 = 0;
            while (n2 < iWorkingSetArray.length) {
                stringArray[n2] = iWorkingSetArray[n2].getName();
                ++n2;
            }
            fgSettingsStore.put(STORE_LRU_WORKING_SET_NAMES + n, stringArray);
            ++n;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean bl = false;
        int n = LRU_WORKINGSET_LIST_SIZE - 1;
        while (n >= 0) {
            String[] stringArray = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES + n);
            if (stringArray != null) {
                HashSet<IWorkingSet> hashSet = new HashSet<IWorkingSet>(2);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    IWorkingSet iWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(stringArray[n2]);
                    if (iWorkingSet != null) {
                        hashSet.add(iWorkingSet);
                    }
                    ++n2;
                }
                bl = true;
                if (!hashSet.isEmpty()) {
                    fgLRUWorkingSets.add(hashSet.toArray(new IWorkingSet[hashSet.size()]));
                }
            }
            --n;
        }
        if (!bl) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean bl = false;
        String[] stringArray = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (stringArray != null) {
            int n = stringArray.length - 1;
            while (n >= 0) {
                IWorkingSet iWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(stringArray[n]);
                if (iWorkingSet != null) {
                    bl = true;
                    fgLRUWorkingSets.add(new IWorkingSet[]{iWorkingSet});
                }
                --n;
            }
        }
        if (bl) {
            SearchUtil.saveState();
        }
    }

    public static String toString(IWorkingSet[] iWorkingSetArray) {
        Arrays.sort(iWorkingSetArray, new WorkingSetComparator());
        String string = "";
        if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
            boolean bl = false;
            int n = 0;
            while (n < iWorkingSetArray.length) {
                String string2 = iWorkingSetArray[n].getLabel();
                if (bl) {
                    string = Messages.format(CallHierarchyMessages.SearchUtil_workingSetConcatenation, new String[]{string, string2});
                } else {
                    string = string2;
                    bl = true;
                }
                ++n;
            }
        }
        return string;
    }
}

