/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileDocumentSetupParticipant;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

class JavaCompareUtilities {
    private static final char PACKAGEDECLARATION = '%';
    private static final char IMPORTDECLARATION = '#';
    private static final char IMPORT_CONTAINER = '<';
    private static final char FIELD = '^';
    private static final char METHOD = '~';
    private static final char INITIALIZER = '|';
    private static final char COMPILATIONUNIT = '{';
    private static final char TYPE = '[';

    JavaCompareUtilities() {
    }

    static String getString(ResourceBundle resourceBundle, String string, String string2) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    static String getString(ResourceBundle resourceBundle, String string) {
        return JavaCompareUtilities.getString(resourceBundle, string, string);
    }

    static int getInteger(ResourceBundle resourceBundle, String string, int n) {
        if (resourceBundle != null) {
            try {
                String string2 = resourceBundle.getString(string);
                if (string2 != null) {
                    return Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return n;
    }

    static ImageDescriptor getImageDescriptor(int n) {
        switch (n) {
            case 9: 
            case 10: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_method.gif");
            }
            case 8: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_field.gif");
            }
            case 11: {
                return JavaPluginImages.DESC_OBJS_PACKDECL;
            }
            case 13: {
                return JavaPluginImages.DESC_OBJS_IMPDECL;
            }
            case 12: {
                return JavaPluginImages.DESC_OBJS_IMPCONT;
            }
            case 5: {
                return JavaPluginImages.DESC_OBJS_CUNIT;
            }
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    static ImageDescriptor getTypeImageDescriptor(boolean bl) {
        if (bl) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE;
    }

    static ImageDescriptor getEnumImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_ENUM;
    }

    static ImageDescriptor getAnnotationImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_ANNOTATION;
    }

    static ImageDescriptor getImageDescriptor(IMember iMember) {
        int n = iMember.getElementType();
        if (n == 7) {
            IType iType = (IType)iMember;
            try {
                return JavaCompareUtilities.getTypeImageDescriptor(iType.isClass());
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
                return JavaPluginImages.DESC_OBJS_GHOST;
            }
        }
        return JavaCompareUtilities.getImageDescriptor(n);
    }

    static String getJavaElementID(IJavaElement iJavaElement) {
        if (iJavaElement instanceof IMember && ((IMember)iJavaElement).isBinary()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (iJavaElement.getElementType()) {
            case 5: {
                stringBuffer.append('{');
                break;
            }
            case 7: {
                stringBuffer.append('[');
                stringBuffer.append(iJavaElement.getElementName());
                break;
            }
            case 8: {
                stringBuffer.append('^');
                stringBuffer.append(iJavaElement.getElementName());
                break;
            }
            case 9: {
                stringBuffer.append('~');
                stringBuffer.append(JavaElementLabels.getElementLabel(iJavaElement, 1L));
                break;
            }
            case 10: {
                String string = iJavaElement.getHandleIdentifier();
                int n = string.lastIndexOf(124);
                if (n < 0) break;
                stringBuffer.append(string.substring(n));
                break;
            }
            case 11: {
                stringBuffer.append('%');
                break;
            }
            case 12: {
                stringBuffer.append('<');
                break;
            }
            case 13: {
                stringBuffer.append('#');
                stringBuffer.append(iJavaElement.getElementName());
                break;
            }
            default: {
                return null;
            }
        }
        return stringBuffer.toString();
    }

    static String buildID(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: {
                stringBuffer.append('{');
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                stringBuffer.append('[');
                stringBuffer.append(string);
                break;
            }
            case 8: {
                stringBuffer.append('^');
                stringBuffer.append(string);
                break;
            }
            case 10: 
            case 11: {
                stringBuffer.append('~');
                stringBuffer.append(string);
                break;
            }
            case 9: {
                stringBuffer.append('|');
                stringBuffer.append(string);
                break;
            }
            case 1: {
                stringBuffer.append('%');
                break;
            }
            case 3: {
                stringBuffer.append('#');
                stringBuffer.append(string);
                break;
            }
            case 2: {
                stringBuffer.append('<');
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
            }
        }
        return stringBuffer.toString();
    }

    static ImageDescriptor getImageDescriptor(String string) {
        IPath iPath = JavaPluginImages.ICONS_PATH.append(string);
        return JavaPluginImages.createImageDescriptor(JavaPlugin.getDefault().getBundle(), iPath, true);
    }

    static boolean getBoolean(CompareConfiguration compareConfiguration, String string, boolean bl) {
        Object object;
        if (compareConfiguration != null && (object = compareConfiguration.getProperty(string)) instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    static Image getImage(IMember iMember) {
        ImageDescriptor imageDescriptor = JavaCompareUtilities.getImageDescriptor(iMember);
        return imageDescriptor.createImage();
    }

    static JavaTextTools getJavaTextTools() {
        JavaPlugin javaPlugin = JavaPlugin.getDefault();
        if (javaPlugin != null) {
            return javaPlugin.getJavaTextTools();
        }
        return null;
    }

    static IDocumentPartitioner createJavaPartitioner() {
        JavaTextTools javaTextTools = JavaCompareUtilities.getJavaTextTools();
        if (javaTextTools != null) {
            return javaTextTools.createDocumentPartitioner();
        }
        return null;
    }

    static void setupDocument(IDocument iDocument) {
        JavaTextTools javaTextTools = JavaCompareUtilities.getJavaTextTools();
        if (javaTextTools != null) {
            javaTextTools.setupJavaDocumentPartitioner(iDocument, "___java_partitioning");
        }
    }

    static void setupPropertiesFileDocument(IDocument iDocument) {
        PropertiesFileDocumentSetupParticipant.setupDocument(iDocument);
    }

    /*
     * Exception decompiling
     */
    private static String readString(InputStream var0, String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 109->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readString(IStreamContentAccessor iStreamContentAccessor) throws CoreException {
        InputStream inputStream = iStreamContentAccessor.getContents();
        if (inputStream != null) {
            String string = null;
            if (iStreamContentAccessor instanceof IEncodedStreamContentAccessor) {
                try {
                    string = ((IEncodedStreamContentAccessor)iStreamContentAccessor).getCharset();
                }
                catch (Exception exception) {}
            }
            if (string == null) {
                string = ResourcesPlugin.getEncoding();
            }
            return JavaCompareUtilities.readString(inputStream, string);
        }
        return null;
    }

    static byte[] getBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] readLines(InputStream inputStream, String string) {
        String[] stringArray;
        BufferedReader bufferedReader = null;
        try {
            try {
                int n;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
                StringBuffer stringBuffer = new StringBuffer();
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((n = bufferedReader.read()) != -1) {
                    stringBuffer.append((char)n);
                    if (n == 13) {
                        n = bufferedReader.read();
                        if (n == -1) break;
                        stringBuffer.append((char)n);
                        if (n != 10) continue;
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                    if (n != 10) continue;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
                Object var6_7 = null;
                if (bufferedReader == null) return stringArray;
            }
            catch (IOException iOException) {
                Object var6_8 = null;
                if (bufferedReader == null) return null;
                try {
                    bufferedReader.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (bufferedReader == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            bufferedReader.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return stringArray;
    }

    static void initAction(IAction iAction, ResourceBundle resourceBundle, String string) {
        String string2 = "label";
        String string3 = "tooltip";
        String string4 = "image";
        String string5 = "description";
        if (string != null && string.length() > 0) {
            string2 = String.valueOf(string) + string2;
            string3 = String.valueOf(string) + string3;
            string4 = String.valueOf(string) + string4;
            string5 = String.valueOf(string) + string5;
        }
        iAction.setText(JavaCompareUtilities.getString(resourceBundle, string2, string2));
        iAction.setToolTipText(JavaCompareUtilities.getString(resourceBundle, string3, null));
        iAction.setDescription(JavaCompareUtilities.getString(resourceBundle, string5, null));
        String string6 = JavaCompareUtilities.getString(resourceBundle, string4, null);
        if (string6 != null && string6.trim().length() > 0) {
            String string7;
            String string8;
            String string9;
            if (string6.indexOf("/") >= 0) {
                string9 = string6.substring(1);
                string8 = String.valueOf('d') + string9;
                string7 = String.valueOf('e') + string9;
            } else {
                string8 = "dlcl16/" + string6;
                string7 = "elcl16/" + string6;
            }
            string9 = JavaCompareUtilities.getImageDescriptor(string8);
            if (string9 != null) {
                iAction.setDisabledImageDescriptor((ImageDescriptor)string9);
            }
            if ((string9 = JavaCompareUtilities.getImageDescriptor(string7)) != null) {
                iAction.setImageDescriptor((ImageDescriptor)string9);
                iAction.setHoverImageDescriptor((ImageDescriptor)string9);
            }
        }
    }

    static void initToggleAction(IAction iAction, ResourceBundle resourceBundle, String string, boolean bl) {
        String string2 = null;
        string2 = bl ? JavaCompareUtilities.getString(resourceBundle, String.valueOf(string) + "tooltip.checked", null) : JavaCompareUtilities.getString(resourceBundle, String.valueOf(string) + "tooltip.unchecked", null);
        if (string2 == null) {
            string2 = JavaCompareUtilities.getString(resourceBundle, String.valueOf(string) + "tooltip", null);
        }
        if (string2 != null) {
            iAction.setToolTipText(string2);
        }
        String string3 = null;
        string3 = bl ? JavaCompareUtilities.getString(resourceBundle, String.valueOf(string) + "description.checked", null) : JavaCompareUtilities.getString(resourceBundle, String.valueOf(string) + "description.unchecked", null);
        if (string3 == null) {
            string3 = JavaCompareUtilities.getString(resourceBundle, String.valueOf(string) + "description", null);
        }
        if (string3 != null) {
            iAction.setDescription(string3);
        }
    }
}

