/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaNode;

class JavaParseTreeBuilder
extends ASTVisitor {
    private char[] fBuffer;
    private Stack fStack = new Stack();
    private JavaNode fImportContainer;
    private boolean fShowCU;

    JavaParseTreeBuilder(JavaNode javaNode, char[] cArray, boolean bl) {
        this.fBuffer = cArray;
        this.fShowCU = bl;
        this.fStack.clear();
        this.fStack.push(javaNode);
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        new JavaNode(this.getCurrentContainer(), 1, null, packageDeclaration.getStartPosition(), packageDeclaration.getLength());
        return false;
    }

    public boolean visit(CompilationUnit compilationUnit) {
        if (this.fShowCU) {
            this.push(0, null, compilationUnit.getStartPosition(), compilationUnit.getLength());
        }
        return true;
    }

    public void endVisit(CompilationUnit compilationUnit) {
        if (this.fShowCU) {
            this.pop();
        }
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        this.push(typeDeclaration.isInterface() ? 4 : 5, typeDeclaration.getName().toString(), typeDeclaration.getStartPosition(), typeDeclaration.getLength());
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        this.pop();
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        this.push(6, enumDeclaration.getName().toString(), enumDeclaration.getStartPosition(), enumDeclaration.getLength());
        return true;
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        this.pop();
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.push(7, annotationTypeDeclaration.getName().toString(), annotationTypeDeclaration.getStartPosition(), annotationTypeDeclaration.getLength());
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.pop();
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        this.push(11, this.getSignature(annotationTypeMemberDeclaration), annotationTypeMemberDeclaration.getStartPosition(), annotationTypeMemberDeclaration.getLength());
        return true;
    }

    public void endVisit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        this.pop();
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        String string = this.getSignature(methodDeclaration);
        this.push(methodDeclaration.isConstructor() ? 10 : 11, string, methodDeclaration.getStartPosition(), methodDeclaration.getLength());
        return false;
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        this.pop();
    }

    public boolean visit(Initializer initializer) {
        this.push(9, this.getCurrentContainer().getInitializerCount(), initializer.getStartPosition(), initializer.getLength());
        return false;
    }

    public void endVisit(Initializer initializer) {
        this.pop();
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        int n = importDeclaration.getStartPosition();
        int n2 = importDeclaration.getLength();
        int n3 = n + n2;
        if (this.fImportContainer == null) {
            this.fImportContainer = new JavaNode(this.getCurrentContainer(), 2, null, n, n2);
        }
        String string = importDeclaration.getName().toString();
        if (importDeclaration.isOnDemand()) {
            string = String.valueOf(string) + ".*";
        }
        new JavaNode(this.fImportContainer, 3, string, n, n2);
        this.fImportContainer.setLength(n3 - this.fImportContainer.getRange().getOffset() + 1);
        this.fImportContainer.setAppendPosition(n3 + 2);
        return false;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        String string = this.getFieldName(variableDeclarationFragment);
        ASTNode aSTNode = variableDeclarationFragment.getParent();
        this.push(8, string, aSTNode.getStartPosition(), aSTNode.getLength());
        return false;
    }

    public void endVisit(VariableDeclarationFragment variableDeclarationFragment) {
        this.pop();
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        this.push(8, enumConstantDeclaration.getName().toString(), enumConstantDeclaration.getStartPosition(), enumConstantDeclaration.getLength());
        return false;
    }

    public void endVisit(EnumConstantDeclaration enumConstantDeclaration) {
        this.pop();
    }

    private void push(int n, String string, int n2, int n3) {
        while (n2 > 0) {
            char c = this.fBuffer[n2 - 1];
            if (c != ' ' && c != '\t') break;
            --n2;
            ++n3;
        }
        JavaNode javaNode = new JavaNode(this.getCurrentContainer(), n, string, n2, n3);
        if (n == 0) {
            javaNode.setAppendPosition(n2 + n3 + 1);
        } else {
            javaNode.setAppendPosition(n2 + n3);
        }
        this.fStack.push(javaNode);
    }

    private void pop() {
        this.fStack.pop();
    }

    private JavaNode getCurrentContainer() {
        return (JavaNode)((Object)this.fStack.peek());
    }

    private String getFieldName(VariableDeclarationFragment variableDeclarationFragment) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(variableDeclarationFragment.getName().toString());
        ASTNode aSTNode = variableDeclarationFragment.getParent();
        if (aSTNode instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode;
            stringBuffer.append(" : ");
            stringBuffer.append(this.getType(fieldDeclaration.getType()));
        }
        return stringBuffer.toString();
    }

    private String getSignature(MethodDeclaration methodDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleName simpleName = methodDeclaration.getName();
        if (simpleName != null) {
            stringBuffer.append(simpleName.toString());
        }
        stringBuffer.append('(');
        boolean bl = true;
        Iterator iterator = methodDeclaration.parameters().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SingleVariableDeclaration)) continue;
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)e;
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getType(singleVariableDeclaration.getType()));
            if (singleVariableDeclaration.isVarargs()) {
                stringBuffer.append("...");
            }
            bl = false;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private String getSignature(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(annotationTypeMemberDeclaration.getName().toString());
        stringBuffer.append('(');
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private String getType(Type type) {
        String string = type.toString();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }
}

