/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaNode;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaStructureCreator;

class JavaStructureDiffViewer
extends StructureDiffViewer {
    private static final String SMART = "SMART";
    private ActionContributionItem fSmartActionItem;
    private JavaStructureCreator fStructureCreator = new JavaStructureCreator();
    private boolean fThreeWay;

    public JavaStructureDiffViewer(Composite composite, CompareConfiguration compareConfiguration) {
        super(composite, compareConfiguration);
        this.setStructureCreator((IStructureCreator)this.fStructureCreator);
    }

    protected void initialSelection() {
        Object[] objectArray;
        DiffNode diffNode = null;
        Object object = this.getRoot();
        if (object != null && (objectArray = this.getSortedChildren(object)) != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                Object[] objectArray2 = this.getSortedChildren(object);
                if (objectArray2 != null && objectArray2.length > 0) {
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        JavaNode javaNode;
                        int n3;
                        DiffNode diffNode2;
                        ITypedElement iTypedElement;
                        object = objectArray2[n2];
                        if (object instanceof DiffNode && (iTypedElement = (diffNode2 = (DiffNode)object).getId()) instanceof JavaNode && ((n3 = (javaNode = (JavaNode)iTypedElement).getTypeCode()) == 5 || n3 == 4)) {
                            diffNode = diffNode2;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (diffNode != null) {
            this.expandToLevel(diffNode, 1);
        } else {
            this.expandToLevel(2);
        }
    }

    protected void compareInputChanged(ICompareInput iCompareInput) {
        this.fThreeWay = iCompareInput != null ? iCompareInput.getAncestor() != null : false;
        this.setSmartButtonVisible(this.fThreeWay);
        if (iCompareInput != null) {
            Map map = this.getCompilerOptions(iCompareInput.getAncestor());
            if (map == null) {
                map = this.getCompilerOptions(iCompareInput.getLeft());
            }
            if (map == null) {
                map = this.getCompilerOptions(iCompareInput.getRight());
            }
            if (map != null) {
                this.fStructureCreator.setDefaultCompilerOptions(map);
            }
        }
        super.compareInputChanged(iCompareInput);
    }

    private Map getCompilerOptions(ITypedElement iTypedElement) {
        IJavaProject iJavaProject;
        IJavaElement iJavaElement;
        IResource iResource;
        if (iTypedElement instanceof IResourceProvider && (iResource = ((IResourceProvider)iTypedElement).getResource()) != null && (iJavaElement = JavaCore.create((IResource)iResource)) != null && (iJavaProject = iJavaElement.getJavaProject()) != null) {
            return iJavaProject.getOptions(true);
        }
        return null;
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        ChangePropertyAction changePropertyAction = new ChangePropertyAction(this.getBundle(), this.getCompareConfiguration(), "action.Smart.", SMART);
        this.fSmartActionItem = new ActionContributionItem((IAction)changePropertyAction);
        this.fSmartActionItem.setVisible(this.fThreeWay);
        toolBarManager.appendToGroup("modes", (IContributionItem)this.fSmartActionItem);
    }

    protected void postDiffHook(Differencer differencer, IDiffContainer iDiffContainer, IProgressMonitor iProgressMonitor) {
        boolean bl;
        if (this.fStructureCreator.canRewriteTree() && (bl = JavaCompareUtilities.getBoolean(this.getCompareConfiguration(), SMART, false)) && iDiffContainer != null) {
            this.fStructureCreator.rewriteTree(differencer, iDiffContainer);
        }
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals(SMART)) {
            this.diff();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    private void setSmartButtonVisible(boolean bl) {
        if (this.fSmartActionItem == null) {
            return;
        }
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.fSmartActionItem.setVisible(bl);
        ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)control.getParent());
        if (toolBarManager != null) {
            toolBarManager.update(true);
            ToolBar toolBar = toolBarManager.getControl();
            if (!toolBar.isDisposed()) {
                toolBar.getParent().layout(true);
            }
        }
    }

    static class ChangePropertyAction
    extends Action {
        private CompareConfiguration fCompareConfiguration;
        private String fPropertyKey;
        private ResourceBundle fBundle;
        private String fPrefix;

        public ChangePropertyAction(ResourceBundle resourceBundle, CompareConfiguration compareConfiguration, String string, String string2) {
            this.fPropertyKey = string2;
            this.fBundle = resourceBundle;
            this.fPrefix = string;
            JavaCompareUtilities.initAction((IAction)this, this.fBundle, this.fPrefix);
            this.setCompareConfiguration(compareConfiguration);
        }

        public void run() {
            boolean bl = !JavaCompareUtilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false);
            this.setChecked(bl);
            if (this.fCompareConfiguration != null) {
                this.fCompareConfiguration.setProperty(this.fPropertyKey, (Object)new Boolean(bl));
            }
        }

        public void setChecked(boolean bl) {
            super.setChecked(bl);
            JavaCompareUtilities.initToggleAction((IAction)this, this.fBundle, this.fPrefix, bl);
        }

        public void setCompareConfiguration(CompareConfiguration compareConfiguration) {
            this.fCompareConfiguration = compareConfiguration;
            this.setChecked(JavaCompareUtilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false));
        }
    }
}

