/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;

public class GenerateHashCodeEqualsDialog
extends SourceActionDialog {
    private static final String SETTINGS_INSTANCEOF = "InstanceOf";
    private boolean fUseInstanceOf;

    public GenerateHashCodeEqualsDialog(Shell shell, CompilationUnitEditor compilationUnitEditor, IType iType, IVariableBinding[] iVariableBindingArray, IVariableBinding[] iVariableBindingArray2) throws JavaModelException {
        super(shell, (ILabelProvider)new BindingLabelProvider(), new GenerateHashCodeEqualsContentProvider(iVariableBindingArray), compilationUnitEditor, iType, false);
        this.setEmptyListMessage(JavaUIMessages.GenerateHashCodeEqualsDialog_no_entries);
        this.setInitialSelections(iVariableBindingArray2);
        this.setTitle(JavaUIMessages.GenerateHashCodeEqualsDialog_dialog_title);
        this.setMessage(JavaUIMessages.GenerateHashCodeEqualsDialog_select_fields_to_include);
        this.setValidator(new GenerateHashCodeEqualsValidator(iVariableBindingArray.length));
        this.setSize(60, 18);
        this.setInput(new Object());
        this.fUseInstanceOf = this.asBoolean(this.getDialogSettings().get(SETTINGS_INSTANCEOF), false);
    }

    public boolean close() {
        this.getDialogSettings().put(SETTINGS_INSTANCEOF, this.fUseInstanceOf);
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.hash_code_equals_tree_selection_dialog_context");
    }

    protected Composite createCommentSelection(Composite composite) {
        Composite composite2 = super.createCommentSelection(composite);
        Button button = new Button(composite2, 32);
        button.setText(JavaUIMessages.GenerateHashCodeEqualsDialog_instanceof_button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GenerateHashCodeEqualsDialog.this.setUseInstanceOf(((Button)selectionEvent.widget).getSelection());
            }
        });
        button.setSelection(this.isUseInstanceOf());
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        return composite2;
    }

    public boolean isUseInstanceOf() {
        return this.fUseInstanceOf;
    }

    public void setUseInstanceOf(boolean bl) {
        this.fUseInstanceOf = bl;
    }

    private static class GenerateHashCodeEqualsContentProvider
    implements ITreeContentProvider {
        IVariableBinding[] fBindings;

        public GenerateHashCodeEqualsContentProvider(IVariableBinding[] iVariableBindingArray) {
            this.fBindings = iVariableBindingArray;
        }

        public void dispose() {
        }

        public Object[] getChildren(Object object) {
            return new Object[0];
        }

        public Object[] getElements(Object object) {
            return this.fBindings;
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class GenerateHashCodeEqualsValidator
    implements ISelectionStatusValidator {
        private static int fNumFields;

        public GenerateHashCodeEqualsValidator(int n) {
            fNumFields = n;
        }

        public IStatus validate(Object[] objectArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof IVariableBinding) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                return new StatusInfo(4, JavaUIMessages.GenerateHashCodeEqualsDialog_select_at_least_one_field);
            }
            return new StatusInfo(1, Messages.format(JavaUIMessages.GenerateHashCodeEqualsDialog_selectioninfo_more, new String[]{String.valueOf(n), String.valueOf(fNumFields)}));
        }
    }
}

