/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ListDialog
extends SelectionDialog {
    private IStructuredContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private Object fInput;
    private TableViewer fTableViewer;
    private boolean fAddCancelButton = false;
    private final int fShellStyle;

    public ListDialog(Shell shell, int n) {
        super(shell);
        this.fShellStyle = n;
    }

    public void setInput(Object object) {
        this.fInput = object;
    }

    public void setContentProvider(IStructuredContentProvider iStructuredContentProvider) {
        this.fContentProvider = iStructuredContentProvider;
    }

    public void setLabelProvider(ILabelProvider iLabelProvider) {
        this.fLabelProvider = iLabelProvider;
    }

    public void setAddCancelButton(boolean bl) {
        this.fAddCancelButton = bl;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public boolean hasFilters() {
        return this.fTableViewer.getFilters() != null && this.fTableViewer.getFilters().length != 0;
    }

    public void create() {
        this.setShellStyle(this.fShellStyle);
        super.create();
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText(this.getMessage());
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(55);
        label.setLayoutData((Object)gridData);
        ListDialog.applyDialogFont((Control)label);
        return label;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.fTableViewer = new TableViewer(composite2, this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        Table table = this.fTableViewer.getTable();
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTableViewer.setInput(this.fInput);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(55);
        gridData.heightHint = this.convertHeightInCharsToPixels(15);
        table.setLayoutData((Object)gridData);
        ListDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        if (!this.fAddCancelButton) {
            this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(composite);
        }
    }

    protected int getTableStyle() {
        return 2820;
    }
}

