/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.CodeFormatFix;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CodeFormatCleanUp
extends AbstractCleanUp {
    public CodeFormatCleanUp() {
    }

    public CodeFormatCleanUp(Map map) {
        super(map);
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        return false;
    }

    public IFix createFix(ICompilationUnit iCompilationUnit) throws CoreException {
        if (iCompilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.remove_trailing_whitespaces");
        return CodeFormatFix.createCleanUp(iCompilationUnit, this.isEnabled("cleanup.format_source_code"), bl && this.isEnabled("cleanup.remove_trailing_whitespaces_all"), bl && this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty"));
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return null;
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.format_source_code")) {
            arrayList.add(MultiFixMessages.CodeFormatCleanUp_description);
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            if (this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
                arrayList.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingAll_description);
            } else if (this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty")) {
                arrayList.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingNoEmpty_description);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  function start() {}\n");
        if (this.isEnabled("cleanup.remove_trailing_whitespaces") && this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("    \n");
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            stringBuffer.append("    function\n");
        } else {
            stringBuffer.append("    function \n");
        }
        stringBuffer.append("        stop() {\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        return false;
    }
}

