/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.CodeStyleFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CodeStyleCleanUp
extends AbstractCleanUp {
    public CodeStyleCleanUp() {
        this(null);
    }

    public CodeStyleCleanUp(Map map) {
        super(map);
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        boolean bl = this.isEnabled("cleanup.use_this_for_non_static_field_access");
        boolean bl2 = this.isEnabled("cleanup.use_this_for_non_static_method_access");
        boolean bl3 = this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class");
        return bl && this.isEnabled("cleanup.always_use_this_for_non_static_field_access") || bl3 && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class") || bl3 && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class") || bl3 && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class") || bl2 && this.isEnabled("cleanup.always_use_this_for_non_static_method_access") || bl3 && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class") || bl && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary") || bl2 && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.use_this_for_non_static_field_access");
        boolean bl2 = this.isEnabled("cleanup.use_this_for_non_static_method_access");
        boolean bl3 = this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class");
        return CodeStyleFix.createCleanUp(compilationUnit, bl && this.isEnabled("cleanup.always_use_this_for_non_static_field_access"), bl3 && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class"), bl3 && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class"), bl3 && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class"), bl2 && this.isEnabled("cleanup.always_use_this_for_non_static_method_access"), bl3 && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class"), bl && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary"), bl2 && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return CodeStyleFix.createCleanUp(compilationUnit, iProblemLocationArray, this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access"), this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class"), this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", "warning");
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", "warning");
        }
        return hashtable;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            arrayList.add(MultiFixMessages.CodeStyleMultiFix_AddThisQualifier_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.always_use_this_for_non_static_method_access")) {
            arrayList.add(MultiFixMessages.CodeStyleCleanUp_QualifyNonStaticMethod_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary")) {
            arrayList.add(MultiFixMessages.CodeStyleCleanUp_removeFieldThis_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary")) {
            arrayList.add(MultiFixMessages.CodeStyleCleanUp_removeMethodThis_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class")) {
            arrayList.add(MultiFixMessages.CodeStyleMultiFix_QualifyAccessToStaticField);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class")) {
            arrayList.add(MultiFixMessages.CodeStyleCleanUp_QualifyStaticMethod_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            arrayList.add(MultiFixMessages.CodeStyleMultiFix_ChangeNonStaticAccess_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            arrayList.add(MultiFixMessages.CodeStyleMultiFix_ChangeIndirectAccessToStaticToDirect);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("private int value;\n");
        stringBuffer.append("public int get() {\n");
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            stringBuffer.append("    return this.value + this.value;\n");
        } else if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary")) {
            stringBuffer.append("    return value + value;\n");
        } else {
            stringBuffer.append("    return this.value + value;\n");
        }
        stringBuffer.append("}\n");
        stringBuffer.append("\n");
        stringBuffer.append("public int getZero() {\n");
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.always_use_this_for_non_static_method_access")) {
            stringBuffer.append("    return this.get() - this.get();\n");
        } else if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary")) {
            stringBuffer.append("    return get() - get();\n");
        } else {
            stringBuffer.append("    return this.get() - get();\n");
        }
        stringBuffer.append("}\n");
        stringBuffer.append("\n");
        stringBuffer.append("class E {\n");
        stringBuffer.append("    public static int NUMBER;\n");
        stringBuffer.append("    public static void set(int i) {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class")) {
            stringBuffer.append("        E.NUMBER= i;\n");
        } else {
            stringBuffer.append("        NUMBER= i;\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    public void reset() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class")) {
            stringBuffer.append("        E.set(0);\n");
        } else {
            stringBuffer.append("        set(0);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("}\n");
        stringBuffer.append("\n");
        stringBuffer.append("class ESub extends E {\n");
        stringBuffer.append("    public void reset() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            stringBuffer.append("        E.NUMBER= 0;\n");
        } else {
            stringBuffer.append("        ESub.NUMBER= 0;\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("}\n");
        stringBuffer.append("\n");
        stringBuffer.append("public void dec() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            stringBuffer.append("    E.NUMBER--;\n");
        } else {
            stringBuffer.append("    (new E()).NUMBER--;\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        CodeStyleFix[] codeStyleFixArray;
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access") && (codeStyleFixArray = CodeStyleFix.createAddFieldQualifierFix(compilationUnit, iProblemLocation)) != null) {
            return true;
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class") && (codeStyleFixArray = CodeStyleFix.createIndirectAccessToStaticFix(compilationUnit, iProblemLocation)) != null) {
            return true;
        }
        return this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class") && (codeStyleFixArray = CodeStyleFix.createNonStaticAccessFixes(compilationUnit, iProblemLocation)) != null && codeStyleFixArray.length > 0;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int n;
        int n2;
        int n3 = 0;
        IProblem[] iProblemArray = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            n3 += this.getNumberOfProblems(iProblemArray, 570425423);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            n2 = 0;
            while (n2 < iProblemArray.length) {
                n = iProblemArray[n2].getID();
                if (n == 570425422 || n == 603979895) {
                    ++n3;
                }
                ++n2;
            }
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            n2 = 0;
            while (n2 < iProblemArray.length) {
                n = iProblemArray[n2].getID();
                if (n == 570425420 || n == 603979893) {
                    ++n3;
                }
                ++n2;
            }
        }
        return n3;
    }
}

