/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.ExpressionsFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ExpressionsCleanUp
extends AbstractCleanUp {
    public ExpressionsCleanUp(Map map) {
        super(map);
    }

    public ExpressionsCleanUp() {
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        boolean bl = this.isEnabled("cleanup.use_parentheses_in_expressions");
        if (!bl) {
            return false;
        }
        return this.isEnabled("cleanup.always_use_parentheses_in_expressions") || this.isEnabled("cleanup.never_use_parentheses_in_expressions");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.use_parentheses_in_expressions");
        if (!bl) {
            return null;
        }
        return ExpressionsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.always_use_parentheses_in_expressions"), this.isEnabled("cleanup.never_use_parentheses_in_expressions"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        return this.createFix(compilationUnit);
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions")) {
            arrayList.add(MultiFixMessages.ExpressionsCleanUp_addParanoiac_description);
        }
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions")) {
            arrayList.add(MultiFixMessages.ExpressionsCleanUp_removeUnnecessary_description);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions")) {
            stringBuffer.append("var b= (((i > 0) && (i < 10)) || (i == 50));\n");
        } else if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions")) {
            stringBuffer.append("var b= i > 0 && i < 10 || i == 50;\n");
        } else {
            stringBuffer.append("var b= (i > 0 && i < 10 || i == 50);\n");
        }
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        IFix iFix;
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions") && (iFix = ExpressionsFix.createAddParanoidalParenthesisFix(compilationUnit, new ASTNode[]{iProblemLocation.getCoveredNode(compilationUnit)})) != null) {
            return true;
        }
        return this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions") && (iFix = ExpressionsFix.createRemoveUnnecessaryParenthesisFix(compilationUnit, new ASTNode[]{iProblemLocation.getCoveredNode(compilationUnit)})) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }
}

