/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.infoviews;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.wst.jsdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.wst.jsdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavadocContentAccess;
import org.osgi.framework.Bundle;

public class JavadocView
extends AbstractInfoView {
    private static final String DO_NOT_WARN_PREFERENCE_KEY = "JavadocView.error.doNotWarn";
    private static final boolean WARNING_DIALOG_ENABLED = false;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;
    private Browser fBrowser;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private SelectAllAction fSelectAllAction;
    private static String fgStyleSheet;
    private static boolean fgStyleSheetLoaded;
    private boolean fIsUsingBrowserWidget;
    private RGB fBackgroundColorRGB;
    private IPropertyChangeListener fFontListener;

    static {
        fgStyleSheetLoaded = false;
    }

    protected void internalCreatePartControl(Composite composite) {
        try {
            this.fBrowser = new Browser(composite, 0);
            this.fIsUsingBrowserWidget = true;
        }
        catch (SWTError sWTError) {
            IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.getBoolean(DO_NOT_WARN_PREFERENCE_KEY);
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(composite, 768);
            this.fText.setEditable(false);
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    JavadocView.this.setInput(JavadocView.this.fText.getText());
                }
            });
        }
        JavadocView.initStyleSheet();
        this.listenForFontChanges();
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.getControl()));
    }

    private void listenForFontChanges() {
        this.fFontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.eclipse.wst.jsdt.ui.javadocfont".equals(propertyChangeEvent.getProperty())) {
                    fgStyleSheetLoaded = false;
                    Display display = JavadocView.this.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(this, display){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ Display val$display;
                            {
                                this.this$1 = var1_1;
                                this.val$display = display;
                            }

                            public void run() {
                                if (!this.val$display.isDisposed()) {
                                    JavadocView.access$3();
                                    JavadocView.access$4(3.access$0(this.this$1));
                                }
                            }
                        });
                    }
                }
            }

            static /* synthetic */ JavadocView access$0(3 var0) {
                return var0.JavadocView.this;
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontListener);
    }

    private static void initStyleSheet() {
        if (fgStyleSheetLoaded) {
            return;
        }
        fgStyleSheetLoaded = true;
        fgStyleSheet = JavadocView.loadStyleSheet();
    }

    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL uRL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (uRL == null) {
            return null;
        }
        try {
            uRL = FileLocator.toFileURL((URL)uRL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringBuffer stringBuffer = new StringBuffer(200);
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
                string = bufferedReader.readLine();
            }
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.wst.jsdt.ui.javadocfont")[0];
            return HTMLPrinter.convertTopLevelFont((String)stringBuffer.toString(), (FontData)fontData);
        }
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
            return null;
        }
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction(this.getControl(), (SelectionProvider)this.getSelectionProvider());
    }

    protected IAction getSelectAllAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return this.fSelectAllAction;
    }

    protected IAction getCopyToClipboardAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return super.getCopyToClipboardAction();
    }

    protected void setForeground(Color color) {
        this.getControl().setForeground(color);
    }

    protected void setBackground(Color color) {
        this.getControl().setBackground(color);
        this.fBackgroundColorRGB = color.getRGB();
        this.refresh();
    }

    private void refresh() {
        IJavaElement iJavaElement = this.getInput();
        if (iJavaElement == null) {
            StringBuffer stringBuffer = new StringBuffer("");
            HTMLPrinter.insertPageProlog((StringBuffer)stringBuffer, (int)0, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            this.setInput(stringBuffer.toString());
        } else {
            this.setInput(this.computeInput(iJavaElement));
        }
    }

    protected String getBackgroundColorKey() {
        return "org.eclipse.wst.jsdt.ui.JavadocView.backgroundColor";
    }

    protected void internalDispose() {
        this.fText = null;
        this.fBrowser = null;
        if (this.fFontListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fFontListener);
            this.fFontListener = null;
        }
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    protected Object computeInput(Object object) {
        String string;
        if (this.getControl() == null || !(object instanceof IJavaElement)) {
            return null;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        switch (iJavaElement.getElementType()) {
            case 5: {
                try {
                    string = this.getJavadocHtml((IJavaElement[])((ICompilationUnit)iJavaElement).getTypes());
                }
                catch (JavaModelException javaModelException) {
                    string = null;
                }
                break;
            }
            case 6: {
                string = this.getJavadocHtml(new IJavaElement[]{((IClassFile)iJavaElement).getType()});
                break;
            }
            default: {
                string = this.getJavadocHtml(new IJavaElement[]{iJavaElement});
            }
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    protected void setInput(Object object) {
        String string = (String)object;
        if (this.fIsUsingBrowserWidget) {
            if (string != null && string.length() > 0) {
                boolean bl;
                boolean bl2 = bl = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    HTMLPrinter.insertStyles((StringBuffer)stringBuffer, (String[])new String[]{"direction:rtl"});
                    string = stringBuffer.toString();
                }
            }
            this.fBrowser.setText(string);
        } else {
            this.fPresentation.clear();
            Rectangle rectangle = this.fText.getClientArea();
            try {
                string = ((DefaultInformationControl.IInformationPresenterExtension)this.fPresenter).updatePresentation((Drawable)this.getSite().getShell(), string, this.fPresentation, rectangle.width, rectangle.height);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.fText.setText(string);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    private String getJavadocHtml(IJavaElement[] iJavaElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = iJavaElementArray.length;
        if (n == 0) {
            return null;
        }
        if (n > 1) {
            int n2 = 0;
            while (n2 < iJavaElementArray.length) {
                HTMLPrinter.startBulletList((StringBuffer)stringBuffer);
                IJavaElement iJavaElement = iJavaElementArray[n2];
                if (iJavaElement instanceof IMember) {
                    HTMLPrinter.addBullet((StringBuffer)stringBuffer, (String)this.getInfoText((IMember)iJavaElement));
                }
                HTMLPrinter.endBulletList((StringBuffer)stringBuffer);
                ++n2;
            }
        } else {
            IJavaElement iJavaElement = iJavaElementArray[0];
            if (iJavaElement instanceof IMember) {
                Reader reader;
                IMember iMember = (IMember)iJavaElement;
                try {
                    reader = JavadocContentAccess.getHTMLContentReader(iMember, true, true);
                    if (reader == null && iMember.isBinary()) {
                        boolean bl;
                        boolean bl2 = JavaDocLocations.getJavadocBaseLocation((IJavaElement)iMember) != null;
                        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iMember.getAncestor(3);
                        boolean bl3 = iPackageFragmentRoot != null && iPackageFragmentRoot.getSourceAttachmentPath() != null;
                        IOpenable iOpenable = iMember.getOpenable();
                        boolean bl4 = bl = iOpenable.getBuffer() != null;
                        if (!bl3 && !bl2) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachments);
                        } else if (!bl2 && !bl) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachedJavadoc);
                        } else if (!bl3) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachedSource);
                        } else if (!bl) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noInformation);
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    reader = new StringReader(InfoViewMessages.JavadocView_error_gettingJavadoc);
                    JavaPlugin.log(javaModelException.getStatus());
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (Reader)reader);
                }
            }
        }
        boolean bl = true;
        if (stringBuffer.length() > 0 || bl) {
            HTMLPrinter.insertPageProlog((StringBuffer)stringBuffer, (int)0, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
            return stringBuffer.toString();
        }
        return null;
    }

    private String getInfoText(IMember iMember) {
        return JavaElementLabels.getElementLabel((IJavaElement)iMember, LABEL_FLAGS);
    }

    protected boolean isIgnoringNewInput(IJavaElement iJavaElement, IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (super.isIgnoringNewInput(iJavaElement, iWorkbenchPart, iSelection) && iWorkbenchPart instanceof ITextEditor && iSelection instanceof ITextSelection) {
            ITextEditor iTextEditor = (ITextEditor)iWorkbenchPart;
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            if (iDocumentProvider == null) {
                return false;
            }
            IDocument iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
            if (!(iDocument instanceof IDocumentExtension3)) {
                return false;
            }
            try {
                int n = ((ITextSelection)iSelection).getOffset();
                String string = ((IDocumentExtension3)iDocument).getContentType("___java_partitioning", n, false);
                return string != "__java_javadoc";
            }
            catch (BadPartitioningException badPartitioningException) {
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IJavaElement iJavaElement;
        block7: {
            IDocument iDocument;
            ITextSelection iTextSelection;
            block9: {
                IDocumentProvider iDocumentProvider;
                JavaEditor javaEditor;
                block8: {
                    iJavaElement = super.findSelectedJavaElement(iWorkbenchPart, iSelection);
                    if (iJavaElement != null || !(iWorkbenchPart instanceof JavaEditor) || !(iSelection instanceof ITextSelection)) break block7;
                    javaEditor = (JavaEditor)iWorkbenchPart;
                    iTextSelection = (ITextSelection)iSelection;
                    iDocumentProvider = javaEditor.getDocumentProvider();
                    if (iDocumentProvider != null) break block8;
                    return null;
                }
                iDocument = iDocumentProvider.getDocument((Object)javaEditor.getEditorInput());
                if (iDocument != null) break block9;
                return null;
            }
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)"___java_partitioning", (int)iTextSelection.getOffset(), (boolean)false);
            if ("__java_javadoc".equals(iTypedRegion.getType())) {
                return TextSelectionConverter.getElementAtOffset((JavaEditor)iWorkbenchPart, iTextSelection);
            }
            return null;
        }
        try {
            return iJavaElement;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.javadoc_view_context";
    }

    static /* synthetic */ void access$3() {
        JavadocView.initStyleSheet();
    }

    static /* synthetic */ void access$4(JavadocView javadocView) {
        javadocView.refresh();
    }

    private class SelectAllAction
    extends Action {
        private Control fControl;
        private SelectionProvider fSelectionProvider;

        public SelectAllAction(Control control, SelectionProvider selectionProvider) {
            super("selectAll");
            Assert.isNotNull((Object)control);
            Assert.isNotNull((Object)selectionProvider);
            this.fControl = control;
            this.fSelectionProvider = selectionProvider;
            this.setEnabled(!JavadocView.this.fIsUsingBrowserWidget);
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).selectAll();
            } else if (this.fSelectionProvider != null) {
                this.fSelectionProvider.fireSelectionChanged();
            }
        }
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList(1);
        private Control fControl;

        public SelectionProvider(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectionProvider this$1;
                    {
                        this.this$1 = selectionProvider;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        this.this$1.fireSelectionChanged();
                    }
                });
            }
        }

        public void fireSelectionChanged() {
            ISelection iSelection = this.getSelection();
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ISelectionChangedListener)objectArray[n]).selectionChanged(selectionChangedEvent);
                ++n;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fListeners.add((Object)iSelectionChangedListener);
        }

        public ISelection getSelection() {
            if (this.fControl instanceof StyledText) {
                Document document = new Document(((StyledText)this.fControl).getSelectionText());
                return new TextSelection((IDocument)document, 0, document.getLength());
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fListeners.remove((Object)iSelectionChangedListener);
        }

        public void setSelection(ISelection iSelection) {
        }
    }
}

