/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.infoviews;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;

class TextSelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private TextSelectionConverter() {
    }

    public static IJavaElement[] codeResolve(JavaEditor javaEditor, ITextSelection iTextSelection) throws JavaModelException {
        return TextSelectionConverter.codeResolve(TextSelectionConverter.getInput(javaEditor), iTextSelection);
    }

    public static IJavaElement getElementAtOffset(JavaEditor javaEditor, ITextSelection iTextSelection) throws JavaModelException {
        return TextSelectionConverter.getElementAtOffset(TextSelectionConverter.getInput(javaEditor), iTextSelection);
    }

    private static IJavaElement getInput(JavaEditor javaEditor) {
        if (javaEditor == null) {
            return null;
        }
        IEditorInput iEditorInput = javaEditor.getEditorInput();
        if (iEditorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)iEditorInput).getClassFile();
        }
        WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
        return workingCopyManager.getWorkingCopy(iEditorInput);
    }

    private static IJavaElement[] codeResolve(IJavaElement iJavaElement, ITextSelection iTextSelection) throws JavaModelException {
        if (iJavaElement instanceof ICodeAssist) {
            IJavaElement[] iJavaElementArray;
            if (iJavaElement instanceof ICompilationUnit && (iJavaElementArray = (IJavaElement[])iJavaElement).isWorkingCopy()) {
                JavaModelUtil.reconcile((ICompilationUnit)iJavaElementArray);
            }
            if ((iJavaElementArray = ((ICodeAssist)iJavaElement).codeSelect(iTextSelection.getOffset(), iTextSelection.getLength())) != null && iJavaElementArray.length > 0) {
                return iJavaElementArray;
            }
        }
        return EMPTY_RESULT;
    }

    private static IJavaElement getElementAtOffset(IJavaElement iJavaElement, ITextSelection iTextSelection) throws JavaModelException {
        if (iJavaElement instanceof ICompilationUnit) {
            IJavaElement iJavaElement2;
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
            if (iCompilationUnit.isWorkingCopy()) {
                JavaModelUtil.reconcile(iCompilationUnit);
            }
            if ((iJavaElement2 = iCompilationUnit.getElementAt(iTextSelection.getOffset())) == null) {
                return iJavaElement;
            }
            return iJavaElement2;
        }
        if (iJavaElement instanceof IClassFile) {
            IJavaElement iJavaElement3 = ((IClassFile)iJavaElement).getElementAt(iTextSelection.getOffset());
            if (iJavaElement3 == null) {
                return iJavaElement;
            }
            return iJavaElement3;
        }
        return null;
    }
}

