/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class CheckboxTreeAndListGroup
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object fRoot;
    private Object fCurrentTreeSelection;
    private List fExpandedTreeNodes = new ArrayList();
    private Map fCheckedStateStore = new HashMap(9);
    private List fWhiteCheckedTreeItems = new ArrayList();
    private List fListeners = new ArrayList();
    private ITreeContentProvider fTreeContentProvider;
    private IStructuredContentProvider fListContentProvider;
    private ILabelProvider fTreeLabelProvider;
    private ILabelProvider fListLabelProvider;
    private CheckboxTreeViewer fTreeViewer;
    private CheckboxTableViewer fListViewer;

    public CheckboxTreeAndListGroup(Composite composite, Object object, ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider, IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider2, int n, int n2, int n3) {
        this.fRoot = object;
        this.fTreeContentProvider = iTreeContentProvider;
        this.fListContentProvider = iStructuredContentProvider;
        this.fTreeLabelProvider = iLabelProvider;
        this.fListLabelProvider = iLabelProvider2;
        this.createContents(composite, n2, n3, n);
    }

    public void aboutToOpen() {
        Object object;
        this.determineWhiteCheckedDescendents(this.fRoot);
        this.checkNewTreeElements(this.getTreeChildren(this.fRoot));
        this.fCurrentTreeSelection = null;
        Object[] objectArray = this.getTreeChildren(this.fRoot);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : null;
        if (object != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
        this.fTreeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.fListeners.add(iCheckStateListener);
    }

    private void addToHierarchyToCheckedStore(Object object) {
        Object object2;
        if (!this.fCheckedStateStore.containsKey(object)) {
            this.fCheckedStateStore.put(object, new ArrayList());
        }
        if ((object2 = this.fTreeContentProvider.getParent(object)) != null) {
            this.addToHierarchyToCheckedStore(object2);
        }
    }

    protected boolean areAllChildrenWhiteChecked(Object object) {
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (!this.fWhiteCheckedTreeItems.contains(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean areAllElementsChecked(Object object) {
        List list = (List)this.fCheckedStateStore.get(object);
        if (list == null) {
            return false;
        }
        return this.getListItemsSize(object) == list.size();
    }

    protected void checkNewTreeElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            boolean bl = this.fCheckedStateStore.containsKey(object);
            this.fTreeViewer.setChecked(object, bl);
            this.fTreeViewer.setGrayed(object, bl && !this.fWhiteCheckedTreeItems.contains(object));
            ++n;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (checkStateChangedEvent.getCheckable().equals(CheckboxTreeAndListGroup.this.fTreeViewer)) {
                    CheckboxTreeAndListGroup.this.treeItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked());
                } else {
                    CheckboxTreeAndListGroup.this.listItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked(), true);
                }
                CheckboxTreeAndListGroup.this.notifyCheckStateChangeListeners(checkStateChangedEvent);
            }
        });
    }

    protected void createContents(Composite composite, int n, int n2, int n3) {
        Composite composite2 = new Composite(composite, n3);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite2, n / 2, n2);
        this.createListViewer(composite2, n / 2, n2);
        this.initialize();
    }

    protected void createListViewer(Composite composite, int n, int n2) {
        this.fListViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.fListViewer.setUseHashlookup(true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        this.fListViewer.getTable().setLayoutData((Object)gridData);
        this.fListViewer.setContentProvider((IContentProvider)this.fListContentProvider);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)this.fListLabelProvider);
        this.fListViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite composite, int n, int n2) {
        Tree tree = new Tree(composite, 2080);
        GridData gridData = new GridData(1808);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        tree.setLayoutData((Object)gridData);
        this.fTreeViewer = new CheckboxTreeViewer(tree);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewer.addTreeListener((ITreeViewerListener)this);
        this.fTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object object) {
        List list = (List)this.fCheckedStateStore.get(object);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (this.fCheckedStateStore.containsKey(objectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean determineShouldBeWhiteChecked(Object object) {
        return this.areAllChildrenWhiteChecked(object) && this.areAllElementsChecked(object);
    }

    protected void determineWhiteCheckedDescendents(Object object) {
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            this.determineWhiteCheckedDescendents(objectArray[n]);
            ++n;
        }
        if (this.determineShouldBeWhiteChecked(object)) {
            this.setWhiteChecked(object, true);
        }
    }

    public void expandAll() {
        this.fTreeViewer.expandAll();
    }

    public Iterator getAllCheckedListItems() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.fCheckedStateStore.values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll((List)iterator.next());
        }
        return hashSet.iterator();
    }

    public Set getAllCheckedTreeItems() {
        return new HashSet(this.fCheckedStateStore.keySet());
    }

    public int getCheckedElementCount() {
        return this.fCheckedStateStore.size();
    }

    protected int getListItemsSize(Object object) {
        Object[] objectArray = this.getListElements(object);
        return objectArray.length;
    }

    public Table getTable() {
        return this.fListViewer.getTable();
    }

    public Tree getTree() {
        return this.fTreeViewer.getTree();
    }

    public void addTreeFilter(ViewerFilter viewerFilter) {
        this.fTreeViewer.addFilter(viewerFilter);
    }

    public void addListFilter(ViewerFilter viewerFilter) {
        this.fListViewer.addFilter(viewerFilter);
    }

    protected void grayCheckHierarchy(Object object) {
        Object object2;
        if (this.fCheckedStateStore.containsKey(object)) {
            return;
        }
        this.fCheckedStateStore.put(object, new ArrayList());
        if (this.determineShouldBeWhiteChecked(object)) {
            this.setWhiteChecked(object, true);
        }
        if ((object2 = this.fTreeContentProvider.getParent(object)) != null) {
            this.grayCheckHierarchy(object2);
        }
    }

    public void initialCheckListItem(Object object) {
        Object object2;
        this.fCurrentTreeSelection = object2 = this.fTreeContentProvider.getParent(object);
        this.listItemChecked(object, true, false);
        this.updateHierarchy(object2);
    }

    public void initialCheckTreeItem(Object object) {
        this.treeItemChecked(object, true);
    }

    protected void initialize() {
        this.fTreeViewer.setInput(this.fRoot);
    }

    protected void listItemChecked(Object object, boolean bl, boolean bl2) {
        List list = (List)this.fCheckedStateStore.get(this.fCurrentTreeSelection);
        if (bl) {
            if (list == null) {
                this.grayCheckHierarchy(this.fCurrentTreeSelection);
                list = (List)this.fCheckedStateStore.get(this.fCurrentTreeSelection);
            }
            list.add(object);
        } else {
            list.remove(object);
            if (list.isEmpty()) {
                this.ungrayCheckHierarchy(this.fCurrentTreeSelection);
            }
        }
        if (bl2) {
            this.updateHierarchy(this.fCurrentTreeSelection);
        }
    }

    protected void notifyCheckStateChangeListeners(CheckStateChangedEvent checkStateChangedEvent) {
        Iterator iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            ((ICheckStateListener)iterator.next()).checkStateChanged(checkStateChangedEvent);
        }
    }

    protected void populateListViewer(Object object) {
        if (object == this.fCurrentTreeSelection) {
            return;
        }
        this.fCurrentTreeSelection = object;
        this.fListViewer.setInput(object);
        List list = (List)this.fCheckedStateStore.get(object);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.fListViewer.setChecked(iterator.next(), true);
            }
        }
    }

    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.fListeners.remove(iCheckStateListener);
    }

    public void selectionChanged(final SelectionChangedEvent selectionChangedEvent) {
        BusyIndicator.showWhile((Display)this.getTable().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if (object == null) {
                    CheckboxTreeAndListGroup.this.fCurrentTreeSelection = null;
                    CheckboxTreeAndListGroup.this.fListViewer.setInput(CheckboxTreeAndListGroup.this.fCurrentTreeSelection);
                    return;
                }
                CheckboxTreeAndListGroup.this.populateListViewer(object);
            }
        });
    }

    public void setAllSelections(final boolean bl) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CheckboxTreeAndListGroup.this.setTreeChecked(CheckboxTreeAndListGroup.this.fRoot, bl);
                CheckboxTreeAndListGroup.this.fListViewer.setAllChecked(bl);
            }
        });
    }

    public void setListProviders(IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider) {
        this.fListViewer.setContentProvider((IContentProvider)iStructuredContentProvider);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setListComparator(ViewerComparator viewerComparator) {
        this.fListViewer.setComparator(viewerComparator);
    }

    public void setRoot(Object object) {
        this.fRoot = object;
        this.initialize();
    }

    protected void setTreeChecked(Object object, boolean bl) {
        Object[] objectArray;
        if (object.equals(this.fCurrentTreeSelection)) {
            this.fListViewer.setAllChecked(bl);
        }
        if (bl) {
            objectArray = this.getListElements(object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n]);
                ++n;
            }
            this.fCheckedStateStore.put(object, arrayList);
        } else {
            this.fCheckedStateStore.remove(object);
        }
        this.setWhiteChecked(object, bl);
        this.fTreeViewer.setChecked(object, bl);
        this.fTreeViewer.setGrayed(object, false);
        objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            this.setTreeChecked(objectArray[n], bl);
            ++n;
        }
    }

    public void setTreeProviders(ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider) {
        this.fTreeViewer.setContentProvider((IContentProvider)iTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setTreeComparator(ViewerComparator viewerComparator) {
        this.fTreeViewer.setComparator(viewerComparator);
    }

    protected void setWhiteChecked(Object object, boolean bl) {
        if (bl) {
            if (!this.fWhiteCheckedTreeItems.contains(object)) {
                this.fWhiteCheckedTreeItems.add(object);
            }
        } else {
            this.fWhiteCheckedTreeItems.remove(object);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getElement();
        if (!this.fExpandedTreeNodes.contains(object)) {
            this.fExpandedTreeNodes.add(object);
            this.checkNewTreeElements(this.getTreeChildren(object));
        }
    }

    protected void treeItemChecked(Object object, boolean bl) {
        this.setTreeChecked(object, bl);
        Object object2 = this.fTreeContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        if (bl) {
            this.grayCheckHierarchy(object2);
        } else {
            this.ungrayCheckHierarchy(object2);
        }
        this.updateHierarchy(object);
    }

    protected void ungrayCheckHierarchy(Object object) {
        Object object2;
        if (!this.determineShouldBeAtLeastGrayChecked(object)) {
            this.fCheckedStateStore.remove(object);
        }
        if ((object2 = this.fTreeContentProvider.getParent(object)) != null) {
            this.ungrayCheckHierarchy(object2);
        }
    }

    protected void updateHierarchy(Object object) {
        boolean bl = this.determineShouldBeWhiteChecked(object);
        boolean bl2 = this.determineShouldBeAtLeastGrayChecked(object);
        this.fTreeViewer.setChecked(object, bl || bl2);
        this.setWhiteChecked(object, bl);
        if (bl) {
            this.fTreeViewer.setGrayed(object, false);
        } else {
            this.fTreeViewer.setGrayed(object, bl2);
        }
        Object object2 = this.fTreeContentProvider.getParent(object);
        if (object2 != null) {
            this.updateHierarchy(object2);
        }
    }

    public void updateSelections(final Map map) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CheckboxTreeAndListGroup.this.handleUpdateSelection(map);
            }
        });
    }

    protected Object[] filter(ViewerFilter[] viewerFilterArray, Object[] objectArray) {
        if (viewerFilterArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < viewerFilterArray.length) {
                    bl = viewerFilterArray[n2].select(null, null, objectArray[n]);
                    if (!bl) break;
                    ++n2;
                }
                if (bl) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return objectArray;
    }

    private Object[] getTreeChildren(Object object) {
        return this.filter(this.fTreeViewer.getFilters(), this.fTreeContentProvider.getChildren(object));
    }

    private Object[] getListElements(Object object) {
        return this.filter(this.fListViewer.getFilters(), this.fListContentProvider.getElements(object));
    }

    public Set getWhiteCheckedTreeItems() {
        return new HashSet(this.fWhiteCheckedTreeItems);
    }

    private void handleUpdateSelection(Map map) {
        Object k;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            List list = (List)map.get(k);
            if (list.size() == 0) {
                this.fCheckedStateStore.remove(k);
                continue;
            }
            this.fCheckedStateStore.put(k, list);
            Object object = this.fTreeContentProvider.getParent(k);
            if (object == null) continue;
            this.addToHierarchyToCheckedStore(object);
        }
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            this.updateHierarchy(k);
            if (this.fCurrentTreeSelection == null || !this.fCurrentTreeSelection.equals(k)) continue;
            this.fListViewer.setAllChecked(false);
            this.fListViewer.setCheckedElements(((List)map.get(k)).toArray());
        }
    }

    public boolean isTreeItemGreyChecked(Object object) {
        return this.fTreeViewer.getGrayed(object);
    }

    public void expandTreeToLevel(Object object, int n) {
        this.fTreeViewer.expandToLevel(object, n);
    }

    public void setTreeSelection(ISelection iSelection) {
        this.fTreeViewer.setSelection(iSelection);
    }
}

