/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

class JarOptionsPage
extends WizardPage
implements IJarPackageWizardPage {
    private JarPackageData fJarPackage;
    private Button fExportErrorsCheckbox;
    private Button fExportWarningsCheckbox;
    private Button fUseSourceFoldersCheckbox;
    private Composite fDescriptionFileGroup;
    private Button fSaveDescriptionCheckbox;
    private Label fDescriptionFileLabel;
    private Text fDescriptionFileText;
    private Button fDescriptionFileBrowseButton;
    private Button fBuildIfNeededCheckbox;
    private static final String PAGE_NAME = "jarOptionsWizardPage";
    private static final String STORE_EXPORT_WARNINGS = "jarOptionsWizardPage.EXPORT_WARNINGS";
    private static final String STORE_EXPORT_ERRORS = "jarOptionsWizardPage.EXPORT_ERRORS";
    private static final String STORE_SAVE_DESCRIPTION = "jarOptionsWizardPage.SAVE_DESCRIPTION";
    private static final String STORE_DESCRIPTION_LOCATION = "jarOptionsWizardPage.DESCRIPTION_LOCATION";
    private static final String STORE_USE_SRC_FOLDERS = "jarOptionsWizardPage.STORE_USE_SRC_FOLDERS";
    private static final String STORE_BUILD_IF_NEEDED = "jarOptionsWizardPage.BUILD_IF_NEEDED";

    public JarOptionsPage(JarPackageData jarPackageData) {
        super(PAGE_NAME);
        this.setTitle(JarPackagerMessages.JarOptionsPage_title);
        this.setDescription(JarPackagerMessages.JarOptionsPage_description);
        this.fJarPackage = jarPackageData;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        this.createOptionsGroup(composite2);
        this.restoreWidgetValues();
        this.setControl((Control)composite2);
        this.update();
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.jar_options_wizard_page_context");
    }

    protected void createOptionsGroup(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createLabel(composite2, JarPackagerMessages.JarOptionsPage_howTreatProblems_label, false);
        UntypedListener untypedListener = new UntypedListener();
        this.fExportErrorsCheckbox = new Button(composite2, 16416);
        this.fExportErrorsCheckbox.setText(JarPackagerMessages.JarOptionsPage_exportErrors_text);
        this.fExportErrorsCheckbox.addListener(13, (Listener)untypedListener);
        this.fExportWarningsCheckbox = new Button(composite2, 16416);
        this.fExportWarningsCheckbox.setText(JarPackagerMessages.JarOptionsPage_exportWarnings_text);
        this.fExportWarningsCheckbox.addListener(13, (Listener)untypedListener);
        this.createSpacer(composite2);
        this.fUseSourceFoldersCheckbox = new Button(composite2, 16416);
        this.fUseSourceFoldersCheckbox.setText(JarPackagerMessages.JarOptionsPage_useSourceFoldersHierarchy);
        this.fUseSourceFoldersCheckbox.addListener(13, (Listener)untypedListener);
        this.fUseSourceFoldersCheckbox.setEnabled(this.fJarPackage.areJavaFilesExported() && !this.fJarPackage.areGeneratedFilesExported());
        this.createSpacer(composite2);
        this.fBuildIfNeededCheckbox = new Button(composite2, 16416);
        this.fBuildIfNeededCheckbox.setText(JarPackagerMessages.JarOptionsPage_buildIfNeeded);
        this.fBuildIfNeededCheckbox.addListener(13, (Listener)untypedListener);
        this.createSpacer(composite2);
        this.fSaveDescriptionCheckbox = new Button(composite2, 16416);
        this.fSaveDescriptionCheckbox.setText(JarPackagerMessages.JarOptionsPage_saveDescription_text);
        this.fSaveDescriptionCheckbox.addListener(13, (Listener)untypedListener);
        this.createDescriptionFileGroup(composite);
    }

    public final void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            iDialogSettings.put(STORE_EXPORT_WARNINGS, this.fJarPackage.exportWarnings());
            iDialogSettings.put(STORE_EXPORT_ERRORS, this.fJarPackage.areErrorsExported());
            iDialogSettings.put(STORE_USE_SRC_FOLDERS, this.fJarPackage.useSourceFolderHierarchy());
            iDialogSettings.put(STORE_BUILD_IF_NEEDED, this.fJarPackage.isBuildingIfNeeded());
            iDialogSettings.put(STORE_SAVE_DESCRIPTION, this.fJarPackage.isDescriptionSaved());
            iDialogSettings.put(STORE_DESCRIPTION_LOCATION, this.fJarPackage.getDescriptionLocation().toString());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((JarPackageWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        this.fExportWarningsCheckbox.setSelection(this.fJarPackage.exportWarnings());
        this.fExportErrorsCheckbox.setSelection(this.fJarPackage.areErrorsExported());
        this.fBuildIfNeededCheckbox.setSelection(this.fJarPackage.isBuildingIfNeeded());
        this.fUseSourceFoldersCheckbox.setSelection(this.fJarPackage.useSourceFolderHierarchy());
        this.fSaveDescriptionCheckbox.setSelection(this.fJarPackage.isDescriptionSaved());
        this.fDescriptionFileText.setText(this.fJarPackage.getDescriptionLocation().toString());
    }

    protected void initializeJarPackage() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.fJarPackage.setExportWarnings(iDialogSettings.getBoolean(STORE_EXPORT_WARNINGS));
            this.fJarPackage.setExportErrors(iDialogSettings.getBoolean(STORE_EXPORT_ERRORS));
            this.fJarPackage.setUseSourceFolderHierarchy(iDialogSettings.getBoolean(STORE_USE_SRC_FOLDERS));
            this.fJarPackage.setSaveDescription(false);
            String string = iDialogSettings.get(STORE_DESCRIPTION_LOCATION);
            if (string == null) {
                string = "";
            }
            this.fJarPackage.setDescriptionLocation((IPath)new Path(string));
            if (iDialogSettings.get(STORE_BUILD_IF_NEEDED) != null) {
                this.fJarPackage.setBuildIfNeeded(iDialogSettings.getBoolean(STORE_BUILD_IF_NEEDED));
            }
        }
    }

    private void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fJarPackage.setExportWarnings(this.fExportWarningsCheckbox.getSelection());
        this.fJarPackage.setExportErrors(this.fExportErrorsCheckbox.getSelection());
        this.fJarPackage.setBuildIfNeeded(this.fBuildIfNeededCheckbox.getSelection());
        this.fJarPackage.setSaveDescription(this.fSaveDescriptionCheckbox.getSelection());
        this.fJarPackage.setDescriptionLocation((IPath)new Path(this.fDescriptionFileText.getText()));
        this.fJarPackage.setUseSourceFolderHierarchy(this.fUseSourceFoldersCheckbox.getSelection());
    }

    protected void handleDescriptionFileBrowseButtonPressed() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getContainer().getShell());
        saveAsDialog.create();
        saveAsDialog.getShell().setText(JarPackagerMessages.JarOptionsPage_saveAsDialog_title);
        saveAsDialog.setMessage(JarPackagerMessages.JarOptionsPage_saveAsDialog_message);
        saveAsDialog.setOriginalFile(this.createFileHandle(this.fJarPackage.getDescriptionLocation()));
        if (saveAsDialog.open() == 0) {
            IPath iPath = saveAsDialog.getResult();
            iPath = iPath.removeFileExtension().addFileExtension("jardesc");
            this.fDescriptionFileText.setText(iPath.toString());
        }
    }

    protected void updateWidgetEnablements() {
        boolean bl = this.fSaveDescriptionCheckbox.getSelection();
        this.fDescriptionFileGroup.setEnabled(bl);
        this.fDescriptionFileBrowseButton.setEnabled(bl);
        this.fDescriptionFileText.setEnabled(bl);
        this.fDescriptionFileLabel.setEnabled(bl);
        boolean bl2 = this.fJarPackage.areClassFilesExported() && !this.fJarPackage.areOutputFoldersExported();
        this.fExportWarningsCheckbox.setEnabled(bl2);
        this.fExportErrorsCheckbox.setEnabled(bl2);
        boolean bl3 = ResourcesPlugin.getWorkspace().isAutoBuilding();
        this.fBuildIfNeededCheckbox.setEnabled(bl2 && !bl3);
        this.fUseSourceFoldersCheckbox.setEnabled(this.fJarPackage.areJavaFilesExported() && !this.fJarPackage.areGeneratedFilesExported());
    }

    public boolean isPageComplete() {
        if (this.fJarPackage.isDescriptionSaved()) {
            if (this.fJarPackage.getDescriptionLocation().toString().length() == 0) {
                this.setErrorMessage(null);
                return false;
            }
            IPath iPath = this.fJarPackage.getDescriptionLocation();
            if (!iPath.toString().startsWith("/")) {
                this.setErrorMessage(JarPackagerMessages.JarOptionsPage_error_descriptionMustBeAbsolute);
                return false;
            }
            IResource iResource = this.findResource(iPath);
            if (iResource != null && iResource.getType() != 1) {
                this.setErrorMessage(JarPackagerMessages.JarOptionsPage_error_descriptionMustNotBeExistingContainer);
                return false;
            }
            iResource = this.findResource(iPath.removeLastSegments(1));
            if (iResource == null || iResource.getType() == 1) {
                this.setErrorMessage(JarPackagerMessages.JarOptionsPage_error_descriptionContainerDoesNotExist);
                return false;
            }
            String string = this.fJarPackage.getDescriptionLocation().getFileExtension();
            if (string == null || !string.equals("jardesc")) {
                this.setErrorMessage(Messages.format(JarPackagerMessages.JarOptionsPage_error_invalidDescriptionExtension, "jardesc"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.fJarPackage.areGeneratedFilesExported() && super.canFlipToNextPage();
    }

    protected void createDescriptionFileGroup(Composite composite) {
        this.fDescriptionFileGroup = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.fDescriptionFileGroup.setLayout((Layout)gridLayout);
        this.fDescriptionFileGroup.setLayoutData((Object)new GridData(784));
        this.fDescriptionFileLabel = new Label(this.fDescriptionFileGroup, 0);
        this.fDescriptionFileLabel.setText(JarPackagerMessages.JarOptionsPage_descriptionFile_label);
        this.fDescriptionFileText = new Text(this.fDescriptionFileGroup, 2052);
        this.fDescriptionFileText.addListener(24, (Listener)new UntypedListener());
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.fDescriptionFileText.setLayoutData((Object)gridData);
        this.fDescriptionFileBrowseButton = new Button(this.fDescriptionFileGroup, 8);
        this.fDescriptionFileBrowseButton.setText(JarPackagerMessages.JarOptionsPage_browseButton_text);
        this.fDescriptionFileBrowseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fDescriptionFileBrowseButton);
        this.fDescriptionFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarOptionsPage.this.handleDescriptionFileBrowseButtonPressed();
            }
        });
    }

    protected IFile createFileHandle(IPath iPath) {
        if (iPath.isValidPath(iPath.toString()) && iPath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(iPath);
        }
        return null;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        super.setPreviousPage(iWizardPage);
        this.updateWidgetEnablements();
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    public void finish() {
        this.saveWidgetValues();
    }

    protected Label createLabel(Composite composite, String string, boolean bl) {
        Label label = new Label(composite, 0);
        if (bl) {
            label.setFont(JFaceResources.getBannerFont());
        }
        label.setText(string);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
    }

    protected void updatePageCompletion() {
        boolean bl = this.isPageComplete();
        this.setPageComplete(bl);
        if (bl) {
            this.setErrorMessage(null);
        }
    }

    protected IResource findResource(IPath iPath) {
        IWorkspace iWorkspace = JavaPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 15);
        if (iStatus.isOK() && iWorkspace.getRoot().exists(iPath)) {
            return iWorkspace.getRoot().findMember(iPath);
        }
        return null;
    }

    private class UntypedListener
    implements Listener {
        private UntypedListener() {
        }

        public void handleEvent(Event event) {
            if (JarOptionsPage.this.getControl() == null) {
                return;
            }
            JarOptionsPage.this.update();
        }
    }
}

