/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.ContainerFilter;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarRefactoringDialog;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

class JarPackageWizardPage
extends WizardExportResourcesPage
implements IJarPackageWizardPage {
    private JarPackageData fJarPackage;
    private IStructuredSelection fInitialSelection;
    private CheckboxTreeAndListGroup fInputGroup;
    private Button fExportClassFilesCheckbox;
    private Button fExportOutputFoldersCheckbox;
    private Button fExportJavaFilesCheckbox;
    private Button fExportRefactoringsCheckbox;
    private Link fRefactoringLink;
    private Combo fDestinationNamesCombo;
    private Button fDestinationBrowseButton;
    private Button fCompressCheckbox;
    private Button fOverwriteCheckbox;
    private Button fIncludeDirectoryEntriesCheckbox;
    private boolean fInitiallySelecting = true;
    private static final String PAGE_NAME = "JarPackageWizardPage";
    private static final String STORE_EXPORT_CLASS_FILES = "JarPackageWizardPage.EXPORT_CLASS_FILES";
    private static final String STORE_EXPORT_OUTPUT_FOLDERS = "JarPackageWizardPage.EXPORT_OUTPUT_FOLDER";
    private static final String STORE_EXPORT_JAVA_FILES = "JarPackageWizardPage.EXPORT_JAVA_FILES";
    private static final String STORE_DESTINATION_NAMES = "JarPackageWizardPage.DESTINATION_NAMES_ID";
    private static final String STORE_REFACTORINGS = "JarPackageWizardPage.REFACTORINGS";
    private static final String STORE_COMPRESS = "JarPackageWizardPage.COMPRESS";
    private static final String STORE_OVERWRITE = "JarPackageWizardPage.OVERWRITE";
    private static final String STORE_INCLUDE_DIRECTORY_ENTRIES = "JarPackageWizardPage.INCLUDE_DIRECTORY_ENTRIES";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    static /* synthetic */ Class class$0;

    public JarPackageWizardPage(JarPackageData jarPackageData, IStructuredSelection iStructuredSelection) {
        super(PAGE_NAME, iStructuredSelection);
        this.setTitle(JarPackagerMessages.JarPackageWizardPage_title);
        this.setDescription(JarPackagerMessages.JarPackageWizardPage_description);
        this.fJarPackage = jarPackageData;
        this.fInitialSelection = iStructuredSelection;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        this.createPlainLabel(composite2, JarPackagerMessages.JarPackageWizardPage_whatToExport_label);
        this.createInputGroup(composite2);
        this.createExportTypeGroup(composite2);
        new Label(composite2, 0);
        this.createPlainLabel(composite2, JarPackagerMessages.JarPackageWizardPage_whereToExport_label);
        this.createDestinationGroup(composite2);
        this.createPlainLabel(composite2, JarPackagerMessages.JarPackageWizardPage_options_label);
        this.createOptionsGroup(composite2);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.fInitialSelection != null) {
            BusyIndicator.showWhile((Display)composite.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    JarPackageWizardPage.this.setupBasedOnInitialSelections();
                }
            });
        }
        this.setControl((Control)composite2);
        this.update();
        this.fRefactoringLink.setEnabled(this.fExportRefactoringsCheckbox.getSelection());
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.jar_packager_wizard_page_context");
    }

    protected void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fCompressCheckbox = new Button(composite2, 16416);
        this.fCompressCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_compress_text);
        this.fCompressCheckbox.addListener(13, (Listener)this);
        this.fIncludeDirectoryEntriesCheckbox = new Button(composite2, 16416);
        this.fIncludeDirectoryEntriesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_includeDirectoryEntries_text);
        this.fIncludeDirectoryEntriesCheckbox.addListener(13, (Listener)this);
        this.fOverwriteCheckbox = new Button(composite2, 16416);
        this.fOverwriteCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_overwrite_text);
        this.fOverwriteCheckbox.addListener(13, (Listener)this);
    }

    protected String getDestinationValue() {
        String string = this.fDestinationNamesCombo.getText().trim();
        if (string.indexOf(46) < 0) {
            string = String.valueOf(string) + this.getOutputSuffix();
        }
        return string;
    }

    protected String getDestinationLabel() {
        return JarPackagerMessages.JarPackageWizardPage_destination_label;
    }

    protected String getOutputSuffix() {
        return ".jar";
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.fInputGroup.getAllCheckedListItems();
    }

    public final void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            stringArray = this.addToHistory(stringArray, this.getDestinationValue());
            iDialogSettings.put(STORE_DESTINATION_NAMES, stringArray);
            iDialogSettings.put(STORE_EXPORT_CLASS_FILES, this.fJarPackage.areClassFilesExported());
            iDialogSettings.put(STORE_EXPORT_OUTPUT_FOLDERS, this.fJarPackage.areOutputFoldersExported());
            iDialogSettings.put(STORE_EXPORT_JAVA_FILES, this.fJarPackage.areJavaFilesExported());
            iDialogSettings.put(STORE_REFACTORINGS, this.fJarPackage.isRefactoringAware());
            iDialogSettings.put(STORE_COMPRESS, this.fJarPackage.isCompressed());
            iDialogSettings.put(STORE_INCLUDE_DIRECTORY_ENTRIES, this.fJarPackage.areDirectoryEntriesIncluded());
            iDialogSettings.put(STORE_OVERWRITE, this.fJarPackage.allowOverwrite());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((JarPackageWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        this.fExportClassFilesCheckbox.setSelection(this.fJarPackage.areClassFilesExported());
        this.fExportOutputFoldersCheckbox.setSelection(this.fJarPackage.areOutputFoldersExported());
        this.fExportJavaFilesCheckbox.setSelection(this.fJarPackage.areJavaFilesExported());
        if (this.fJarPackage.getJarLocation().isEmpty()) {
            this.fDestinationNamesCombo.setText("");
        } else {
            this.fDestinationNamesCombo.setText(this.fJarPackage.getJarLocation().toOSString());
        }
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES);
            if (stringArray == null) {
                return;
            }
            if (!this.fDestinationNamesCombo.getText().equals(stringArray[0])) {
                this.fDestinationNamesCombo.add(this.fDestinationNamesCombo.getText());
            }
            int n = 0;
            while (n < stringArray.length) {
                this.fDestinationNamesCombo.add(stringArray[n]);
                ++n;
            }
        }
        if (this.fExportRefactoringsCheckbox != null) {
            this.fExportRefactoringsCheckbox.setSelection(this.fJarPackage.isRefactoringAware());
        }
        this.fCompressCheckbox.setSelection(this.fJarPackage.isCompressed());
        this.fIncludeDirectoryEntriesCheckbox.setSelection(this.fJarPackage.areDirectoryEntriesIncluded());
        this.fOverwriteCheckbox.setSelection(this.fJarPackage.allowOverwrite());
    }

    protected void initializeJarPackage() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.fJarPackage.setElements(this.getSelectedElements());
            this.fJarPackage.setExportClassFiles(iDialogSettings.getBoolean(STORE_EXPORT_CLASS_FILES));
            this.fJarPackage.setExportOutputFolders(iDialogSettings.getBoolean(STORE_EXPORT_OUTPUT_FOLDERS));
            this.fJarPackage.setExportJavaFiles(iDialogSettings.getBoolean(STORE_EXPORT_JAVA_FILES));
            this.fJarPackage.setRefactoringAware(iDialogSettings.getBoolean(STORE_REFACTORINGS));
            this.fJarPackage.setCompress(iDialogSettings.getBoolean(STORE_COMPRESS));
            this.fJarPackage.setIncludeDirectoryEntries(iDialogSettings.getBoolean(STORE_INCLUDE_DIRECTORY_ENTRIES));
            this.fJarPackage.setOverwrite(iDialogSettings.getBoolean(STORE_OVERWRITE));
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES);
            if (stringArray == null) {
                return;
            }
            this.fJarPackage.setJarLocation(Path.fromOSString((String)stringArray[0]));
        }
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        if (this.fExportClassFilesCheckbox.getSelection() && !this.fJarPackage.areClassFilesExported()) {
            this.fExportOutputFoldersCheckbox.setSelection(false);
        }
        if (this.fExportOutputFoldersCheckbox.getSelection() && !this.fJarPackage.areOutputFoldersExported()) {
            this.fExportClassFilesCheckbox.setSelection(false);
        }
        this.fJarPackage.setExportClassFiles(this.fExportClassFilesCheckbox.getSelection());
        this.fJarPackage.setExportOutputFolders(this.fExportOutputFoldersCheckbox.getSelection());
        this.fJarPackage.setExportJavaFiles(this.fExportJavaFilesCheckbox.getSelection());
        this.fJarPackage.setElements(this.getSelectedElements());
        String string = this.fDestinationNamesCombo.getText();
        IPath iPath = Path.fromOSString((String)string);
        if (iPath.segmentCount() > 0 && this.ensureTargetFileIsValid(iPath.toFile()) && iPath.getFileExtension() == null) {
            iPath = iPath.addFileExtension("jar");
        }
        this.fJarPackage.setJarLocation(iPath);
        if (this.fExportRefactoringsCheckbox != null) {
            this.fJarPackage.setRefactoringAware(this.fExportRefactoringsCheckbox.getSelection());
        } else {
            this.fJarPackage.setRefactoringAware(false);
        }
        this.fJarPackage.setCompress(this.fCompressCheckbox.getSelection());
        this.fJarPackage.setIncludeDirectoryEntries(this.fIncludeDirectoryEntriesCheckbox.getSelection());
        this.fJarPackage.setOverwrite(this.fOverwriteCheckbox.getSelection());
    }

    protected boolean ensureTargetFileIsValid(File file) {
        if (file.exists() && file.isDirectory() && this.fDestinationNamesCombo.getText().length() > 0) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_exportDestinationMustNotBeDirectory);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        if (file.exists() && !file.canWrite()) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_jarFileExistsAndNotWritable);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        return true;
    }

    protected void createDestinationGroup(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        new Label(composite2, 0).setText(this.getDestinationLabel());
        this.fDestinationNamesCombo = new Combo(composite2, 2052);
        this.fDestinationNamesCombo.addListener(24, (Listener)this);
        this.fDestinationNamesCombo.addListener(13, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.fDestinationNamesCombo.setLayoutData((Object)gridData);
        this.fDestinationBrowseButton = new Button(composite2, 8);
        this.fDestinationBrowseButton.setText(JarPackagerMessages.JarPackageWizardPage_browseButton_text);
        this.fDestinationBrowseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fDestinationBrowseButton);
        this.fDestinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarPackageWizardPage.this.handleDestinationBrowseButtonPressed();
            }
        });
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog fileDialog = new FileDialog(this.getContainer().getShell(), 8192);
        fileDialog.setFilterExtensions(new String[]{"*.jar", "*.zip"});
        String string = this.getDestinationValue();
        int n = string.lastIndexOf(File.separator);
        if (n != -1) {
            fileDialog.setFilterPath(string.substring(0, n));
            fileDialog.setFileName(string.substring(n + 1, string.length()));
        } else {
            fileDialog.setFileName(string);
        }
        String string2 = fileDialog.open();
        if (string2 != null) {
            this.fDestinationNamesCombo.setText(string2);
        }
    }

    protected IResource findResource(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 15);
        if (iStatus.isOK() && iWorkspace.getRoot().exists(iPath)) {
            return iWorkspace.getRoot().findMember(iPath);
        }
        return null;
    }

    protected void createInputGroup(Composite composite) {
        int n = 272;
        StandardJavaElementContentProvider standardJavaElementContentProvider = new StandardJavaElementContentProvider(){

            public boolean hasChildren(Object object) {
                return !(object instanceof IPackageFragment) && super.hasChildren(object);
            }
        };
        DecoratingLabelProvider decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(n), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.fInputGroup = new CheckboxTreeAndListGroup(composite, JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), standardJavaElementContentProvider, (ILabelProvider)decoratingLabelProvider, (IStructuredContentProvider)new StandardJavaElementContentProvider(), (ILabelProvider)decoratingLabelProvider, 0, 480, 150){

            protected void setTreeChecked(Object object, boolean bl) {
                IResource iResource;
                if (JarPackageWizardPage.this.fInitiallySelecting && object instanceof IResource && (iResource = (IResource)object).getName().charAt(0) == '.') {
                    return;
                }
                super.setTreeChecked(object, bl);
            }
        };
        this.fInputGroup.addTreeFilter(new EmptyInnerPackageFilter());
        this.fInputGroup.setTreeComparator(new JavaElementComparator());
        this.fInputGroup.setListComparator(new JavaElementComparator());
        this.fInputGroup.addTreeFilter(new ContainerFilter(ContainerFilter.FILTER_NON_CONTAINERS));
        this.fInputGroup.addTreeFilter(new LibraryFilter());
        this.fInputGroup.addListFilter(new ContainerFilter(ContainerFilter.FILTER_CONTAINERS));
        this.fInputGroup.getTree().addListener(4, (Listener)this);
        this.fInputGroup.getTable().addListener(4, (Listener)this);
        ICheckStateListener iCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                JarPackageWizardPage.this.update();
            }
        };
        this.fInputGroup.addCheckStateListener(iCheckStateListener);
    }

    protected void createExportTypeGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fExportClassFilesCheckbox = new Button(composite2, 16416);
        this.fExportClassFilesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportClassFiles_text);
        this.fExportClassFilesCheckbox.addListener(13, (Listener)this);
        this.fExportOutputFoldersCheckbox = new Button(composite2, 16416);
        this.fExportOutputFoldersCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportOutputFolders_text);
        this.fExportOutputFoldersCheckbox.addListener(13, (Listener)this);
        this.fExportJavaFilesCheckbox = new Button(composite2, 16416);
        this.fExportJavaFilesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportJavaFiles_text);
        this.fExportJavaFilesCheckbox.addListener(13, (Listener)this);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.fExportRefactoringsCheckbox = new Button(composite3, 16416);
        this.fExportRefactoringsCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_refactorings_text);
        this.fExportRefactoringsCheckbox.addListener(13, (Listener)this);
        this.fRefactoringLink = new Link(composite3, 64);
        this.fRefactoringLink.setText(JarPackagerMessages.JarPackageWizardPage_configure_label);
        this.fRefactoringLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarPackageWizardPage.this.openRefactoringDialog();
            }
        });
        this.fRefactoringLink.setToolTipText(JarPackagerMessages.JarPackageWizardPage_configure_tooltip);
        GridData gridData = new GridData(513);
        this.fRefactoringLink.setLayoutData((Object)gridData);
        this.fExportRefactoringsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarPackageWizardPage.this.fRefactoringLink.setEnabled(JarPackageWizardPage.this.fExportRefactoringsCheckbox.getSelection());
            }
        });
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openRefactoringDialog() {
        final RefactoringHistory[] refactoringHistoryArray = new RefactoringHistory[1];
        final IRefactoringHistoryService iRefactoringHistoryService = RefactoringCore.getHistoryService();
        try {
            iRefactoringHistoryService.connect();
            final HashSet<IProject> hashSet = new HashSet<IProject>();
            Object[] objectArray = this.fJarPackage.getElements();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof IAdaptable) {
                    IResource iResource;
                    IAdaptable iAdaptable = (IAdaptable)objectArray[n];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        hashSet.add(iResource.getProject());
                    }
                }
                ++n;
            }
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        refactoringHistoryArray[0] = iRefactoringHistoryService.getRefactoringHistory(hashSet.toArray(new IProject[hashSet.size()]), 0L, Long.MAX_VALUE, 65536, iProgressMonitor);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                block12: {
                    ExceptionHandler.handle(invocationTargetException, this.getShell(), JarPackagerMessages.JarPackageWizardPage_error_caption, JarPackagerMessages.JarPackageWizardPage_error_label);
                    break block12;
                    catch (InterruptedException interruptedException) {}
                }
                Object var8_9 = null;
                iRefactoringHistoryService.disconnect();
                return;
            }
            new JarRefactoringDialog(this.getShell(), this.getDialogSettings(), this.fJarPackage, refactoringHistoryArray[0]).open();
            this.updatePageCompletion();
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            iRefactoringHistoryService.disconnect();
            throw throwable;
        }
        iRefactoringHistoryService.disconnect();
    }

    protected void updateWidgetEnablements() {
        if (this.fExportRefactoringsCheckbox != null) {
            boolean bl = this.fExportRefactoringsCheckbox.getSelection();
            this.fIncludeDirectoryEntriesCheckbox.setEnabled(!bl);
            if (bl) {
                this.fIncludeDirectoryEntriesCheckbox.setSelection(true);
                this.fJarPackage.setIncludeDirectoryEntries(true);
            }
        }
    }

    public boolean isPageComplete() {
        boolean bl = this.validateSourceGroup();
        bl = this.validateDestinationGroup() && bl;
        boolean bl2 = bl = this.validateOptionsGroup() && bl;
        if (bl) {
            this.setErrorMessage(null);
        }
        return bl;
    }

    public void handleEvent(Event event) {
        if (this.getControl() == null) {
            return;
        }
        this.update();
    }

    protected void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void updatePageCompletion() {
        boolean bl = this.isPageComplete();
        this.setPageComplete(bl);
        if (bl) {
            this.setErrorMessage(null);
        }
        this.updateRefactoringMessage();
    }

    protected void updateRefactoringMessage() {
        String string = this.getMessage();
        if (this.fJarPackage.isRefactoringAware() && this.fJarPackage.getRefactoringDescriptors().length == 0) {
            if (string == null) {
                this.setMessage(JarPackagerMessages.JarPackageWizardPage_no_refactorings_selected, 1);
            }
        } else if (JarPackagerMessages.JarPackageWizardPage_no_refactorings_selected.equals(string)) {
            this.setMessage(null);
        }
    }

    protected boolean validateDestinationGroup() {
        if (this.fDestinationNamesCombo.getText().length() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if (this.getMessage() != null) {
                this.setMessage(null);
            }
            return false;
        }
        if (this.fJarPackage.getAbsoluteJarLocation().toString().endsWith("/")) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_exportDestinationMustNotBeDirectory);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (iPath != null && iPath.isPrefixOf(this.fJarPackage.getAbsoluteJarLocation())) {
            int n = iPath.matchingFirstSegments(this.fJarPackage.getAbsoluteJarLocation());
            IPath iPath2 = this.fJarPackage.getAbsoluteJarLocation().removeFirstSegments(n);
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath2);
            if (iResource != null && iResource.getType() == 1 && JarPackagerUtil.contains(JarPackagerUtil.asResources(this.fJarPackage.getElements()), (IFile)iResource)) {
                this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_cantExportJARIntoItself);
                return false;
            }
        }
        String string = this.getMessage();
        if (!new File(this.fDestinationNamesCombo.getText()).isAbsolute()) {
            if (string == null) {
                this.setMessage(JarPackagerMessages.JarPackageWizardPage_info_relativeExportDestination, 1);
            }
        } else if (string != null) {
            this.setMessage(null);
        }
        return this.ensureTargetFileIsValid(this.fJarPackage.getAbsoluteJarLocation().toFile());
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        if (!(this.fExportClassFilesCheckbox.getSelection() || this.fExportOutputFoldersCheckbox.getSelection() || this.fExportJavaFilesCheckbox.getSelection())) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_noExportTypeChecked);
            return false;
        }
        if (this.getSelectedResources().size() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            return false;
        }
        if (this.fExportClassFilesCheckbox.getSelection() || this.fExportOutputFoldersCheckbox.getSelection()) {
            return true;
        }
        Iterator iterator = this.getSelectedResourcesIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IClassFile) {
                IClasspathEntry iClasspathEntry;
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)((IClassFile)e).getAncestor(3);
                if (iPackageFragmentRoot == null) continue;
                try {
                    iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                }
                catch (JavaModelException javaModelException) {
                    continue;
                }
                if (iClasspathEntry.getEntryKind() != 1) continue;
                return true;
            }
            return true;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return false;
    }

    protected IFile createFileHandle(IPath iPath) {
        if (iPath.isValidPath(iPath.toString()) && iPath.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
        }
        return null;
    }

    protected void giveFocusToDestination() {
        this.fDestinationNamesCombo.setFocus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setupBasedOnInitialSelections() {
        Object object;
        Iterator iterator = this.fInitialSelection.iterator();
        while (true) {
            IJavaElement iJavaElement;
            if (!iterator.hasNext()) break;
            object = iterator.next();
            if (object instanceof IResource && !((IResource)object).isAccessible() || object instanceof IJavaElement && !((IJavaElement)object).exists()) continue;
            if (object instanceof ICompilationUnit || object instanceof IClassFile || object instanceof IFile) {
                this.fInputGroup.initialCheckListItem(object);
                continue;
            }
            if (object instanceof IFolder && (iJavaElement = JavaCore.create((IResource)((IResource)object))) != null && iJavaElement.exists() && iJavaElement.getJavaProject().isOnClasspath((IResource)object)) {
                object = iJavaElement;
            }
            try {
                this.fInputGroup.initialCheckTreeItem(object);
            }
            catch (Throwable throwable) {
                iJavaElement = null;
                this.fInitiallySelecting = false;
                throw throwable;
            }
            {
                iJavaElement = null;
                this.fInitiallySelecting = false;
                continue;
            }
            break;
        }
        object = this.fInputGroup.getTree().getItems();
        int n = 0;
        while (true) {
            if (n >= ((E)object).length || object[n].getChecked()) {
                if (n < ((E)object).length) {
                    this.fInputGroup.getTree().setSelection(new TreeItem[]{object[n]});
                    this.fInputGroup.getTree().showSelection();
                    this.fInputGroup.populateListViewer(object[n].getData());
                }
                return;
            }
            ++n;
        }
    }

    public void finish() {
        this.saveWidgetValues();
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        super.setPreviousPage(iWizardPage);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    Object[] getSelectedElementsWithoutContainedChildren() {
        Set set = this.removeContainedChildren(this.fInputGroup.getWhiteCheckedTreeItems());
        set.addAll(this.getExportedNonContainers());
        return set.toArray();
    }

    private Set removeContainedChildren(Set set) {
        HashSet hashSet = new HashSet(set.size());
        Set set2 = this.getCorrespondingContainers(set);
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            IContainer iContainer;
            Object e = iterator.next();
            if (e instanceof IResource) {
                iContainer = ((IResource)e).getParent();
            } else if (e instanceof IJavaElement) {
                iContainer = ((IJavaElement)e).getParent();
                if (iContainer instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iContainer;
                    try {
                        if (iPackageFragmentRoot.getCorrespondingResource() instanceof IProject) {
                            iContainer = iPackageFragmentRoot.getJavaProject();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            } else {
                hashSet.add(e);
                continue;
            }
            if (e instanceof IJavaModel || !(iContainer instanceof IJavaModel) && (set.contains(iContainer) || set2.contains(iContainer))) {
                bl = true;
                continue;
            }
            hashSet.add(e);
        }
        if (bl) {
            return this.removeContainedChildren(hashSet);
        }
        return hashSet;
    }

    private Set getExportedNonContainers() {
        Set set = this.fInputGroup.getWhiteCheckedTreeItems();
        HashSet hashSet = new HashSet(set.size());
        Set set2 = this.getCorrespondingContainers(set);
        Iterator iterator = this.fInputGroup.getAllCheckedListItems();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            IContainer iContainer = null;
            if (e instanceof IResource) {
                iContainer = ((IResource)e).getParent();
            } else if (e instanceof IJavaElement) {
                iContainer = ((IJavaElement)e).getParent();
            }
            if (set.contains(iContainer) || set2.contains(iContainer)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    private Set getCorrespondingContainers(Set set) {
        HashSet<IResource> hashSet = new HashSet<IResource>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IResource iResource;
            IJavaElement iJavaElement;
            int n;
            Object e = iterator.next();
            if (!(e instanceof IJavaElement) || (n = (iJavaElement = (IJavaElement)e).getElementType()) != 2 && n != 4 && n != 3 || n == 4 && ((IPackageFragment)e).isDefaultPackage()) continue;
            try {
                iResource = iJavaElement.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                iResource = null;
            }
            if (iResource == null) continue;
            hashSet.add(iResource);
        }
        return hashSet;
    }

    private Object[] getSelectedElements() {
        return this.getSelectedResources().toArray();
    }
}

