/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocMemberContentProvider;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocProjectContentProvider;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class JavadocTreeWizardPage
extends JavadocWizardPage {
    private CheckboxTreeAndListGroup fInputGroup;
    private Text fDestinationText;
    private Combo fJavadocCommandText;
    private Text fDocletText;
    private Text fDocletTypeText;
    private Button fStandardButton;
    private Button fDestinationBrowserButton;
    private Button fCustomButton;
    private Button fPrivateVisibility;
    private Button fProtectedVisibility;
    private Button fPackageVisibility;
    private Button fPublicVisibility;
    private Label fDocletLabel;
    private Label fDocletTypeLabel;
    private Label fDestinationLabel;
    private CLabel fDescriptionLabel;
    private String fVisibilitySelection;
    private JavadocOptionsManager fStore;
    private StatusInfo fJavadocStatus;
    private StatusInfo fDestinationStatus;
    private StatusInfo fDocletStatus;
    private StatusInfo fTreeStatus;
    private StatusInfo fPreferenceStatus;
    private StatusInfo fWizardStatus;
    private final int PREFERENCESTATUS = 0;
    private final int CUSTOMSTATUS = 1;
    private final int STANDARDSTATUS = 2;
    private final int TREESTATUS = 3;
    private final int JAVADOCSTATUS = 4;

    protected JavadocTreeWizardPage(String string, JavadocOptionsManager javadocOptionsManager) {
        super(string);
        this.setDescription(JavadocExportMessages.JavadocTreeWizardPage_javadoctreewizardpage_description);
        this.fStore = javadocOptionsManager;
        this.fJavadocStatus = new StatusInfo();
        this.fDestinationStatus = new StatusInfo();
        this.fDocletStatus = new StatusInfo();
        this.fTreeStatus = new StatusInfo();
        this.fPreferenceStatus = new StatusInfo();
        this.fWizardStatus = javadocOptionsManager.getWizardStatus();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite2.setLayout((Layout)gridLayout);
        this.createJavadocCommandSet(composite2);
        this.createInputGroup(composite2);
        this.createVisibilitySet(composite2);
        this.createOptionsSet(composite2);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.javadoc_tree_page_context");
    }

    protected void createJavadocCommandSet(Composite composite) {
        GridLayout gridLayout = this.createGridLayout(2);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite2.setLayout((Layout)gridLayout);
        this.createLabel(composite2, 0, JavadocExportMessages.JavadocTreeWizardPage_javadoccommand_label, this.createGridData(32, 2, 0));
        this.fJavadocCommandText = this.createCombo(composite2, 0, null, this.createGridData(768, 1, 0));
        this.fJavadocCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocTreeWizardPage.this.doValidation(4);
            }
        });
        Button button = this.createButton(composite2, 8, JavadocExportMessages.JavadocTreeWizardPage_javadoccommand_button_label, this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavadocTreeWizardPage.this.browseForJavadocCommand();
            }
        });
    }

    protected void createInputGroup(Composite composite) {
        this.createLabel(composite, 0, JavadocExportMessages.JavadocTreeWizardPage_checkboxtreeandlistgroup_label, this.createGridData(6));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        JavadocProjectContentProvider javadocProjectContentProvider = new JavadocProjectContentProvider();
        JavadocMemberContentProvider javadocMemberContentProvider = new JavadocMemberContentProvider();
        this.fInputGroup = new CheckboxTreeAndListGroup(composite2, (Object)this, javadocProjectContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (IStructuredContentProvider)javadocMemberContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), 0, this.convertWidthInCharsToPixels(60), this.convertHeightInCharsToPixels(10));
        this.fInputGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                JavadocTreeWizardPage.this.doValidation(3);
            }
        });
        this.fInputGroup.setTreeComparator(new JavaElementComparator());
        IJavaElement[] iJavaElementArray = this.fStore.getInitialElements();
        this.setTreeChecked(iJavaElementArray);
        if (iJavaElementArray.length > 0) {
            this.fInputGroup.setTreeSelection((ISelection)new StructuredSelection((Object)iJavaElementArray[0].getJavaProject()));
        }
        this.fInputGroup.aboutToOpen();
    }

    private void createVisibilitySet(Composite composite) {
        GridLayout gridLayout = this.createGridLayout(4);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite2.setLayout((Layout)gridLayout);
        this.createLabel(composite2, 0, JavadocExportMessages.JavadocTreeWizardPage_visibilitygroup_label, this.createGridData(768, 4, 0));
        this.fPrivateVisibility = this.createButton(composite2, 16, JavadocExportMessages.JavadocTreeWizardPage_privatebutton_label, this.createGridData(768, 1, 0));
        this.fPackageVisibility = this.createButton(composite2, 16, JavadocExportMessages.JavadocTreeWizardPage_packagebutton_label, this.createGridData(768, 1, 0));
        this.fProtectedVisibility = this.createButton(composite2, 16, JavadocExportMessages.JavadocTreeWizardPage_protectedbutton_label, this.createGridData(768, 1, 0));
        this.fPublicVisibility = this.createButton(composite2, 16, JavadocExportMessages.JavadocTreeWizardPage_publicbutton_label, this.createGridData(768, 1, 0));
        this.fDescriptionLabel = new CLabel(composite2, 16384);
        this.fDescriptionLabel.setLayoutData((Object)this.createGridData(768, 4, this.convertWidthInCharsToPixels(3) - 3));
        this.fPrivateVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PRIVATE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_privatevisibilitydescription_label);
                }
            }
        });
        this.fPackageVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PACKAGE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_packagevisibledescription_label);
                }
            }
        });
        this.fProtectedVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PROTECTED;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_protectedvisibilitydescription_label);
                }
            }
        });
        this.fPublicVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PUBLIC;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_publicvisibilitydescription_label);
                }
            }
        });
        this.setVisibilitySettings();
    }

    protected void setVisibilitySettings() {
        this.fVisibilitySelection = this.fStore.getAccess();
        this.fPrivateVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PRIVATE));
        if (this.fPrivateVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_privatevisibilitydescription_label);
        }
        this.fProtectedVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PROTECTED));
        if (this.fProtectedVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_protectedvisibilitydescription_label);
        }
        this.fPackageVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PACKAGE));
        if (this.fPackageVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_packagevisibledescription_label);
        }
        this.fPublicVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PUBLIC));
        if (this.fPublicVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.JavadocTreeWizardPage_publicvisibilitydescription_label);
        }
    }

    private void createOptionsSet(Composite composite) {
        GridLayout gridLayout = this.createGridLayout(4);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite2.setLayout((Layout)gridLayout);
        this.fStandardButton = this.createButton(composite2, 16, JavadocExportMessages.JavadocTreeWizardPage_standarddocletbutton_label, this.createGridData(256, 4, 0));
        this.fDestinationLabel = this.createLabel(composite2, 0, JavadocExportMessages.JavadocTreeWizardPage_destinationfield_label, this.createGridData(256, 1, this.convertWidthInCharsToPixels(3)));
        this.fDestinationText = this.createText(composite2, 2052, null, this.createGridData(768, 2, 0));
        ((GridData)this.fDestinationText.getLayoutData()).widthHint = 0;
        this.fDestinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton = this.createButton(composite2, 8, JavadocExportMessages.JavadocTreeWizardPage_destinationbrowse_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fDestinationBrowserButton);
        this.fCustomButton = this.createButton(composite2, 16, JavadocExportMessages.JavadocTreeWizardPage_customdocletbutton_label, this.createGridData(256, 4, 0));
        this.fDocletTypeLabel = this.createLabel(composite2, 0, JavadocExportMessages.JavadocTreeWizardPage_docletnamefield_label, this.createGridData(32, 1, this.convertWidthInCharsToPixels(3)));
        this.fDocletTypeText = this.createText(composite2, 2052, null, this.createGridData(256, 3, 0));
        ((GridData)this.fDocletTypeText.getLayoutData()).widthHint = 0;
        this.fDocletTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fDocletLabel = this.createLabel(composite2, 0, JavadocExportMessages.JavadocTreeWizardPage_docletpathfield_label, this.createGridData(32, 1, this.convertWidthInCharsToPixels(3)));
        this.fDocletText = this.createText(composite2, 2052, null, this.createGridData(256, 3, 0));
        ((GridData)this.fDocletText.getLayoutData()).widthHint = 0;
        this.fDocletText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fCustomButton.addSelectionListener((SelectionListener)new JavadocWizardPage.EnableSelectionAdapter(new Control[]{this.fDocletLabel, this.fDocletText, this.fDocletTypeLabel, this.fDocletTypeText}, new Control[]{this.fDestinationLabel, this.fDestinationText, this.fDestinationBrowserButton}));
        this.fCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fStandardButton.addSelectionListener((SelectionListener)new JavadocWizardPage.EnableSelectionAdapter(new Control[]{this.fDestinationLabel, this.fDestinationText, this.fDestinationBrowserButton}, new Control[]{this.fDocletLabel, this.fDocletText, this.fDocletTypeLabel, this.fDocletTypeText}));
        this.fStandardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = JavadocTreeWizardPage.this.handleFolderBrowseButtonPressed(JavadocTreeWizardPage.this.fDestinationText.getText(), JavadocExportMessages.JavadocTreeWizardPage_destinationbrowsedialog_title, JavadocExportMessages.JavadocTreeWizardPage_destinationbrowsedialog_label);
                JavadocTreeWizardPage.this.fDestinationText.setText(string);
            }
        });
        this.setOptionSetSettings();
    }

    public boolean getCustom() {
        return this.fCustomButton.getSelection();
    }

    private void setOptionSetSettings() {
        if (!this.fStore.isFromStandard()) {
            this.fCustomButton.setSelection(true);
            this.fDocletText.setText(this.fStore.getDocletPath());
            this.fDocletTypeText.setText(this.fStore.getDocletName());
            this.fDestinationText.setText(this.fStore.getDestination());
            this.fDestinationText.setEnabled(false);
            this.fDestinationBrowserButton.setEnabled(false);
            this.fDestinationLabel.setEnabled(false);
        } else {
            this.fStandardButton.setSelection(true);
            this.fDestinationText.setText(this.fStore.getDestination());
            this.fDocletText.setText(this.fStore.getDocletPath());
            this.fDocletTypeText.setText(this.fStore.getDocletName());
            this.fDocletText.setEnabled(false);
            this.fDocletLabel.setEnabled(false);
            this.fDocletTypeText.setEnabled(false);
            this.fDocletTypeLabel.setEnabled(false);
        }
        this.fJavadocCommandText.setItems(this.fStore.getJavadocCommandHistory());
        this.fJavadocCommandText.select(0);
    }

    private void setTreeChecked(IJavaElement[] iJavaElementArray) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot;
            IJavaElement iJavaElement = iJavaElementArray[n];
            if (iJavaElement instanceof ICompilationUnit) {
                this.fInputGroup.initialCheckListItem(iJavaElement);
            } else if (iJavaElement instanceof IPackageFragment) {
                this.fInputGroup.initialCheckTreeItem(iJavaElement);
            } else if (iJavaElement instanceof IJavaProject) {
                this.fInputGroup.initialCheckTreeItem(iJavaElement);
            } else if (iJavaElement instanceof IPackageFragmentRoot && !(iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement).isArchive()) {
                this.fInputGroup.initialCheckTreeItem(iJavaElement);
            }
            ++n;
        }
    }

    private IPath[] getSourcePath(IJavaProject[] iJavaProjectArray) {
        HashSet<IPath> hashSet = new HashSet<IPath>();
        int n = 0;
        while (n < iJavaProjectArray.length) {
            IJavaProject iJavaProject = iJavaProjectArray[n];
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                int n2 = 0;
                while (n2 < iPackageFragmentRootArray.length) {
                    IPath iPath;
                    IResource iResource;
                    IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (iPackageFragmentRoot.getKind() == 1 && (iResource = iPackageFragmentRoot.getResource()) != null && (iPath = iResource.getLocation()) != null) {
                        hashSet.add(iPath);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            ++n;
        }
        return hashSet.toArray(new IPath[hashSet.size()]);
    }

    private IPath[] getClassPath(IJavaProject[] iJavaProjectArray) {
        HashSet<IPath> hashSet = new HashSet<IPath>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < iJavaProjectArray.length) {
            IJavaProject iJavaProject = iJavaProjectArray[n];
            try {
                IPath iPath = null;
                IResource iResource = iWorkspaceRoot.findMember(iJavaProject.getOutputLocation());
                if (iResource != null) {
                    iPath = iResource.getLocation();
                }
                String[] stringArray = JavaRuntime.computeDefaultRuntimeClassPath(iJavaProject);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    IPath iPath2 = Path.fromOSString((String)stringArray[n2]);
                    if (!iPath2.equals((Object)iPath)) {
                        hashSet.add(iPath2);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            ++n;
        }
        return hashSet.toArray(new IPath[hashSet.size()]);
    }

    private IJavaElement[] getSourceElements(IJavaProject[] iJavaProjectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            Set set = this.fInputGroup.getAllCheckedTreeItems();
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < iJavaProjectArray.length) {
                object3 = iJavaProjectArray[n];
                object2 = object3.getPackageFragmentRoots();
                int n2 = 0;
                while (n2 < ((IPackageFragmentRoot[])object2).length) {
                    object = object2[n2];
                    if (object.getKind() == 1) {
                        IPath iPath = object.getResource().getLocation();
                        IJavaElement[] iJavaElementArray = object.getChildren();
                        int n3 = 0;
                        while (n3 < iJavaElementArray.length) {
                            IJavaElement iJavaElement = iJavaElementArray[n3];
                            if (!(iJavaElement.getElementType() != 4 || iJavaElement.getElementName().length() != 0 && set.contains(iJavaElement) && !this.fInputGroup.isTreeItemGreyChecked(iJavaElement) && this.isAccessibleLocation(iJavaElement.getResource().getLocation(), iPath))) {
                                hashSet.add(iJavaElement.getElementName());
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            Iterator iterator = this.fInputGroup.getAllCheckedListItems();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                if (!(object3 instanceof ICompilationUnit) || !hashSet.contains((object2 = (ICompilationUnit)object3).getParent().getElementName())) continue;
                arrayList.add(object2);
            }
            object3 = new HashSet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                IPackageFragment iPackageFragment;
                object2 = iterator.next();
                if (!(object2 instanceof IPackageFragment) || hashSet.contains(object = (iPackageFragment = (IPackageFragment)object2).getElementName()) || object3.contains(object)) continue;
                arrayList.add(iPackageFragment);
                object3.add(object);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    private boolean isAccessibleLocation(IPath iPath, IPath iPath2) {
        return iPath2 != null && iPath != null && iPath2.isPrefixOf(iPath);
    }

    protected void updateStore(IJavaProject[] iJavaProjectArray) {
        if (this.fCustomButton.getSelection()) {
            this.fStore.setDocletName(this.fDocletTypeText.getText());
            this.fStore.setDocletPath(this.fDocletText.getText());
            this.fStore.setFromStandard(false);
        }
        if (this.fStandardButton.getSelection()) {
            this.fStore.setFromStandard(true);
            this.fStore.setDestination(this.fDestinationText.getText());
        }
        this.fStore.setSourcepath(this.getSourcePath(iJavaProjectArray));
        this.fStore.setClasspath(this.getClassPath(iJavaProjectArray));
        this.fStore.setAccess(this.fVisibilitySelection);
        this.fStore.setSelectedElements(this.getSourceElements(iJavaProjectArray));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.fJavadocCommandText.getText());
        String[] stringArray = this.fJavadocCommandText.getItems();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            ++n;
        }
        this.fStore.setJavadocCommandHistory(arrayList.toArray(new String[arrayList.size()]));
    }

    public IJavaProject[] getCheckedProjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreeItem[] treeItemArray = this.fInputGroup.getTree().getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            Object object;
            if (treeItemArray[n].getChecked() && (object = treeItemArray[n].getData()) instanceof IJavaProject) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    protected void doValidation(int n) {
        switch (n) {
            case 0: {
                this.fPreferenceStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 1: {
                if (!this.fCustomButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                String string = this.fDocletTypeText.getText();
                String string2 = this.fDocletText.getText();
                if (string.length() == 0) {
                    this.fDocletStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_nodocletname_error);
                } else if (JavaConventions.validateJavaTypeName((String)string).matches(4)) {
                    this.fDocletStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_invaliddocletname_error);
                } else if (string2.length() == 0 || !this.validDocletPath(string2)) {
                    this.fDocletStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_invaliddocletpath_error);
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 2: {
                if (!this.fStandardButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                String string = this.fDestinationText.getText();
                if (string.length() == 0) {
                    this.fDestinationStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_nodestination_error);
                }
                File file = new File(string);
                if (!Path.ROOT.isValidPath(string) || file.isFile()) {
                    this.fDestinationStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_invaliddestination_error);
                }
                if (new File(string, "package-list").exists() || new File(string, "index.html").exists()) {
                    this.fDestinationStatus.setWarning(JavadocExportMessages.JavadocTreeWizardPage_warning_mayoverwritefiles);
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 3: {
                this.fTreeStatus = new StatusInfo();
                if (!this.fInputGroup.getAllCheckedListItems().hasNext()) {
                    this.fTreeStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_invalidtreeselection_error);
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 4: {
                this.fJavadocStatus = new StatusInfo();
                String string = this.fJavadocCommandText.getText();
                if (string.length() == 0) {
                    this.fJavadocStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_javadoccmd_error_enterpath);
                } else {
                    File file = new File(string);
                    if (!file.isFile()) {
                        this.fJavadocStatus.setError(JavadocExportMessages.JavadocTreeWizardPage_javadoccmd_error_notexists);
                    }
                }
                this.updateStatus(this.findMostSevereStatus());
            }
        }
    }

    protected void browseForJavadocCommand() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(JavadocExportMessages.JavadocTreeWizardPage_javadoccmd_dialog_title);
        String string = this.fJavadocCommandText.getText();
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        if (string2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = this.fJavadocCommandText.getItems();
            arrayList.add(string2);
            int n = 0;
            while (n < stringArray.length && arrayList.size() < 5) {
                String string3 = stringArray[n];
                if (!arrayList.contains(string3)) {
                    arrayList.add(string3);
                }
                ++n;
            }
            this.fJavadocCommandText.setItems(arrayList.toArray(new String[arrayList.size()]));
            this.fJavadocCommandText.select(0);
        }
    }

    private boolean validDocletPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fJavadocStatus, this.fPreferenceStatus, this.fDestinationStatus, this.fDocletStatus, this.fTreeStatus, this.fWizardStatus});
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.doValidation(2);
            this.doValidation(1);
            this.doValidation(3);
            this.doValidation(0);
            this.doValidation(4);
        }
        super.setVisible(bl);
    }
}

