/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.wst.jsdt.internal.ui.text.JavaIndenter;

public final class IndentUtil {
    private static final String SLASHES = "//";

    private IndentUtil() {
    }

    public static IndentResult indentLines(IDocument iDocument, ILineRange iLineRange, IJavaProject iJavaProject, IndentResult indentResult) throws BadLocationException {
        int n = iLineRange.getNumberOfLines();
        if (n < 1) {
            return new IndentResult(null);
        }
        indentResult = IndentUtil.reuseOrCreateToken(indentResult, n);
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
        JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, iJavaProject);
        boolean bl = false;
        int n2 = CodeFormatterUtil.getTabWidth(iJavaProject);
        int n3 = iLineRange.getStartLine();
        int n4 = n3 + n;
        int n5 = 0;
        while (n3 < n4) {
            bl |= IndentUtil.indentLine(iDocument, n3, javaIndenter, javaHeuristicScanner, indentResult.commentLinesAtColumnZero, n5++, n2);
            ++n3;
        }
        indentResult.hasChanged = bl;
        return indentResult;
    }

    public static IndentResult shiftLines(IDocument iDocument, ILineRange iLineRange, IJavaProject iJavaProject, IndentResult indentResult) throws BadLocationException {
        int n = iLineRange.getNumberOfLines();
        if (n < 1) {
            return new IndentResult(null);
        }
        indentResult = IndentUtil.reuseOrCreateToken(indentResult, n);
        indentResult.hasChanged = false;
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
        JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, iJavaProject);
        String string = IndentUtil.getCurrentIndent(iDocument, iLineRange.getStartLine());
        StringBuffer stringBuffer = javaIndenter.computeIndentation(iDocument.getLineOffset(iLineRange.getStartLine()));
        if (stringBuffer == null) {
            return indentResult;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = CodeFormatterUtil.getTabWidth(iJavaProject);
        int n3 = IndentUtil.subtractIndent(stringBuffer, string, stringBuffer2, n2);
        if (n3 == 0) {
            return indentResult;
        }
        if (indentResult.leftmostLine == -1) {
            indentResult.leftmostLine = IndentUtil.getLeftMostLine(iDocument, iLineRange, n2);
        }
        int n4 = IndentUtil.computeVisualLength(IndentUtil.getCurrentIndent(iDocument, indentResult.leftmostLine + iLineRange.getStartLine()), n2);
        if (n3 > 0) {
            int n5 = iLineRange.getStartLine();
            int n6 = n5 + n;
            int n7 = 0;
            while (n5 < n6) {
                IndentUtil.addIndent(iDocument, n5, stringBuffer2, indentResult.commentLinesAtColumnZero, n7++);
                ++n5;
            }
        } else {
            int n8 = Math.min(-n3, n4);
            int n9 = iLineRange.getStartLine();
            int n10 = n9 + n;
            int n11 = 0;
            while (n9 < n10) {
                IndentUtil.cutIndent(iDocument, n9, n8, n2, indentResult.commentLinesAtColumnZero, n11++);
                ++n9;
            }
        }
        indentResult.hasChanged = true;
        return indentResult;
    }

    private static void addIndent(IDocument iDocument, int n, CharSequence charSequence, boolean[] blArray, int n2) throws BadLocationException {
        IRegion iRegion = iDocument.getLineInformation(n);
        int n3 = iRegion.getOffset();
        int n4 = iRegion.getOffset() + iRegion.getLength();
        if (!blArray[n2]) {
            while (n3 < n4 - 2 && iDocument.get(n3, 2).equals(SLASHES)) {
                n3 += 2;
            }
        }
        iDocument.replace(n3, 0, charSequence.toString());
    }

    private static void cutIndent(IDocument iDocument, int n, int n2, int n3, boolean[] blArray, int n4) throws BadLocationException {
        IRegion iRegion = iDocument.getLineInformation(n);
        int n5 = iRegion.getOffset();
        int n6 = iRegion.getOffset() + iRegion.getLength();
        while (n5 < n6 - 2 && iDocument.get(n5, 2).equals(SLASHES)) {
            n5 += 2;
        }
        int n7 = n5;
        while (n2 > 0 && n7 < n6) {
            char c = iDocument.getChar(n7);
            if (!Character.isWhitespace(c) || (n2 -= IndentUtil.computeVisualLength(c, n3)) < 0) break;
            ++n7;
        }
        if (n6 > n7 + 1 && iDocument.get(n7, 2).equals(SLASHES)) {
            blArray[n4] = true;
        }
        iDocument.replace(n5, n7 - n5, null);
    }

    private static int subtractIndent(CharSequence charSequence, CharSequence charSequence2, StringBuffer stringBuffer, int n) {
        int n2;
        int n3 = IndentUtil.computeVisualLength(charSequence, n);
        int n4 = n3 - (n2 = IndentUtil.computeVisualLength(charSequence2, n));
        if (n4 <= 0) {
            return n4;
        }
        stringBuffer.setLength(0);
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            char c = charSequence.charAt(n6++);
            stringBuffer.append(c);
            n5 += IndentUtil.computeVisualLength(c, n);
        }
        return n4;
    }

    private static int computeVisualLength(char c, int n) {
        if (c == '\t') {
            return n;
        }
        return 1;
    }

    private static int computeVisualLength(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < charSequence.length()) {
            char c = charSequence.charAt(n3);
            if (c == '\t') {
                if (n != 0) {
                    n2 += n - n2 % n;
                }
            } else {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private static String getCurrentIndent(IDocument iDocument, int n) throws BadLocationException {
        String string;
        IRegion iRegion = iDocument.getLineInformation(n);
        int n2 = iRegion.getOffset();
        int n3 = iRegion.getOffset() + iRegion.getLength();
        int n4 = n2;
        while (n4 < n3 - 2 && iDocument.get(n4, 2).equals(SLASHES)) {
            n4 += 2;
        }
        while (n4 < n3) {
            char c = iDocument.getChar(n4);
            if (!Character.isWhitespace(c)) break;
            ++n4;
        }
        if (n4 > n2 && n4 < n3 - 1 && iDocument.get(n4 - 1, 2).equals(" *") && ((string = TextUtilities.getContentType((IDocument)iDocument, (String)"___java_partitioning", (int)n4, (boolean)true)).equals("__java_javadoc") || string.equals("__java_multiline_comment"))) {
            --n4;
        }
        return iDocument.get(n2, n4 - n2);
    }

    private static int getLeftMostLine(IDocument iDocument, ILineRange iLineRange, int n) throws BadLocationException {
        int n2 = iLineRange.getNumberOfLines();
        int n3 = iLineRange.getStartLine();
        int n4 = -1;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = IndentUtil.computeVisualLength(IndentUtil.getCurrentIndent(iDocument, n6 + n3), n);
            if (n7 < n5) {
                n5 = n7;
                n4 = n6;
            }
            ++n6;
        }
        return n4;
    }

    private static IndentResult reuseOrCreateToken(IndentResult indentResult, int n) {
        if (indentResult == null) {
            indentResult = new IndentResult(new boolean[n]);
        } else if (indentResult.commentLinesAtColumnZero == null) {
            indentResult.commentLinesAtColumnZero = new boolean[n];
        } else if (indentResult.commentLinesAtColumnZero.length != n) {
            boolean[] blArray = new boolean[n];
            System.arraycopy(indentResult.commentLinesAtColumnZero, 0, blArray, 0, Math.min(n, indentResult.commentLinesAtColumnZero.length));
            indentResult.commentLinesAtColumnZero = blArray;
        }
        return indentResult;
    }

    private static boolean indentLine(IDocument iDocument, int n, JavaIndenter javaIndenter, JavaHeuristicScanner javaHeuristicScanner, boolean[] blArray, int n2, int n3) throws BadLocationException {
        ITypedRegion iTypedRegion;
        int n4;
        int n5;
        Object object;
        int n6;
        IRegion iRegion = iDocument.getLineInformation(n);
        int n7 = n6 = iRegion.getOffset();
        String string = null;
        if (n6 < iDocument.getLength()) {
            object = TextUtilities.getPartition((IDocument)iDocument, (String)"___java_partitioning", (int)n6, (boolean)true);
            ITypedRegion iTypedRegion2 = TextUtilities.getPartition((IDocument)iDocument, (String)"___java_partitioning", (int)n6, (boolean)false);
            String string2 = object.getType();
            if (string2.equals("__java_javadoc") || string2.equals("__java_multiline_comment")) {
                string = IndentUtil.computeJavadocIndent(iDocument, n, javaHeuristicScanner, iTypedRegion2);
            } else if (!blArray[n2] && iTypedRegion2.getOffset() == n6 && iTypedRegion2.getType().equals("__java_singleline_comment")) {
                return false;
            }
        }
        if (string == null) {
            object = javaIndenter.computeIndentation(n6);
            string = object != null ? ((StringBuffer)object).toString() : new String();
        }
        if ((n5 = javaHeuristicScanner.findNonWhitespaceForwardInAnyPartition(n7, n6 + (n4 = iRegion.getLength()))) == -1) {
            n5 = n6 + n4;
        }
        int n8 = n5 - n6;
        String string3 = iDocument.get(n6, n8);
        if (n8 > 0 && (iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)"___java_partitioning", (int)n5, (boolean)false)).getOffset() == n5 && "__java_singleline_comment".equals(iTypedRegion.getType())) {
            blArray[n2] = true;
        }
        if (!string.equals(string3)) {
            iDocument.replace(n6, n8, string);
            return true;
        }
        return false;
    }

    private static String computeJavadocIndent(IDocument iDocument, int n, JavaHeuristicScanner javaHeuristicScanner, ITypedRegion iTypedRegion) throws BadLocationException {
        int n2;
        int n3;
        if (n == 0) {
            return null;
        }
        IRegion iRegion = iDocument.getLineInformation(n);
        int n4 = iRegion.getOffset();
        int n5 = javaHeuristicScanner.findNonWhitespaceForwardInAnyPartition(n4, n3 = n4 + (n2 = iRegion.getLength()));
        if (n5 == -1 || iDocument.getChar(n5) != '*') {
            if (n5 == -1) {
                return iDocument.get(n4, n2);
            }
            return iDocument.get(n4, n5 - n4);
        }
        IRegion iRegion2 = iDocument.getLineInformation(n - 1);
        int n6 = iRegion2.getOffset();
        int n7 = iRegion2.getLength();
        int n8 = n6 + n7;
        StringBuffer stringBuffer = new StringBuffer();
        int n9 = javaHeuristicScanner.findNonWhitespaceForwardInAnyPartition(n6, n8);
        if (n9 == -1 || iDocument.getChar(n9) != '*') {
            iRegion2 = iDocument.getLineInformationOfOffset(iTypedRegion.getOffset());
            n6 = iRegion2.getOffset();
            n9 = javaHeuristicScanner.findNonWhitespaceForwardInAnyPartition(n6, n8 = n6 + (n7 = iRegion2.getLength()));
            if (n9 == -1) {
                n9 = n8;
            }
            stringBuffer.append(' ');
        }
        String string = iDocument.get(n6, n9 - n6);
        stringBuffer.insert(0, string);
        return stringBuffer.toString();
    }

    public static final class IndentResult {
        private boolean[] commentLinesAtColumnZero;
        private boolean hasChanged;
        private int leftmostLine = -1;

        private IndentResult(boolean[] blArray) {
            this.commentLinesAtColumnZero = blArray;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }
    }
}

