/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.NLSKeyHyperlink;

public class NLSKeyHyperlinkDetector
extends AbstractHyperlinkDetector {
    static /* synthetic */ Class class$0;

    public IHyperlink[] detectHyperlinks(ITextViewer iTextViewer, IRegion iRegion, boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITextEditor iTextEditor = (ITextEditor)this.getAdapter(clazz);
        if (iRegion == null || iTextEditor == null || bl) {
            return null;
        }
        IEditorSite iEditorSite = iTextEditor.getEditorSite();
        if (iEditorSite == null) {
            return null;
        }
        IJavaElement iJavaElement = this.getInputJavaElement(iTextEditor);
        if (iJavaElement == null) {
            return null;
        }
        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST(iJavaElement, ASTProvider.WAIT_NO, null);
        if (compilationUnit == null) {
            return null;
        }
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iRegion.getOffset(), 1);
        if (!(aSTNode instanceof StringLiteral) && !(aSTNode instanceof SimpleName)) {
            return null;
        }
        if (aSTNode.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        Region region = new Region(aSTNode.getStartPosition(), aSTNode.getLength());
        AccessorClassReference accessorClassReference = NLSHintHelper.getAccessorClassReference(compilationUnit, (IRegion)region);
        if (accessorClassReference == null) {
            return null;
        }
        String string = null;
        string = aSTNode instanceof StringLiteral ? ((StringLiteral)aSTNode).getLiteralValue() : ((SimpleName)aSTNode).getIdentifier();
        if (string != null) {
            return new IHyperlink[]{new NLSKeyHyperlink((IRegion)region, string, accessorClassReference, (IEditorPart)iTextEditor)};
        }
        return null;
    }

    private IJavaElement getInputJavaElement(ITextEditor iTextEditor) {
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (iEditorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)iEditorInput).getClassFile();
        }
        if (iTextEditor instanceof CompilationUnitEditor) {
            return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput);
        }
        return null;
    }
}

