/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;

public class TogglePresentationAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public TogglePresentationAction() {
        super(JavaEditorMessages.getBundleForConstructedKeys(), "TogglePresentation.", null, 2);
        JavaPluginImages.setToolImageDescriptors((IAction)this, "segment_edit.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.toggle_presentation_action_context");
        this.update();
    }

    public void run() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return;
        }
        IRegion iRegion = iTextEditor.getHighlightRange();
        iTextEditor.resetHighlightRange();
        boolean bl = !iTextEditor.showsHighlightRangeOnly();
        this.setChecked(bl);
        iTextEditor.showHighlightRangeOnly(bl);
        if (iRegion != null) {
            iTextEditor.setHighlightRange(iRegion.getOffset(), iRegion.getLength(), true);
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("org.eclipse.wst.jsdt.ui.editor.showSegments", bl);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        ITextEditor iTextEditor = this.getTextEditor();
        boolean bl = iTextEditor != null && iTextEditor.showsHighlightRangeOnly();
        this.setChecked(bl);
        if (iTextEditor instanceof CompilationUnitEditor) {
            WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
            this.setEnabled(workingCopyManager.getWorkingCopy(iTextEditor.getEditorInput()) != null);
        } else if (iTextEditor instanceof ClassFileEditor) {
            IEditorInput iEditorInput = iTextEditor.getEditorInput();
            IClassFile iClassFile = null;
            if (iEditorInput instanceof IClassFileEditorInput) {
                IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)iEditorInput;
                iClassFile = iClassFileEditorInput.getClassFile();
            }
            this.setEnabled(iClassFile != null && iClassFile.exists());
        } else {
            this.setEnabled(iTextEditor != null);
        }
    }

    public void setEditor(ITextEditor iTextEditor) {
        super.setEditor(iTextEditor);
        if (iTextEditor != null) {
            if (this.fStore == null) {
                this.fStore = JavaPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference(iTextEditor);
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    private void synchronizeWithPreference(ITextEditor iTextEditor) {
        if (iTextEditor == null) {
            return;
        }
        boolean bl = this.fStore.getBoolean("org.eclipse.wst.jsdt.ui.editor.showSegments");
        this.setChecked(bl);
        if (iTextEditor.showsHighlightRangeOnly() != bl) {
            IRegion iRegion = iTextEditor.getHighlightRange();
            iTextEditor.resetHighlightRange();
            iTextEditor.showHighlightRangeOnly(bl);
            if (iRegion != null) {
                iTextEditor.setHighlightRange(iRegion.getOffset(), iRegion.getLength(), true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("org.eclipse.wst.jsdt.ui.editor.showSegments")) {
            this.synchronizeWithPreference(this.getTextEditor());
        }
    }
}

