/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;

public class GoToNextPreviousMemberAction
extends Action
implements IUpdate {
    public static final String NEXT_MEMBER = "GoToNextMember";
    public static final String PREVIOUS_MEMBER = "GoToPreviousMember";
    private JavaEditor fEditor;
    private boolean fIsGotoNext;

    public static GoToNextPreviousMemberAction newGoToNextMemberAction(JavaEditor javaEditor) {
        String string = SelectionActionMessages.GotoNextMember_label;
        return new GoToNextPreviousMemberAction(javaEditor, string, true);
    }

    public static GoToNextPreviousMemberAction newGoToPreviousMemberAction(JavaEditor javaEditor) {
        String string = SelectionActionMessages.GotoPreviousMember_label;
        return new GoToNextPreviousMemberAction(javaEditor, string, false);
    }

    private GoToNextPreviousMemberAction(JavaEditor javaEditor, String string, boolean bl) {
        super(string);
        Assert.isNotNull((Object)javaEditor);
        this.fEditor = javaEditor;
        this.fIsGotoNext = bl;
        this.update();
        if (bl) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_next_member_action");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_previous_member_action");
        }
    }

    public GoToNextPreviousMemberAction(boolean bl) {
        super("");
        this.fIsGotoNext = bl;
    }

    public void update() {
        boolean bl = false;
        ISourceReference iSourceReference = this.getSourceReference();
        if (iSourceReference != null) {
            try {
                ISourceRange iSourceRange = iSourceReference.getSourceRange();
                bl = iSourceRange != null && iSourceRange.getLength() > 0;
            }
            catch (JavaModelException javaModelException) {}
        }
        this.setEnabled(bl);
    }

    public final void run() {
        ITextSelection iTextSelection = this.getTextSelection();
        ISourceRange iSourceRange = this.getNewSelectionRange(GoToNextPreviousMemberAction.createSourceRange(iTextSelection), null);
        if (iTextSelection.getOffset() == iSourceRange.getOffset() && iTextSelection.getLength() == iSourceRange.getLength()) {
            return;
        }
        this.fEditor.selectAndReveal(iSourceRange.getOffset(), iSourceRange.getLength());
    }

    private IType[] getTypes() throws JavaModelException {
        IEditorInput iEditorInput = this.fEditor.getEditorInput();
        if (iEditorInput instanceof IClassFileEditorInput) {
            return new IType[]{((IClassFileEditorInput)iEditorInput).getClassFile().getType()};
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput).getAllTypes();
    }

    private ISourceReference getSourceReference() {
        IEditorInput iEditorInput = this.fEditor.getEditorInput();
        if (iEditorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)iEditorInput).getClassFile();
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput);
    }

    private ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    public ISourceRange getNewSelectionRange(ISourceRange iSourceRange, IType[] iTypeArray) {
        try {
            Object[] objectArray;
            if (iTypeArray == null) {
                iTypeArray = this.getTypes();
            }
            if ((objectArray = GoToNextPreviousMemberAction.createOffsetArray(iTypeArray)).length == 0) {
                return iSourceRange;
            }
            Arrays.sort(objectArray);
            Integer n = new Integer(iSourceRange.getOffset());
            int n2 = Arrays.binarySearch(objectArray, n);
            if (this.fIsGotoNext) {
                return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getNextOffset(n2, (Integer[])objectArray, n));
            }
            return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getPreviousOffset(n2, (Integer[])objectArray, n));
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return iSourceRange;
        }
    }

    private static Integer getPreviousOffset(int n, Integer[] integerArray, Integer n2) {
        if (n == -1) {
            return n2;
        }
        if (n == 0) {
            return integerArray[0];
        }
        if (n > 0) {
            return integerArray[n - 1];
        }
        Assert.isTrue((n < -1 ? 1 : 0) != 0);
        int n3 = Math.abs(n);
        return integerArray[n3 - 2];
    }

    private static Integer getNextOffset(int n, Integer[] integerArray, Integer n2) {
        if (n == -1) {
            return integerArray[0];
        }
        if (n == 0) {
            if (integerArray.length != 1) {
                return integerArray[1];
            }
            return integerArray[0];
        }
        if (n > 0) {
            if (n == integerArray.length - 1) {
                return n2;
            }
            return integerArray[n + 1];
        }
        Assert.isTrue((n < -1 ? 1 : 0) != 0);
        int n3 = Math.abs(n);
        if (n3 > integerArray.length) {
            return n2;
        }
        return integerArray[n3 - 1];
    }

    private static ISourceRange createNewSourceRange(Integer n) {
        return new SourceRange(n, 0);
    }

    private static Integer[] createOffsetArray(IType[] iTypeArray) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            GoToNextPreviousMemberAction.addOffset(arrayList, iType.getNameRange().getOffset());
            GoToNextPreviousMemberAction.addOffset(arrayList, iType.getSourceRange().getOffset() + iType.getSourceRange().getLength());
            GoToNextPreviousMemberAction.addMemberOffsetList(arrayList, (IMember[])iType.getMethods());
            GoToNextPreviousMemberAction.addMemberOffsetList(arrayList, (IMember[])iType.getFields());
            GoToNextPreviousMemberAction.addMemberOffsetList(arrayList, (IMember[])iType.getInitializers());
            ++n;
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    private static void addMemberOffsetList(List list, IMember[] iMemberArray) throws JavaModelException {
        int n = 0;
        while (n < iMemberArray.length) {
            GoToNextPreviousMemberAction.addOffset(list, GoToNextPreviousMemberAction.getOffset(iMemberArray[n]));
            ++n;
        }
    }

    private static int getOffset(IMember iMember) throws JavaModelException {
        if (iMember.getElementType() == 10) {
            return GoToNextPreviousMemberAction.firstOpeningBraceOffset((IInitializer)iMember);
        }
        if (iMember.getNameRange() != null && iMember.getNameRange().getOffset() >= 0) {
            return iMember.getNameRange().getOffset();
        }
        return iMember.getSourceRange().getOffset();
    }

    private static int firstOpeningBraceOffset(IInitializer iInitializer) throws JavaModelException {
        try {
            IScanner iScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            iScanner.setSource(iInitializer.getSource().toCharArray());
            int n = iScanner.getNextToken();
            while (n != 158 && n != 110) {
                n = iScanner.getNextToken();
            }
            if (n == 110) {
                return iInitializer.getSourceRange().getOffset() + iScanner.getCurrentTokenStartPosition() + iScanner.getRawTokenSource().length;
            }
            return iInitializer.getSourceRange().getOffset();
        }
        catch (InvalidInputException invalidInputException) {
            return iInitializer.getSourceRange().getOffset();
        }
    }

    private static ISourceRange createSourceRange(ITextSelection iTextSelection) {
        return new SourceRange(iTextSelection.getOffset(), iTextSelection.getLength());
    }

    private static void addOffset(List list, int n) {
        if (n >= 0) {
            list.add(new Integer(n));
        }
    }
}

