/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.StructureSelectionAction;

public class StructureSelectPreviousAction
extends StructureSelectionAction {
    public StructureSelectPreviousAction(JavaEditor javaEditor, SelectionHistory selectionHistory) {
        super(SelectionActionMessages.StructureSelectPrevious_label, javaEditor, selectionHistory);
        this.setToolTipText(SelectionActionMessages.StructureSelectPrevious_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectPrevious_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.structured_select_previous_action");
    }

    public StructureSelectPreviousAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange iSourceRange, ISourceReference iSourceReference, SelectionAnalyzer selectionAnalyzer) throws JavaModelException {
        ASTNode aSTNode;
        if (iSourceRange.getLength() == 0 && selectionAnalyzer.getLastCoveringNode() != null && (aSTNode = PreviousNodeAnalyzer.perform(iSourceRange.getOffset(), selectionAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectPreviousAction.getSelectedNodeSourceRange(iSourceReference, aSTNode);
        }
        aSTNode = selectionAnalyzer.getFirstSelectedNode();
        if (aSTNode == null) {
            return StructureSelectPreviousAction.getLastCoveringNodeRange(iSourceRange, iSourceReference, selectionAnalyzer);
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 == null) {
            return StructureSelectPreviousAction.getLastCoveringNodeRange(iSourceRange, iSourceReference, selectionAnalyzer);
        }
        ASTNode aSTNode3 = StructureSelectPreviousAction.getPreviousNode(aSTNode2, selectionAnalyzer.getSelectedNodes()[0]);
        if (aSTNode3 == aSTNode2) {
            return StructureSelectPreviousAction.getSelectedNodeSourceRange(iSourceReference, aSTNode2);
        }
        int n = aSTNode3.getStartPosition();
        int n2 = iSourceRange.getOffset() + iSourceRange.getLength() - 1;
        return StructureSelectionAction.createSourceRange(n, n2);
    }

    private static ASTNode getPreviousNode(ASTNode aSTNode, ASTNode aSTNode2) {
        Object[] objectArray = StructureSelectionAction.getSiblingNodes(aSTNode2);
        if (objectArray == null || objectArray.length == 0) {
            return aSTNode;
        }
        if (aSTNode2 == objectArray[0]) {
            return aSTNode;
        }
        int n = StructureSelectionAction.findIndex(objectArray, aSTNode2);
        if (n < 1) {
            return aSTNode;
        }
        return objectArray[n - 1];
    }

    private static class PreviousNodeAnalyzer
    extends GenericVisitor {
        private final int fOffset;
        private ASTNode fPreviousNode;

        private PreviousNodeAnalyzer(int n) {
            super(true);
            this.fOffset = n;
        }

        public static ASTNode perform(int n, ASTNode aSTNode) {
            PreviousNodeAnalyzer previousNodeAnalyzer = new PreviousNodeAnalyzer(n);
            aSTNode.accept((ASTVisitor)previousNodeAnalyzer);
            return previousNodeAnalyzer.fPreviousNode;
        }

        protected boolean visitNode(ASTNode aSTNode) {
            int n = aSTNode.getStartPosition();
            int n2 = n + aSTNode.getLength();
            if (n2 == this.fOffset) {
                this.fPreviousNode = aSTNode;
                return true;
            }
            return n < this.fOffset && this.fOffset < n2;
        }
    }
}

