/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

class FileTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    FileTransferDropAdapter(AbstractTreeViewer abstractTreeViewer) {
        super((StructuredViewer)abstractTreeViewer, 24);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent dropTargetEvent) {
        Object object;
        Object object2 = object = dropTargetEvent.item != null ? dropTargetEvent.item.getData() : null;
        if (object == null) {
            return false;
        }
        return object instanceof IJavaElement || object instanceof IResource;
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
        dropTargetEvent.detail = 0;
        boolean bl = object instanceof IPackageFragment;
        boolean bl2 = object instanceof IJavaProject;
        boolean bl3 = object instanceof IPackageFragmentRoot;
        boolean bl4 = object instanceof IContainer;
        if (!(bl || bl2 || bl3 || bl4)) {
            return;
        }
        if (bl4) {
            IContainer iContainer = (IContainer)object;
            if (iContainer.isAccessible() && !Resources.isReadOnly((IResource)iContainer)) {
                dropTargetEvent.detail = 1;
            }
        } else {
            IJavaElement iJavaElement = (IJavaElement)object;
            if (!iJavaElement.isReadOnly()) {
                dropTargetEvent.detail = 1;
            }
        }
    }

    public void drop(Object object, final DropTargetEvent dropTargetEvent) {
        try {
            int n = dropTargetEvent.detail;
            dropTargetEvent.detail = 0;
            final Object object2 = dropTargetEvent.data;
            if (object2 == null || !(object2 instanceof String[]) || n != 1) {
                return;
            }
            final IContainer iContainer = this.getActualTarget(object);
            if (iContainer == null) {
                return;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    FileTransferDropAdapter.this.getShell().forceActive();
                    new CopyFilesAndFoldersOperation(FileTransferDropAdapter.this.getShell()).copyFiles((String[])object2, iContainer);
                    dropTargetEvent.detail = 1;
                }
            });
        }
        catch (JavaModelException javaModelException) {
            String string = PackagesMessages.DropAdapter_errorTitle;
            String string2 = PackagesMessages.DropAdapter_errorMessage;
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), string, string2);
        }
    }

    private IContainer getActualTarget(Object object) throws JavaModelException {
        if (object instanceof IContainer) {
            return (IContainer)object;
        }
        if (object instanceof IJavaElement) {
            return this.getActualTarget(((IJavaElement)object).getCorrespondingResource());
        }
        return null;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

