/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;

class GotoTypeAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    GotoTypeAction(PackageExplorerPart packageExplorerPart) {
        this.setText(PackagesMessages.GotoType_action_label);
        this.setDescription(PackagesMessages.GotoType_action_description);
        this.fPackageExplorer = packageExplorerPart;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_type_action");
    }

    public void run() {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        SelectionDialog selectionDialog = null;
        try {
            selectionDialog = JavaUI.createTypeDialog(shell, (IRunnableContext)new ProgressMonitorDialog(shell), SearchEngine.createWorkspaceScope(), 256, false);
        }
        catch (JavaModelException javaModelException) {
            String string = this.getDialogTitle();
            String string2 = PackagesMessages.GotoType_error_message;
            ExceptionHandler.handle((CoreException)((Object)javaModelException), string, string2);
            return;
        }
        selectionDialog.setTitle(this.getDialogTitle());
        selectionDialog.setMessage(PackagesMessages.GotoType_dialog_message);
        if (selectionDialog.open() == 1) {
            return;
        }
        Object[] objectArray = selectionDialog.getResult();
        if (objectArray != null && objectArray.length > 0) {
            this.gotoType((IType)objectArray[0]);
        }
    }

    private void gotoType(IType iType) {
        PackageExplorerPart packageExplorerPart;
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iType.getAncestor(5);
        Object object = null;
        object = iCompilationUnit != null ? iCompilationUnit.getPrimary() : iType.getAncestor(6);
        if (object != null && (packageExplorerPart = PackageExplorerPart.openInActivePerspective()) != null) {
            packageExplorerPart.selectReveal((ISelection)new StructuredSelection(object));
            if (!object.equals(this.getSelectedElement(packageExplorerPart))) {
                MessageDialog.openInformation((Shell)this.fPackageExplorer.getSite().getShell(), (String)this.getDialogTitle(), (String)Messages.format(PackagesMessages.PackageExplorer_element_not_present, object.getElementName()));
            }
        }
    }

    private Object getSelectedElement(PackageExplorerPart packageExplorerPart) {
        return ((IStructuredSelection)packageExplorerPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private String getDialogTitle() {
        return PackagesMessages.GotoType_dialog_title;
    }
}

