/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;

public class WorkingSetDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    private PackageExplorerPart fPackageExplorer;
    private IStructuredSelection fSelection;
    private Object[] fElementsToAdds;
    private Set fCurrentElements;
    private IWorkingSet fWorkingSet;

    public WorkingSetDropAdapter(PackageExplorerPart packageExplorerPart) {
        super((StructuredViewer)packageExplorerPart.getTreeViewer(), 24);
        this.fPackageExplorer = packageExplorerPart;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent dropTargetEvent) {
        Object object;
        Object object2 = object = dropTargetEvent.item != null ? dropTargetEvent.item.getData() : null;
        if (object == null) {
            return false;
        }
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (!this.isValidSelection(iSelection)) {
            return false;
        }
        if (!this.isValidTarget(object)) {
            return false;
        }
        this.initializeState(object, iSelection);
        return true;
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
        dropTargetEvent.detail = 0;
        switch (n) {
            case 1: 
            case 2: 
            case 16: {
                dropTargetEvent.detail = this.validateTarget(object, n);
                break;
            }
            case 4: {
                dropTargetEvent.detail = 0;
            }
        }
    }

    private int validateTarget(Object object, int n) {
        IResource iResource;
        this.showInsertionFeedback(false);
        this.setDefaultFeedback(24);
        if (!this.isValidTarget(object)) {
            return 0;
        }
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (!this.isValidSelection(iSelection)) {
            return 0;
        }
        this.initializeState(object, iSelection);
        if (this.isWorkingSetSelection()) {
            this.setDefaultFeedback(8);
            if (this.fLocation == 2 || this.fLocation == 4) {
                this.showInsertionFeedback(true);
                return 2;
            }
            return 0;
        }
        if (this.isOthersWorkingSet(this.fWorkingSet) && n == 1) {
            return 0;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ReorgUtils.splitIntoJavaElementsAndResources(this.fElementsToAdds, arrayList, arrayList2);
        if (this.fElementsToAdds.length != arrayList.size() + arrayList2.size()) {
            return 0;
        }
        ITreeSelection iTreeSelection = arrayList.iterator();
        while (iTreeSelection.hasNext()) {
            iResource = (IResource)iTreeSelection.next();
            if (!ReorgUtils.containsElementOrParent(this.fCurrentElements, (IJavaElement)iResource)) continue;
            return 0;
        }
        iTreeSelection = arrayList2.iterator();
        while (iTreeSelection.hasNext()) {
            iResource = (IResource)iTreeSelection.next();
            if (!ReorgUtils.containsElementOrParent(this.fCurrentElements, iResource)) continue;
            return 0;
        }
        if (!(this.fSelection instanceof ITreeSelection)) {
            return 1;
        }
        iTreeSelection = (ITreeSelection)this.fSelection;
        iResource = iTreeSelection.getPaths();
        int n2 = 0;
        while (n2 < ((TreePath[])iResource).length) {
            IWorkingSet iWorkingSet;
            TreePath treePath = iResource[n2];
            if (treePath.getSegmentCount() != 2) {
                return 1;
            }
            if (!(treePath.getSegment(0) instanceof IWorkingSet)) {
                return 1;
            }
            if (((TreePath[])iResource).length == 1 && "org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet".equals((iWorkingSet = (IWorkingSet)treePath.getSegment(0)).getId())) {
                return 2;
            }
            ++n2;
        }
        if (n == 16) {
            return 2;
        }
        return n;
    }

    private boolean isValidTarget(Object object) {
        return object instanceof IWorkingSet;
    }

    private boolean isValidSelection(ISelection iSelection) {
        return iSelection instanceof IStructuredSelection;
    }

    private boolean isOthersWorkingSet(IWorkingSet iWorkingSet) {
        return "org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet".equals(iWorkingSet.getId());
    }

    private void initializeState(Object object, ISelection iSelection) {
        this.fWorkingSet = (IWorkingSet)object;
        this.fSelection = (IStructuredSelection)iSelection;
        this.fElementsToAdds = this.fSelection.toArray();
        this.fCurrentElements = new HashSet<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
    }

    private boolean isWorkingSetSelection() {
        int n = 0;
        while (n < this.fElementsToAdds.length) {
            if (!(this.fElementsToAdds[n] instanceof IWorkingSet)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void drop(Object object, DropTargetEvent dropTargetEvent) {
        if (this.isWorkingSetSelection()) {
            this.performWorkingSetReordering();
        } else {
            this.performElementRearrange(dropTargetEvent.detail);
        }
        dropTargetEvent.detail = 0;
    }

    private void performWorkingSetReordering() {
        WorkingSetModel workingSetModel = this.fPackageExplorer.getWorkingSetModel();
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>(Arrays.asList(workingSetModel.getActiveWorkingSets()));
        int n = arrayList.indexOf(this.fWorkingSet);
        if (n != -1) {
            if (this.fLocation == 4) {
                ++n;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
            ArrayList<Object> arrayList3 = new ArrayList<Object>(Arrays.asList(this.fElementsToAdds));
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Object e;
                if (n2 == n) {
                    arrayList2.addAll(arrayList3);
                }
                if (!arrayList3.contains(e = arrayList.get(n2))) {
                    arrayList2.add(e);
                }
                ++n2;
            }
            if (n == arrayList.size()) {
                arrayList2.addAll(arrayList3);
            }
            workingSetModel.setActiveWorkingSets(arrayList2.toArray(new IWorkingSet[arrayList2.size()]));
        }
    }

    private void performElementRearrange(int n) {
        Object object;
        if (!this.isOthersWorkingSet(this.fWorkingSet)) {
            object = new ArrayList<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
            object.addAll(Arrays.asList(this.fElementsToAdds));
            this.fWorkingSet.setElements(object.toArray(new IAdaptable[object.size()]));
        }
        if (n == 2) {
            object = (ITreeSelection)this.fSelection;
            Map map = this.groupByWorkingSets(object.getPaths());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                IWorkingSet iWorkingSet = (IWorkingSet)iterator.next();
                List list = (List)map.get(iWorkingSet);
                ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>(Arrays.asList(iWorkingSet.getElements()));
                arrayList.removeAll(list);
                iWorkingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
            }
        }
    }

    private Map groupByWorkingSets(TreePath[] treePathArray) {
        HashMap<IWorkingSet, ArrayList<Object>> hashMap = new HashMap<IWorkingSet, ArrayList<Object>>();
        int n = 0;
        while (n < treePathArray.length) {
            TreePath treePath = treePathArray[n];
            IWorkingSet iWorkingSet = (IWorkingSet)treePath.getSegment(0);
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(iWorkingSet);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(iWorkingSet, arrayList);
            }
            arrayList.add(treePath.getSegment(1));
            ++n;
        }
        return hashMap;
    }

    public int internalTestValidateTarget(Object object, int n) {
        return this.validateTarget(object, n);
    }

    public void internalTestDrop(Object object, int n) {
        if (this.isWorkingSetSelection()) {
            this.performWorkingSetReordering();
        } else {
            this.performElementRearrange(n);
        }
    }
}

