/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.util.TableLayoutComposite;

class JavaEditorHoverConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String DELIMITER = PreferencesMessages.JavaEditorHoverConfigurationBlock_delimiter;
    private static final int ENABLED_PROP = 0;
    private static final int MODIFIER_PROP = 1;
    private OverlayPreferenceStore fStore;
    private HoverConfig[] fHoverConfigs;
    private Text fModifierEditor;
    private Table fHoverTable;
    private TableViewer fHoverTableViewer;
    private TableColumn fNameColumn;
    private TableColumn fModifierColumn;
    private Text fDescription;
    private PreferencePage fMainPreferencePage;
    private StatusInfo fStatus;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            JavaEditorHoverConfigurationBlock.this.fStore.setValue((String)JavaEditorHoverConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            JavaEditorHoverConfigurationBlock.this.fStore.setValue((String)JavaEditorHoverConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public JavaEditorHoverConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)preferencePage);
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fMainPreferencePage = preferencePage;
        this.fStore = overlayPreferenceStore;
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_annotation_roll_over"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hoverModifiers"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hoverModifierMasks"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite, 768);
        scrolledPageContent.setExpandHorizontal(true);
        scrolledPageContent.setExpandVertical(true);
        Composite composite2 = new Composite((Composite)scrolledPageContent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.JavaEditorHoverConfigurationBlock_annotationRollover;
        this.addCheckBox(composite2, string, "editor_annotation_roll_over", 0);
        this.addFiller(composite2);
        Label label = new Label(composite2, 0);
        label.setText(PreferencesMessages.JavaEditorHoverConfigurationBlock_hoverPreferences);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        TableLayoutComposite tableLayoutComposite = new TableLayoutComposite(composite2, 0);
        this.addColumnLayoutData(tableLayoutComposite);
        this.fHoverTable = new Table((Composite)tableLayoutComposite, 68388);
        this.fHoverTable.setHeaderVisible(true);
        this.fHoverTable.setLinesVisible(true);
        gridData = new GridData(768);
        gridData.heightHint = SWTUtil.getTableHeightHint(this.fHoverTable, 10);
        gridData.horizontalSpan = 2;
        gridData.widthHint = new PixelConverter((Control)composite).convertWidthInCharsToPixels(30);
        tableLayoutComposite.setLayoutData(gridData);
        this.fHoverTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaEditorHoverConfigurationBlock.this.handleHoverListSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.fHoverTable.setLayout((Layout)tableLayout);
        this.fNameColumn = new TableColumn(this.fHoverTable, 0);
        this.fNameColumn.setText(PreferencesMessages.JavaEditorHoverConfigurationBlock_nameColumnTitle);
        this.fNameColumn.setResizable(true);
        this.fModifierColumn = new TableColumn(this.fHoverTable, 0);
        this.fModifierColumn.setText(PreferencesMessages.JavaEditorHoverConfigurationBlock_modifierColumnTitle);
        this.fModifierColumn.setResizable(true);
        this.fHoverTableViewer = new CheckboxTableViewer(this.fHoverTable);
        this.fHoverTableViewer.setUseHashlookup(true);
        this.fHoverTableViewer.setContentProvider((IContentProvider)new JavaEditorTextHoverDescriptorContentProvider());
        this.fHoverTableViewer.setLabelProvider((IBaseLabelProvider)new JavaEditorTextHoverDescriptorLabelProvider());
        ((CheckboxTableViewer)this.fHoverTableViewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                String string = ((JavaEditorTextHoverDescriptor)checkStateChangedEvent.getElement()).getId();
                if (string == null) {
                    return;
                }
                JavaEditorTextHoverDescriptor[] javaEditorTextHoverDescriptorArray = JavaEditorHoverConfigurationBlock.this.getContributedHovers();
                HoverConfig hoverConfig = null;
                int n = 0;
                int n2 = JavaEditorHoverConfigurationBlock.this.fHoverConfigs.length;
                while (n < n2) {
                    if (string.equals(javaEditorTextHoverDescriptorArray[n].getId())) {
                        hoverConfig = JavaEditorHoverConfigurationBlock.this.fHoverConfigs[n];
                        hoverConfig.fIsEnabled = checkStateChangedEvent.getChecked();
                        JavaEditorHoverConfigurationBlock.this.fModifierEditor.setEnabled(checkStateChangedEvent.getChecked());
                        JavaEditorHoverConfigurationBlock.this.fHoverTableViewer.setSelection((ISelection)new StructuredSelection((Object)javaEditorTextHoverDescriptorArray[n]));
                    }
                    ++n;
                }
                JavaEditorHoverConfigurationBlock.this.handleHoverListSelection();
                JavaEditorHoverConfigurationBlock.this.updateStatus(hoverConfig);
            }
        });
        label = new Label(composite2, 16384);
        label.setText(PreferencesMessages.JavaEditorHoverConfigurationBlock_keyModifier);
        this.fModifierEditor = new Text(composite2, 2048);
        gridData = new GridData(256);
        this.fModifierEditor.setLayoutData((Object)gridData);
        this.fModifierEditor.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent keyEvent) {
                this.isModifierCandidate = keyEvent.keyCode > 0 && keyEvent.character == '\u0000' && keyEvent.stateMask == 0;
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (this.isModifierCandidate && keyEvent.stateMask > 0 && keyEvent.stateMask == keyEvent.stateMask && keyEvent.character == '\u0000') {
                    boolean bl;
                    String string = JavaEditorHoverConfigurationBlock.this.fModifierEditor.getText();
                    Point point = JavaEditorHoverConfigurationBlock.this.fModifierEditor.getSelection();
                    int n = point.x - 1;
                    while (n > -1 && Character.isWhitespace(string.charAt(n))) {
                        --n;
                    }
                    boolean bl2 = n > -1 && !String.valueOf(string.charAt(n)).equals(DELIMITER);
                    n = point.y;
                    while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                        ++n;
                    }
                    boolean bl3 = bl = n < string.length() && !String.valueOf(string.charAt(n)).equals(DELIMITER);
                    String string2 = bl2 && bl ? Messages.format(PreferencesMessages.JavaEditorHoverConfigurationBlock_insertDelimiterAndModifierAndDelimiter, new String[]{Action.findModifierString((int)keyEvent.stateMask)}) : (bl2 ? Messages.format(PreferencesMessages.JavaEditorHoverConfigurationBlock_insertDelimiterAndModifier, new String[]{Action.findModifierString((int)keyEvent.stateMask)}) : (bl ? Messages.format(PreferencesMessages.JavaEditorHoverConfigurationBlock_insertModifierAndDelimiter, new String[]{Action.findModifierString((int)keyEvent.stateMask)}) : Action.findModifierString((int)keyEvent.stateMask)));
                    if (string2 != null) {
                        JavaEditorHoverConfigurationBlock.this.fModifierEditor.insert(string2);
                    }
                }
            }
        });
        this.fModifierEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavaEditorHoverConfigurationBlock.this.handleModifierModified();
            }
        });
        Label label2 = new Label(composite2, 16384);
        label2.setText(PreferencesMessages.JavaEditorHoverConfigurationBlock_description);
        gridData = new GridData(2);
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        this.fDescription = new Text(composite2, 18506);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.fDescription.setLayoutData((Object)gridData);
        this.initialize();
        scrolledPageContent.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledPageContent.setMinSize(point.x, point.y);
        Dialog.applyDialogFont((Control)scrolledPageContent);
        return scrolledPageContent;
    }

    private void addColumnLayoutData(TableLayoutComposite tableLayoutComposite) {
        tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
    }

    private JavaEditorTextHoverDescriptor[] getContributedHovers() {
        return JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
    }

    public void initialize() {
        JavaEditorTextHoverDescriptor[] javaEditorTextHoverDescriptorArray = this.getContributedHovers();
        this.fHoverConfigs = new HoverConfig[javaEditorTextHoverDescriptorArray.length];
        int n = 0;
        while (n < javaEditorTextHoverDescriptorArray.length) {
            this.fHoverConfigs[n] = new HoverConfig(javaEditorTextHoverDescriptorArray[n].getModifierString(), javaEditorTextHoverDescriptorArray[n].getStateMask(), javaEditorTextHoverDescriptorArray[n].isEnabled());
            ++n;
        }
        this.fHoverTableViewer.setInput((Object)javaEditorTextHoverDescriptorArray);
        this.initializeFields();
    }

    void initializeFields() {
        this.fModifierEditor.setEnabled(false);
        Iterator iterator = this.fCheckBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            Button button = (Button)iterator.next();
            String string = (String)this.fCheckBoxes.get(button);
            button.setSelection(this.fStore.getBoolean(string));
        }
        int n = 0;
        while (n < this.fHoverConfigs.length) {
            this.fHoverTable.getItem(n).setChecked(this.fHoverConfigs[n].fIsEnabled);
            ++n;
        }
        this.fHoverTableViewer.refresh();
    }

    public void performOk() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < this.fHoverConfigs.length) {
            String string;
            stringBuffer.append(this.getContributedHovers()[n].getId());
            stringBuffer.append(";");
            if (!this.fHoverConfigs[n].fIsEnabled) {
                stringBuffer.append("!");
            }
            if ((string = this.fHoverConfigs[n].fModifierString) == null || string.length() == 0) {
                string = "0";
            }
            stringBuffer.append(string);
            stringBuffer.append(";");
            stringBuffer2.append(this.getContributedHovers()[n].getId());
            stringBuffer2.append(";");
            stringBuffer2.append(this.fHoverConfigs[n].fStateMask);
            stringBuffer2.append(";");
            ++n;
        }
        this.fStore.setValue("hoverModifiers", stringBuffer.toString());
        this.fStore.setValue("hoverModifierMasks", stringBuffer2.toString());
        JavaPlugin.getDefault().resetJavaEditorTextHoverDescriptors();
    }

    public void performDefaults() {
        this.restoreFromPreferences();
        this.initializeFields();
        this.updateStatus(null);
    }

    private void restoreFromPreferences() {
        String string;
        String string2 = this.fStore.getString("hoverModifiers");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        HashMap<String, String> hashMap = new HashMap<String, String>(stringTokenizer.countTokens() / 2);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            hashMap.put(string, stringTokenizer.nextToken());
        }
        string = JavaPlugin.getDefault().getPreferenceStore().getString("hoverModifierMasks");
        stringTokenizer = new StringTokenizer(string, ";");
        HashMap<String, String> hashMap2 = new HashMap<String, String>(stringTokenizer.countTokens() / 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            hashMap2.put(string3, stringTokenizer.nextToken());
        }
        int n = 0;
        while (n < this.fHoverConfigs.length) {
            String string4 = (String)hashMap.get(this.getContributedHovers()[n].getId());
            boolean bl = true;
            if (string4 == null) {
                string4 = "!";
            }
            if (string4.startsWith("!")) {
                bl = false;
                string4 = string4.substring(1);
            }
            if (string4.equals("0")) {
                string4 = "";
            }
            this.fHoverConfigs[n].fModifierString = string4;
            this.fHoverConfigs[n].fIsEnabled = bl;
            this.fHoverConfigs[n].fStateMask = JavaEditorTextHoverDescriptor.computeStateMask(string4);
            if (this.fHoverConfigs[n].fStateMask == -1) {
                try {
                    this.fHoverConfigs[n].fStateMask = Integer.parseInt((String)hashMap2.get(this.getContributedHovers()[n].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fHoverConfigs[n].fStateMask = -1;
                }
            }
            ++n;
        }
    }

    private void handleModifierModified() {
        int n = this.fHoverTable.getSelectionIndex();
        if (n == -1) {
            return;
        }
        String string = this.fModifierEditor.getText();
        this.fHoverConfigs[n].fModifierString = string;
        this.fHoverConfigs[n].fStateMask = JavaEditorTextHoverDescriptor.computeStateMask(string);
        this.fHoverTableViewer.refresh((Object)this.getContributedHovers()[n]);
        this.updateStatus(this.fHoverConfigs[n]);
    }

    private void handleHoverListSelection() {
        int n = this.fHoverTable.getSelectionIndex();
        if (n == -1) {
            if (this.fHoverTable.getSelectionCount() == 0) {
                this.fModifierEditor.setEnabled(false);
            }
            return;
        }
        boolean bl = this.fHoverConfigs[n].fIsEnabled;
        this.fModifierEditor.setEnabled(bl);
        this.fModifierEditor.setText(this.fHoverConfigs[n].fModifierString);
        String string = this.getContributedHovers()[n].getDescription();
        if (string == null) {
            string = "";
        }
        this.fDescription.setText(string);
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    private void updateStatus(HoverConfig hoverConfig) {
        this.fStatus = hoverConfig != null && hoverConfig.fIsEnabled && hoverConfig.fStateMask == -1 ? new StatusInfo(4, Messages.format(PreferencesMessages.JavaEditorHoverConfigurationBlock_modifierIsNotValid, hoverConfig.fModifierString)) : new StatusInfo();
        int n = 0;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(this.fHoverConfigs.length);
        while (this.fStatus.isOK() && n < this.fHoverConfigs.length) {
            if (this.fHoverConfigs[n].fIsEnabled) {
                String string = this.getContributedHovers()[n].getLabel();
                Integer n2 = new Integer(this.fHoverConfigs[n].fStateMask);
                if (this.fHoverConfigs[n].fStateMask == -1) {
                    this.fStatus = new StatusInfo(4, Messages.format(PreferencesMessages.JavaEditorHoverConfigurationBlock_modifierIsNotValidForHover, new String[]{this.fHoverConfigs[n].fModifierString, string}));
                } else if (hashMap.containsKey(n2)) {
                    this.fStatus = new StatusInfo(4, Messages.format(PreferencesMessages.JavaEditorHoverConfigurationBlock_duplicateModifier, new String[]{string, (String)hashMap.get(n2)}));
                } else {
                    hashMap.put(n2, string);
                }
            }
            ++n;
        }
        this.fMainPreferencePage.setValid(this.fStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, this.fStatus);
    }

    private Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(button, string2);
        return button;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    public void dispose() {
    }

    private static class HoverConfig {
        private String fModifierString;
        private boolean fIsEnabled;
        private int fStateMask;

        private HoverConfig(String string, int n, boolean bl) {
            this.fModifierString = string;
            this.fIsEnabled = bl;
            this.fStateMask = n;
        }
    }

    private class JavaEditorTextHoverDescriptorContentProvider
    implements IStructuredContentProvider {
        private JavaEditorTextHoverDescriptorContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public Object[] getElements(Object object) {
            return (Object[])object;
        }
    }

    private class JavaEditorTextHoverDescriptorLabelProvider
    implements ITableLabelProvider {
        private JavaEditorTextHoverDescriptorLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((JavaEditorTextHoverDescriptor)object).getLabel();
                }
                case 1: {
                    TableItem tableItem = (TableItem)JavaEditorHoverConfigurationBlock.this.fHoverTableViewer.testFindItem(object);
                    int n2 = JavaEditorHoverConfigurationBlock.this.fHoverTable.indexOf(tableItem);
                    return JavaEditorHoverConfigurationBlock.this.fHoverConfigs[n2].fModifierString;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

