/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.core.Flags;

public class MembersOrderPreferenceCache
implements IPropertyChangeListener {
    public static final int TYPE_INDEX = 0;
    public static final int CONSTRUCTORS_INDEX = 1;
    public static final int METHOD_INDEX = 2;
    public static final int FIELDS_INDEX = 3;
    public static final int INIT_INDEX = 4;
    public static final int STATIC_FIELDS_INDEX = 5;
    public static final int STATIC_INIT_INDEX = 6;
    public static final int STATIC_METHODS_INDEX = 7;
    public static final int ENUM_CONSTANTS_INDEX = 8;
    public static final int N_CATEGORIES = 9;
    private static final int PUBLIC_INDEX = 0;
    private static final int PRIVATE_INDEX = 1;
    private static final int PROTECTED_INDEX = 2;
    private static final int DEFAULT_INDEX = 3;
    private static final int N_VISIBILITIES = 4;
    private int[] fCategoryOffsets = null;
    private boolean fSortByVisibility = false;
    private int[] fVisibilityOffsets = null;
    private IPreferenceStore fPreferenceStore = null;

    public void install(IPreferenceStore iPreferenceStore) {
        this.fPreferenceStore = iPreferenceStore;
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fSortByVisibility = iPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.enable.visibility.order");
    }

    public void dispose() {
        this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fPreferenceStore = null;
    }

    public static boolean isMemberOrderProperty(String string) {
        return "outlinesortoption".equals(string) || "org.eclipse.wst.jsdt.ui.visibility.order".equals(string) || "org.eclipse.wst.jsdt.ui.enable.visibility.order".equals(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("outlinesortoption".equals(string)) {
            this.fCategoryOffsets = null;
        } else if ("org.eclipse.wst.jsdt.ui.visibility.order".equals(string)) {
            this.fVisibilityOffsets = null;
        } else if ("org.eclipse.wst.jsdt.ui.enable.visibility.order".equals(string)) {
            this.fSortByVisibility = this.fPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.enable.visibility.order");
        }
    }

    public int getCategoryIndex(int n) {
        if (this.fCategoryOffsets == null) {
            this.fCategoryOffsets = this.getCategoryOffsets();
        }
        return this.fCategoryOffsets[n];
    }

    private int[] getCategoryOffsets() {
        int[] nArray = new int[9];
        IPreferenceStore iPreferenceStore = this.fPreferenceStore;
        String string = "outlinesortoption";
        boolean bl = this.fillCategoryOffsetsFromPreferenceString(iPreferenceStore.getString(string), nArray);
        if (!bl) {
            iPreferenceStore.setToDefault(string);
            this.fillCategoryOffsetsFromPreferenceString(iPreferenceStore.getDefaultString(string), nArray);
        }
        return nArray;
    }

    private boolean fillCategoryOffsetsFromPreferenceString(String string, int[] nArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        nArray[8] = n++;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if ("T".equals(string2)) {
                nArray[0] = n++;
                continue;
            }
            if ("M".equals(string2)) {
                nArray[2] = n++;
                continue;
            }
            if ("F".equals(string2)) {
                nArray[3] = n++;
                continue;
            }
            if ("I".equals(string2)) {
                nArray[4] = n++;
                continue;
            }
            if ("SF".equals(string2)) {
                nArray[5] = n++;
                continue;
            }
            if ("SI".equals(string2)) {
                nArray[6] = n++;
                continue;
            }
            if ("SM".equals(string2)) {
                nArray[7] = n++;
                continue;
            }
            if (!"C".equals(string2)) continue;
            nArray[1] = n++;
        }
        return n == 9;
    }

    public boolean isSortByVisibility() {
        return this.fSortByVisibility;
    }

    public int getVisibilityIndex(int n) {
        if (this.fVisibilityOffsets == null) {
            this.fVisibilityOffsets = this.getVisibilityOffsets();
        }
        int n2 = 3;
        if (Flags.isPublic((int)n)) {
            n2 = 0;
        } else if (Flags.isProtected((int)n)) {
            n2 = 2;
        } else if (Flags.isPrivate((int)n)) {
            n2 = 1;
        }
        return this.fVisibilityOffsets[n2];
    }

    private int[] getVisibilityOffsets() {
        int[] nArray = new int[4];
        IPreferenceStore iPreferenceStore = this.fPreferenceStore;
        String string = "org.eclipse.wst.jsdt.ui.visibility.order";
        boolean bl = this.fillVisibilityOffsetsFromPreferenceString(iPreferenceStore.getString(string), nArray);
        if (!bl) {
            iPreferenceStore.setToDefault(string);
            this.fillVisibilityOffsetsFromPreferenceString(iPreferenceStore.getDefaultString(string), nArray);
        }
        return nArray;
    }

    private boolean fillVisibilityOffsetsFromPreferenceString(String string, int[] nArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if ("B".equals(string2)) {
                nArray[0] = n++;
                continue;
            }
            if ("V".equals(string2)) {
                nArray[1] = n++;
                continue;
            }
            if ("R".equals(string2)) {
                nArray[2] = n++;
                continue;
            }
            if (!"D".equals(string2)) continue;
            nArray[3] = n++;
        }
        return n == 4;
    }
}

