/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;

public class NewJavaProjectPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.wst.jsdt.ui.preferences.BuildPathPreferencePage";
    private static final String SRCBIN_FOLDERS_IN_NEWPROJ = "org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersInNewProjects";
    private static final String SRCBIN_SRCNAME = "org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersSrcName";
    private static final String SRCBIN_BINNAME = "org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName";
    private static final String CLASSPATH_JRELIBRARY_INDEX = "org.eclipse.wst.jsdt.ui.wizards.jre.index";
    private static final String CLASSPATH_JRELIBRARY_LIST = "org.eclipse.wst.jsdt.ui.wizards.jre.list";
    private static String fgDefaultEncoding = System.getProperty("file.encoding");
    private ArrayList fCheckBoxes;
    private ArrayList fRadioButtons;
    private ArrayList fTextControls;
    private SelectionListener fSelectionListener;
    private ModifyListener fModifyListener;
    private Text fSrcFolderNameText;
    private Combo fJRECombo;
    private Button fProjectAsSourceFolder;
    private Button fFoldersAsSourceFolder;
    private Label fSrcFolderNameLabel;

    public static IClasspathEntry[] getDefaultJRELibrary() {
        IClasspathEntry[] iClasspathEntryArray;
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString(CLASSPATH_JRELIBRARY_LIST);
        int n = iPreferenceStore.getInt(CLASSPATH_JRELIBRARY_INDEX);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens() && n > 0) {
            stringTokenizer.nextToken();
            --n;
        }
        if (stringTokenizer.hasMoreTokens() && (iClasspathEntryArray = NewJavaProjectPreferencePage.decodeJRELibraryClasspathEntries(stringTokenizer.nextToken())).length > 0) {
            return iClasspathEntryArray;
        }
        return new IClasspathEntry[]{NewJavaProjectPreferencePage.getJREContainerEntry()};
    }

    public static String decodeJRELibraryDescription(String string) {
        int n = string.indexOf(32);
        if (n != -1) {
            return NewJavaProjectPreferencePage.decode(string.substring(0, n));
        }
        return "";
    }

    private static String decode(String string) {
        try {
            return URLDecoder.decode(string, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JavaPlugin.log(unsupportedEncodingException);
            return "";
        }
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JavaPlugin.log(unsupportedEncodingException);
            return "";
        }
    }

    public static IClasspathEntry[] decodeJRELibraryClasspathEntries(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            try {
                stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                string2 = NewJavaProjectPreferencePage.decodePath(stringTokenizer.nextToken());
                IPath iPath = NewJavaProjectPreferencePage.decodePath(stringTokenizer.nextToken());
                IPath iPath2 = NewJavaProjectPreferencePage.decodePath(stringTokenizer.nextToken());
                boolean bl = Boolean.valueOf(stringTokenizer.nextToken());
                switch (n) {
                    case 3: {
                        arrayList.add(JavaCore.newSourceEntry((IPath)string2));
                        break;
                    }
                    case 1: {
                        arrayList.add(JavaCore.newLibraryEntry((IPath)string2, (IPath)iPath, (IPath)iPath2, (boolean)bl));
                        break;
                    }
                    case 4: {
                        arrayList.add(JavaCore.newVariableEntry((IPath)string2, (IPath)iPath, (IPath)iPath2, (boolean)bl));
                        break;
                    }
                    case 2: {
                        arrayList.add(JavaCore.newProjectEntry((IPath)string2, (boolean)bl));
                        break;
                    }
                    case 5: {
                        arrayList.add(JavaCore.newContainerEntry((IPath)string2, (boolean)bl));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                string2 = PreferencesMessages.NewJavaProjectPreferencePage_error_decode;
                JavaPlugin.log((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, string2, (Throwable)numberFormatException));
            }
            catch (NoSuchElementException noSuchElementException) {
                string2 = PreferencesMessages.NewJavaProjectPreferencePage_error_decode;
                JavaPlugin.log((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, string2, (Throwable)noSuchElementException));
            }
        }
        return arrayList.toArray(new IClasspathEntry[arrayList.size()]);
    }

    public static String encodeJRELibrary(String string, IClasspathEntry[] iClasspathEntryArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            stringBuffer.append(NewJavaProjectPreferencePage.encode(string));
            stringBuffer.append(' ');
            stringBuffer.append(iClasspathEntry.getEntryKind());
            stringBuffer.append(' ');
            stringBuffer.append(NewJavaProjectPreferencePage.encodePath(iClasspathEntry.getPath()));
            stringBuffer.append(' ');
            stringBuffer.append(NewJavaProjectPreferencePage.encodePath(iClasspathEntry.getSourceAttachmentPath()));
            stringBuffer.append(' ');
            stringBuffer.append(NewJavaProjectPreferencePage.encodePath(iClasspathEntry.getSourceAttachmentRootPath()));
            stringBuffer.append(' ');
            stringBuffer.append(iClasspathEntry.isExported());
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String encodePath(IPath iPath) {
        if (iPath == null) {
            return "#";
        }
        if (iPath.isEmpty()) {
            return "&";
        }
        return NewJavaProjectPreferencePage.encode(iPath.toPortableString());
    }

    private static IPath decodePath(String string) {
        if ("#".equals(string)) {
            return null;
        }
        if ("&".equals(string)) {
            return Path.EMPTY;
        }
        return Path.fromPortableString((String)NewJavaProjectPreferencePage.decode(string));
    }

    public NewJavaProjectPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.NewJavaProjectPreferencePage_description);
        this.setTitle(PreferencesMessages.NewJavaProjectPreferencePage_title);
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
        this.fSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewJavaProjectPreferencePage.this.controlChanged(selectionEvent.widget);
            }
        };
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewJavaProjectPreferencePage.this.controlModified(modifyEvent.widget);
            }
        };
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(SRCBIN_FOLDERS_IN_NEWPROJ, false);
        iPreferenceStore.setDefault(SRCBIN_SRCNAME, "script");
        iPreferenceStore.setDefault(SRCBIN_BINNAME, "");
        iPreferenceStore.setDefault(CLASSPATH_JRELIBRARY_LIST, NewJavaProjectPreferencePage.getDefaultJRELibraries());
        iPreferenceStore.setDefault(CLASSPATH_JRELIBRARY_INDEX, 0);
    }

    private static String getDefaultJRELibraries() {
        StringBuffer stringBuffer = new StringBuffer();
        IClasspathEntry iClasspathEntry = NewJavaProjectPreferencePage.getJREContainerEntry();
        stringBuffer.append(NewJavaProjectPreferencePage.encodeJRELibrary(PreferencesMessages.NewJavaProjectPreferencePage_jre_container_description, new IClasspathEntry[]{iClasspathEntry}));
        stringBuffer.append(';');
        IClasspathEntry iClasspathEntry2 = NewJavaProjectPreferencePage.getJREVariableEntry();
        stringBuffer.append(NewJavaProjectPreferencePage.encodeJRELibrary(PreferencesMessages.NewJavaProjectPreferencePage_jre_variable_description, new IClasspathEntry[]{iClasspathEntry2}));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    private static IClasspathEntry getJREContainerEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER"));
    }

    private static IClasspathEntry getJREVariableEntry() {
        return JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.new_java_project_preference_page_context");
    }

    private Button addRadioButton(Composite composite, String string, String string2, String string3, int n) {
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = n;
        Button button = new Button(composite, 16);
        button.setText(string);
        button.setData((Object)new String[]{string2, string3});
        button.setLayoutData((Object)gridData);
        button.setSelection(string3.equals(this.getPreferenceStore().getString(string2)));
        this.fRadioButtons.add(button);
        return button;
    }

    private Text addTextControl(Composite composite, Label label, String string, int n) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = n;
        label.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(composite, 2052);
        text.setText(this.getPreferenceStore().getString(string));
        text.setData((Object)string);
        text.setLayoutData((Object)gridData);
        this.fTextControls.add(text);
        return text;
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setText(PreferencesMessages.NewJavaProjectPreferencePage_sourcefolder_label);
        int n = 0;
        this.fProjectAsSourceFolder = this.addRadioButton((Composite)group, PreferencesMessages.NewJavaProjectPreferencePage_sourcefolder_project, SRCBIN_FOLDERS_IN_NEWPROJ, "false", n);
        this.fProjectAsSourceFolder.addSelectionListener(this.fSelectionListener);
        this.fFoldersAsSourceFolder = this.addRadioButton((Composite)group, PreferencesMessages.NewJavaProjectPreferencePage_sourcefolder_folder, SRCBIN_FOLDERS_IN_NEWPROJ, "true", n);
        this.fFoldersAsSourceFolder.addSelectionListener(this.fSelectionListener);
        n = this.convertWidthInCharsToPixels(4);
        this.fSrcFolderNameLabel = new Label((Composite)group, 0);
        this.fSrcFolderNameLabel.setText(PreferencesMessages.NewJavaProjectPreferencePage_folders_src);
        this.fSrcFolderNameText = this.addTextControl((Composite)group, this.fSrcFolderNameLabel, SRCBIN_SRCNAME, n);
        this.fSrcFolderNameText.addModifyListener(this.fModifyListener);
        this.validateFolders();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void validateFolders() {
        boolean bl = this.fFoldersAsSourceFolder.getSelection();
        this.fSrcFolderNameText.setEnabled(bl);
        this.fSrcFolderNameLabel.setEnabled(bl);
        if (bl) {
            IStatus iStatus;
            String string = this.fSrcFolderNameText.getText();
            String string2 = "";
            if (string.length() + string2.length() == 0) {
                this.updateStatus(new StatusInfo(4, PreferencesMessages.NewJavaProjectPreferencePage_folders_error_namesempty));
                return;
            }
            IWorkspace iWorkspace = JavaPlugin.getWorkspace();
            IProject iProject = iWorkspace.getRoot().getProject("project");
            IPath iPath = iProject.getFullPath().append(string);
            if (string.length() != 0 && !(iStatus = iWorkspace.validatePath(iPath.toString(), 2)).isOK()) {
                String string3 = Messages.format(PreferencesMessages.NewJavaProjectPreferencePage_folders_error_invalidsrcname, iStatus.getMessage());
                this.updateStatus(new StatusInfo(4, string3));
                return;
            }
            IPath iPath2 = iProject.getFullPath().append(string2);
            if (string2.length() != 0 && !(iStatus = iWorkspace.validatePath(iPath2.toString(), 2)).isOK()) {
                String string4 = Messages.format(PreferencesMessages.NewJavaProjectPreferencePage_folders_error_invalidbinname, iStatus.getMessage());
                this.updateStatus(new StatusInfo(4, string4));
                return;
            }
            IClasspathEntry iClasspathEntry = JavaCore.newSourceEntry((IPath)iPath);
            iStatus = JavaConventions.validateClasspath((IJavaProject)JavaCore.create((IProject)iProject), (IClasspathEntry[])new IClasspathEntry[]{iClasspathEntry}, (IPath)iPath2);
            if (!iStatus.isOK()) {
                String string5 = PreferencesMessages.NewJavaProjectPreferencePage_folders_error_invalidcp;
                this.updateStatus(new StatusInfo(4, string5));
                return;
            }
        }
        this.updateStatus(new StatusInfo());
    }

    private void updateStatus(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    private void controlChanged(Widget widget) {
        if (widget == this.fFoldersAsSourceFolder || widget == this.fProjectAsSourceFolder) {
            this.validateFolders();
        }
    }

    private void controlModified(Widget widget) {
        if (widget == this.fSrcFolderNameText) {
            this.validateFolders();
        }
    }

    protected void performDefaults() {
        Object object;
        Button button;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = 0;
        while (n < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(n);
            object = (String[])button.getData();
            button.setSelection(iPreferenceStore.getDefaultBoolean((String)object));
            ++n;
        }
        n = 0;
        while (n < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(n);
            object = (String[])button.getData();
            button.setSelection(object[1].equals(iPreferenceStore.getDefaultString(object[0])));
            ++n;
        }
        n = 0;
        while (n < this.fTextControls.size()) {
            button = (Text)this.fTextControls.get(n);
            object = (String)button.getData();
            button.setText(iPreferenceStore.getDefaultString((String)object));
            ++n;
        }
        if (this.fJRECombo != null) {
            this.fJRECombo.select(iPreferenceStore.getDefaultInt(CLASSPATH_JRELIBRARY_INDEX));
        }
        this.validateFolders();
        super.performDefaults();
    }

    public boolean performOk() {
        Object object;
        Button button;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = 0;
        while (n < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(n);
            object = (String[])button.getData();
            iPreferenceStore.setValue((String)object, button.getSelection());
            ++n;
        }
        n = 0;
        while (n < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(n);
            if (button.getSelection()) {
                object = (String[])button.getData();
                iPreferenceStore.setValue(object[0], object[1]);
            }
            ++n;
        }
        n = 0;
        while (n < this.fTextControls.size()) {
            button = (Text)this.fTextControls.get(n);
            object = (String)button.getData();
            iPreferenceStore.setValue((String)object, button.getText());
            ++n;
        }
        if (this.fJRECombo != null) {
            iPreferenceStore.setValue(CLASSPATH_JRELIBRARY_INDEX, this.fJRECombo.getSelectionIndex());
        }
        JavaPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    private String[] getJRENames() {
        String string = this.getPreferenceStore().getString(CLASSPATH_JRELIBRARY_LIST);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(NewJavaProjectPreferencePage.decodeJRELibraryDescription(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

