/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;

public class SourceAttachmentPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private SourceAttachmentBlock fSourceAttachmentBlock;
    private IPackageFragmentRoot fRoot;
    private IPath fContainerPath;
    private IClasspathEntry fEntry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.source_attachment_property_page_context");
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Control control = this.createPageContent(composite);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private Control createPageContent(Composite composite) {
        try {
            this.fContainerPath = null;
            this.fEntry = null;
            this.fRoot = this.getJARPackageFragmentRoot();
            if (this.fRoot == null || this.fRoot.getKind() != 2) {
                return this.createMessageContent(composite, PreferencesMessages.SourceAttachmentPropertyPage_noarchive_message);
            }
            IPath iPath = null;
            IJavaProject iJavaProject = this.fRoot.getJavaProject();
            IClasspathEntry iClasspathEntry = this.fRoot.getRawClasspathEntry();
            if (iClasspathEntry == null) {
                iClasspathEntry = JavaCore.newLibraryEntry((IPath)this.fRoot.getPath(), null, null);
            } else if (iClasspathEntry.getEntryKind() == 5) {
                iPath = iClasspathEntry.getPath();
                ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)iPath.segment(0));
                IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
                if (classpathContainerInitializer == null || iClasspathContainer == null) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_invalid_container, iPath.toString()));
                }
                String string = iClasspathContainer.getDescription();
                IStatus iStatus = classpathContainerInitializer.getSourceAttachmentStatus(iPath, iJavaProject);
                if (iStatus.getCode() == 1) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_not_supported, string));
                }
                if (iStatus.getCode() == 2) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_read_only, string));
                }
                iClasspathEntry = JavaModelUtil.findEntryInContainer(iClasspathContainer, this.fRoot.getPath());
                Assert.isNotNull((Object)iClasspathEntry);
            }
            this.fContainerPath = iPath;
            this.fEntry = iClasspathEntry;
            this.fSourceAttachmentBlock = new SourceAttachmentBlock(this, iClasspathEntry);
            return this.fSourceAttachmentBlock.createControl(composite);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return this.createMessageContent(composite, PreferencesMessages.SourceAttachmentPropertyPage_noarchive_message);
        }
    }

    private Control createMessageContent(Composite composite, String string) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        Label label = new Label(composite2, 16448);
        label.setText(string);
        label.setLayoutData((Object)gridData);
        return composite2;
    }

    public boolean performOk() {
        if (this.fSourceAttachmentBlock != null) {
            IClasspathEntry iClasspathEntry;
            block5: {
                iClasspathEntry = this.fSourceAttachmentBlock.getNewEntry();
                if (!iClasspathEntry.equals(this.fEntry)) break block5;
                return true;
            }
            try {
                IRunnableWithProgress iRunnableWithProgress = SourceAttachmentBlock.getRunnable(this.getShell(), iClasspathEntry, this.fRoot.getJavaProject(), this.fContainerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = PreferencesMessages.SourceAttachmentPropertyPage_error_title;
                String string2 = PreferencesMessages.SourceAttachmentPropertyPage_error_message;
                ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    protected void performDefaults() {
        if (this.fSourceAttachmentBlock != null) {
            this.fSourceAttachmentBlock.setDefaults();
        }
        super.performDefaults();
    }

    private IPackageFragmentRoot getJARPackageFragmentRoot() throws CoreException {
        IProject iProject;
        IResource iResource;
        IJavaElement iJavaElement;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)iJavaElement;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz2)) instanceof IFile && (iProject = iResource.getProject()).hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            return iJavaProject.getPackageFragmentRoot(iResource);
        }
        return null;
    }

    public void statusChanged(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }
}

