/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public class IndentationTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "function foo(data) {\n" + "\n" + "    var abc = 1;\n" + "    var xyz = 'one';\n" + "\n" + "    switch (data) {\n" + "\n" + "        case 0:\n" + "            abc = 0;\n" + "            xyz = 'zero';\n" + "            break;\n" + "\n" + "        default:\n" + "            abc = -1;\n" + "            xyz = 'unknown';\n" + "\n" + "     }\n\n" + "    if ( document.form1.year.value > 2000 ) {\n" + "        abc += 27;\n" + "    }\n" + "    else if ( document.form1.year.value > 1900 ) {\n" + "        abc += 19;\n" + "    }\n" + "    else {\n" + "        abc = 0;\n" + "    }\n" + "\n" + "}";
    private CompilationUnitPreview fPreview;
    private String fOldTabChar = null;

    public IndentationTabPage(ModifyDialog modifyDialog, Map map) {
        super(modifyDialog, map);
    }

    protected void doCreatePreferences(Composite composite, int n) {
        Group group = this.createGroup(n, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] stringArray = new String[]{"space", "tab", "mixed"};
        String[] stringArray2 = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference comboPreference = this.createComboPref((Composite)group, n, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "org.eclipse.wst.jsdt.core.formatter.tabulation.char", stringArray, stringArray2);
        final ModifyDialogTabPage.CheckboxPreference checkboxPreference = this.createCheckboxPref((Composite)group, n, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference numberPreference = this.createNumberPref((Composite)group, n, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "org.eclipse.wst.jsdt.core.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference numberPreference2 = this.createNumberPref((Composite)group, n, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "org.eclipse.wst.jsdt.core.formatter.tabulation.size", 0, 32);
        String string = (String)this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char");
        this.updateTabPreferences(string, numberPreference2, numberPreference, checkboxPreference);
        comboPreference.addObserver(new Observer(){

            public void update(Observable observable, Object object) {
                IndentationTabPage.this.updateTabPreferences((String)object, numberPreference2, numberPreference, checkboxPreference);
            }
        });
        numberPreference2.addObserver(new Observer(){

            public void update(Observable observable, Object object) {
                numberPreference.updateWidget();
            }
        });
        Group group2 = this.createGroup(n, composite, FormatterMessages.IndentationTabPage_field_alignment_group_title);
        this.createCheckboxPref((Composite)group2, n, FormatterMessages.IndentationTabPage_field_alignment_group_align_fields_in_columns, "org.eclipse.wst.jsdt.core.formatter.align_type_members_on_columns", FALSE_TRUE);
        Group group3 = this.createGroup(n, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)group3, n, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_body, "org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_body", FALSE_TRUE);
        this.createCheckboxPref((Composite)group3, n, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_block, "org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_block", FALSE_TRUE);
        this.createCheckboxPref((Composite)group3, n, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_switch_body, "org.eclipse.wst.jsdt.core.formatter.indent_switchstatements_compare_to_switch", FALSE_TRUE);
        this.createCheckboxPref((Composite)group3, n, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body, "org.eclipse.wst.jsdt.core.formatter.indent_switchstatements_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)group3, n, FormatterMessages.IndentationTabPage_switch_group_option_indent_break_statements, "org.eclipse.wst.jsdt.core.formatter.indent_breaks_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)group3, n, FormatterMessages.IndentationTabPage_indent_empty_lines, "org.eclipse.wst.jsdt.core.formatter.indent_empty_lines", FALSE_TRUE);
    }

    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected JavaPreview doCreateJavaPreview(Composite composite) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, composite);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    private void updateTabPreferences(String string, ModifyDialogTabPage.NumberPreference numberPreference, ModifyDialogTabPage.NumberPreference numberPreference2, ModifyDialogTabPage.CheckboxPreference checkboxPreference) {
        if ("mixed".equals(string)) {
            if ("space".equals(this.fOldTabChar) || "tab".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            numberPreference.setEnabled(true);
            numberPreference.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            numberPreference2.setEnabled(true);
            numberPreference2.setKey("org.eclipse.wst.jsdt.core.formatter.indentation.size");
            checkboxPreference.setEnabled(true);
        } else if ("space".equals(string)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            numberPreference.setEnabled(true);
            numberPreference.setKey("org.eclipse.wst.jsdt.core.formatter.indentation.size");
            numberPreference2.setEnabled(true);
            numberPreference2.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            checkboxPreference.setEnabled(false);
        } else if ("tab".equals(string)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            numberPreference.setEnabled(true);
            numberPreference.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            numberPreference2.setEnabled(false);
            numberPreference2.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            checkboxPreference.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = string;
    }

    private void swapTabValues() {
        Object v = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
        Object v2 = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.indentation.size");
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", v2);
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.indentation.size", v);
    }
}

