/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ProfileManager
extends Observable {
    public static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private final String fProfileKey;
    private final String fProfileVersionKey;
    private static final String SHARED_PROFILE = "org.eclipse.wst.jsdt.ui.default.shared";
    private final Map fProfiles;
    private final List fProfilesByName;
    private Profile fSelected;
    private final KeySet[] fKeySets;
    private final PreferencesAccess fPreferencesAccess;
    private final IProfileVersioner fProfileVersioner;

    public ProfileManager(List list, IScopeContext iScopeContext, PreferencesAccess preferencesAccess, IProfileVersioner iProfileVersioner, KeySet[] keySetArray, String string, String string2) {
        block6: {
            Profile profile;
            Object object;
            String string3;
            Object object2;
            Map map;
            block8: {
                ArrayList arrayList;
                block7: {
                    Profile profile2;
                    this.fPreferencesAccess = preferencesAccess;
                    this.fProfileVersioner = iProfileVersioner;
                    this.fKeySets = keySetArray;
                    this.fProfileKey = string;
                    this.fProfileVersionKey = string2;
                    this.fProfiles = new HashMap();
                    this.fProfilesByName = new ArrayList();
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        profile2 = (Profile)object3.next();
                        if (profile2 instanceof CustomProfile) {
                            ((CustomProfile)profile2).setManager(this);
                        }
                        this.fProfiles.put(profile2.getID(), profile2);
                        this.fProfilesByName.add(profile2);
                    }
                    Collections.sort(this.fProfilesByName);
                    object3 = this.getSelectedProfileId(this.fPreferencesAccess.getInstanceScope());
                    profile2 = (Profile)this.fProfiles.get(object3);
                    if (profile2 == null) {
                        profile2 = this.getDefaultProfile();
                    }
                    this.fSelected = profile2;
                    if (iScopeContext.getName() != "project" || !this.hasProjectSpecificSettings(iScopeContext) || (map = this.readFromPreferenceStore(iScopeContext, profile2)) == null) break block6;
                    arrayList = new ArrayList();
                    int n = 0;
                    while (n < this.fKeySets.length) {
                        arrayList.addAll(this.fKeySets[n].getKeys());
                        ++n;
                    }
                    Collections.sort(arrayList);
                    object2 = null;
                    string3 = iScopeContext.getNode("org.eclipse.wst.jsdt.ui").get(this.fProfileKey, null);
                    if (string3 == null) break block7;
                    object = (Profile)this.fProfiles.get(string3);
                    if (object == null || !((Profile)object).isBuiltInProfile() && !((Profile)object).hasEqualSettings(map, arrayList)) break block8;
                    object2 = object;
                    break block8;
                }
                object = this.fProfilesByName.iterator();
                while (object.hasNext()) {
                    profile = (Profile)object.next();
                    if (!profile.hasEqualSettings(map, arrayList)) continue;
                    object2 = profile;
                    break;
                }
            }
            if (object2 == null) {
                object = string3 != null && !this.fProfiles.containsKey(string3) ? Messages.format(FormatterMessages.ProfileManager_unmanaged_profile_with_name, string3.substring(ID_PREFIX.length())) : FormatterMessages.ProfileManager_unmanaged_profile;
                profile = new SharedProfile((String)object, map, this.fProfileVersioner.getCurrentVersion(), this.fProfileVersioner.getProfileKind());
                ((CustomProfile)profile).setManager(this);
                this.fProfiles.put(((SharedProfile)profile).getID(), profile);
                this.fProfilesByName.add(profile);
                object2 = profile;
            }
            this.fSelected = object2;
        }
    }

    protected String getSelectedProfileId(IScopeContext iScopeContext) {
        String string = iScopeContext.getNode("org.eclipse.wst.jsdt.ui").get(this.fProfileKey, null);
        if (string == null) {
            string = new DefaultScope().getNode("org.eclipse.wst.jsdt.ui").get(this.fProfileKey, null);
        }
        return string;
    }

    protected void notifyObservers(int n) {
        this.setChanged();
        this.notifyObservers(new Integer(n));
    }

    public static boolean hasProjectSpecificSettings(IScopeContext iScopeContext, KeySet[] keySetArray) {
        int n = 0;
        while (n < keySetArray.length) {
            KeySet keySet = keySetArray[n];
            IEclipsePreferences iEclipsePreferences = iScopeContext.getNode(keySet.getNodeName());
            Iterator iterator = keySet.getKeys().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = iEclipsePreferences.get(string, null);
                if (string2 == null) continue;
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasProjectSpecificSettings(IScopeContext iScopeContext) {
        return ProfileManager.hasProjectSpecificSettings(iScopeContext, this.fKeySets);
    }

    private Map readFromPreferenceStore(IScopeContext iScopeContext, Profile profile) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.eclipse.wst.jsdt.ui");
        int n = iEclipsePreferences.getInt(this.fProfileVersionKey, this.fProfileVersioner.getFirstVersion());
        if (n != this.fProfileVersioner.getCurrentVersion()) {
            HashMap hashMap2 = new HashMap();
            int n2 = 0;
            while (n2 < this.fKeySets.length) {
                this.addAll(iScopeContext.getNode(this.fKeySets[n2].getNodeName()), hashMap2);
                ++n2;
            }
            CustomProfile customProfile = new CustomProfile("tmp", hashMap2, n, this.fProfileVersioner.getProfileKind());
            this.fProfileVersioner.update(customProfile);
            return customProfile.getSettings();
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.fKeySets.length) {
            KeySet keySet = this.fKeySets[n3];
            IEclipsePreferences iEclipsePreferences2 = iScopeContext.getNode(keySet.getNodeName());
            Iterator iterator = keySet.getKeys().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = iEclipsePreferences2.get(string, null);
                if (string2 != null) {
                    bl = true;
                } else {
                    string2 = profile.getSettings().get(string);
                }
                hashMap.put(string, string2);
            }
            ++n3;
        }
        if (!bl) {
            return null;
        }
        ProfileManager.setLatestCompliance(hashMap);
        return hashMap;
    }

    private void addAll(IEclipsePreferences iEclipsePreferences, Map map) {
        try {
            String[] stringArray = iEclipsePreferences.keys();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = iEclipsePreferences.get(string, null);
                if (string2 != null) {
                    map.put(string, string2);
                }
                ++n;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean updatePreferences(IEclipsePreferences iEclipsePreferences, List list, Map map) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = iEclipsePreferences.get(string, null);
            String string3 = (String)map.get(string);
            if (string3 == null) {
                if (string2 == null) continue;
                iEclipsePreferences.remove(string);
                bl = true;
                continue;
            }
            if (string3.equals(string2)) continue;
            iEclipsePreferences.put(string, string3);
            bl = true;
        }
        return bl;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext iScopeContext) {
        Map map = profile.getSettings();
        int n = 0;
        while (n < this.fKeySets.length) {
            this.updatePreferences(iScopeContext.getNode(this.fKeySets[n].getNodeName()), this.fKeySets[n].getKeys(), map);
            ++n;
        }
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.eclipse.wst.jsdt.ui");
        if (iEclipsePreferences.getInt(this.fProfileVersionKey, 0) != this.fProfileVersioner.getCurrentVersion()) {
            iEclipsePreferences.putInt(this.fProfileVersionKey, this.fProfileVersioner.getCurrentVersion());
        }
        if (iScopeContext.getName() == "instance") {
            iEclipsePreferences.put(this.fProfileKey, profile.getID());
        } else if (iScopeContext.getName() == "project" && !profile.isSharedProfile()) {
            iEclipsePreferences.put(this.fProfileKey, profile.getID());
        }
    }

    public List getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] stringArray = new String[this.fProfilesByName.size()];
        int n = 0;
        Iterator iterator = this.fProfilesByName.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            stringArray[n++] = profile.getName();
        }
        return stringArray;
    }

    public Profile getProfile(String string) {
        return (Profile)this.fProfiles.get(string);
    }

    public void commitChanges(IScopeContext iScopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, iScopeContext);
        }
    }

    public void clearAllSettings(IScopeContext iScopeContext) {
        int n = 0;
        while (n < this.fKeySets.length) {
            this.updatePreferences(iScopeContext.getNode(this.fKeySets[n].getNodeName()), this.fKeySets[n].getKeys(), Collections.EMPTY_MAP);
            ++n;
        }
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.eclipse.wst.jsdt.ui");
        iEclipsePreferences.remove(this.fProfileKey);
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile profile2 = (Profile)this.fProfiles.get(profile.getID());
        if (profile2 != null && !profile2.equals(this.fSelected)) {
            this.fSelected = profile2;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String string) {
        Iterator iterator = this.fProfilesByName.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!string.equals(profile.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(CustomProfile customProfile) {
        customProfile.setManager(this);
        CustomProfile customProfile2 = (CustomProfile)this.fProfiles.get(customProfile.getID());
        if (customProfile2 != null) {
            this.fProfiles.remove(customProfile2.getID());
            this.fProfilesByName.remove(customProfile2);
            customProfile2.setManager(null);
        }
        this.fProfiles.put(customProfile.getID(), customProfile);
        this.fProfilesByName.add(customProfile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = customProfile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        return this.deleteProfile((CustomProfile)this.fSelected);
    }

    public boolean deleteProfile(CustomProfile customProfile) {
        int n = this.fProfilesByName.indexOf(customProfile);
        this.fProfiles.remove(customProfile.getID());
        this.fProfilesByName.remove(customProfile);
        customProfile.setManager(null);
        if (n >= this.fProfilesByName.size()) {
            --n;
        }
        this.fSelected = (Profile)this.fProfilesByName.get(n);
        if (!customProfile.isSharedProfile()) {
            this.updateProfilesWithName(customProfile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile customProfile, String string) {
        this.fProfiles.remove(string);
        this.fProfiles.put(customProfile.getID(), customProfile);
        if (!customProfile.isSharedProfile()) {
            this.updateProfilesWithName(string, customProfile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile customProfile, CustomProfile customProfile2) {
        this.fProfiles.remove(customProfile.getID());
        this.fProfiles.put(customProfile2.getID(), customProfile2);
        this.fProfilesByName.remove(customProfile);
        this.fProfilesByName.add(customProfile2);
        Collections.sort(this.fProfilesByName);
        if (!customProfile.isSharedProfile()) {
            this.updateProfilesWithName(customProfile.getID(), null, false);
        }
        this.setSelected(customProfile2);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile customProfile) {
        if (!customProfile.isSharedProfile()) {
            this.updateProfilesWithName(customProfile.getID(), customProfile, true);
        }
        this.notifyObservers(5);
    }

    protected void updateProfilesWithName(String string, Profile profile, boolean bl) {
        IScopeContext iScopeContext;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            iScopeContext = this.fPreferencesAccess.getProjectScope(iProjectArray[n]);
            IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.eclipse.wst.jsdt.ui");
            String string2 = iEclipsePreferences.get(this.fProfileKey, null);
            if (string.equals(string2)) {
                if (profile == null) {
                    iEclipsePreferences.remove(this.fProfileKey);
                } else if (bl) {
                    this.writeToPreferenceStore(profile, iScopeContext);
                } else {
                    iEclipsePreferences.put(this.fProfileKey, profile.getID());
                }
            }
            ++n;
        }
        IScopeContext iScopeContext2 = this.fPreferencesAccess.getInstanceScope();
        iScopeContext = iScopeContext2.getNode("org.eclipse.wst.jsdt.ui");
        if (profile != null && string.equals(iScopeContext.get(this.fProfileKey, null))) {
            this.writeToPreferenceStore(profile, iScopeContext2);
        }
    }

    private static void setLatestCompliance(Map map) {
        JavaModelUtil.set50CompilanceOptions(map);
    }

    public abstract Profile getDefaultProfile();

    public IProfileVersioner getProfileVersioner() {
        return this.fProfileVersioner;
    }

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map fSettings;
        private final int fOrder;
        private final int fCurrentVersion;
        private final String fProfileKind;

        public BuiltInProfile(String string, String string2, Map map, int n, int n2, String string3) {
            this.fName = string2;
            this.fID = string;
            this.fSettings = map;
            this.fOrder = n;
            this.fCurrentVersion = n2;
            this.fProfileKind = string3;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String string, ProfileManager profileManager) {
            String string2 = string.trim();
            CustomProfile customProfile = new CustomProfile(string2, this.fSettings, this.fCurrentVersion, this.fProfileKind);
            profileManager.addProfile(customProfile);
            return customProfile;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map map) {
        }

        public String getID() {
            return this.fID;
        }

        public final int compareTo(Object object) {
            if (object instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)object).fOrder;
            }
            return -1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return true;
        }

        public int getVersion() {
            return this.fCurrentVersion;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map fSettings;
        protected ProfileManager fManager;
        private int fVersion;
        private final String fKind;

        public CustomProfile(String string, Map map, int n, String string2) {
            this.fName = string;
            this.fSettings = map;
            this.fVersion = n;
            this.fKind = string2;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String string, ProfileManager profileManager) {
            String string2 = string.trim();
            if (string2.equals(this.getName())) {
                return this;
            }
            String string3 = this.getID();
            this.fName = string2;
            profileManager.profileRenamed(this, string3);
            return this;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map map) {
            if (map == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = map;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        public int getVersion() {
            return this.fVersion;
        }

        public void setVersion(int n) {
            this.fVersion = n;
        }

        public int compareTo(Object object) {
            if (object instanceof SharedProfile) {
                return -1;
            }
            if (object instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(((Profile)object).getName());
            }
            return 1;
        }

        public boolean isProfileToSave() {
            return true;
        }

        public String getKind() {
            return this.fKind;
        }
    }

    public static final class KeySet {
        private final List fKeys;
        private final String fNodeName;

        public KeySet(String string, List list) {
            this.fNodeName = string;
            this.fKeys = list;
        }

        public String getNodeName() {
            return this.fNodeName;
        }

        public List getKeys() {
            return this.fKeys;
        }
    }

    public static abstract class Profile
    implements Comparable {
        public abstract String getName();

        public abstract Profile rename(String var1, ProfileManager var2);

        public abstract Map getSettings();

        public abstract void setSettings(Map var1);

        public abstract int getVersion();

        public boolean hasEqualSettings(Map map, List list) {
            Map map2 = this.getSettings();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                Object v2 = map2.get(string);
                if (!(v == null ? v2 != null : !v.equals(v2))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return false;
        }
    }

    public final class SharedProfile
    extends CustomProfile {
        public SharedProfile(String string, Map map, int n, String string2) {
            super(string, map, n, string2);
        }

        public Profile rename(String string, ProfileManager profileManager) {
            CustomProfile customProfile = new CustomProfile(string.trim(), this.getSettings(), this.getVersion(), this.getKind());
            profileManager.profileReplaced(this, customProfile);
            return customProfile;
        }

        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        public final int compareTo(Object object) {
            return 1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isSharedProfile() {
            return true;
        }
    }
}

