/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;

public class ParameterEditDialog
extends StatusDialog {
    private final ParameterInfo fParameter;
    private final boolean fEditType;
    private final boolean fEditDefault;
    private final StubTypeContext fContext;
    private Text fType;
    private Text fName;
    private Text fDefaultValue;

    public ParameterEditDialog(Shell shell, ParameterInfo parameterInfo, boolean bl, boolean bl2, StubTypeContext stubTypeContext) {
        super(shell);
        this.fParameter = parameterInfo;
        this.fEditType = bl;
        this.fEditDefault = bl2;
        this.fContext = stubTypeContext;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(RefactoringMessages.ParameterEditDialog_title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        Label label = new Label(composite2, 0);
        String string = this.fParameter.getNewName();
        if (string.length() == 0) {
            label.setText(RefactoringMessages.ParameterEditDialog_message_new);
        } else {
            label.setText(Messages.format(RefactoringMessages.ParameterEditDialog_message, string));
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        if (this.fEditType) {
            label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ParameterEditDialog_type);
            this.fType = new Text(composite2, 2048);
            gridData = new GridData(768);
            this.fType.setLayoutData((Object)gridData);
            this.fType.setText(this.fParameter.getNewTypeName());
            this.fType.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    ParameterEditDialog.this.validate((Text)modifyEvent.widget);
                }
            });
            TextFieldNavigationHandler.install(this.fType);
            JavaTypeCompletionProcessor javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(true, false);
            javaTypeCompletionProcessor.setCompletionContext(this.fContext.getCuHandle(), this.fContext.getBeforeString(), this.fContext.getAfterString());
            ControlContentAssistHelper.createTextContentAssistant(this.fType, javaTypeCompletionProcessor);
        }
        label = new Label(composite2, 0);
        this.fName = new Text(composite2, 2048);
        this.initializeDialogUnits((Control)this.fName);
        label.setText(RefactoringMessages.ParameterEditDialog_name);
        gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(45);
        this.fName.setLayoutData((Object)gridData);
        this.fName.setText(string);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ParameterEditDialog.this.validate((Text)modifyEvent.widget);
            }
        });
        TextFieldNavigationHandler.install(this.fName);
        if (this.fEditDefault && this.fParameter.isAdded()) {
            label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ParameterEditDialog_defaultValue);
            this.fDefaultValue = new Text(composite2, 2048);
            gridData = new GridData(768);
            this.fDefaultValue.setLayoutData((Object)gridData);
            this.fDefaultValue.setText(this.fParameter.getDefaultValue());
            this.fDefaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    ParameterEditDialog.this.validate((Text)modifyEvent.widget);
                }
            });
            TextFieldNavigationHandler.install(this.fDefaultValue);
        }
        ParameterEditDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void okPressed() {
        if (this.fType != null) {
            this.fParameter.setNewTypeName(this.fType.getText());
        }
        this.fParameter.setNewName(this.fName.getText());
        if (this.fDefaultValue != null) {
            this.fParameter.setDefaultValue(this.fDefaultValue.getText());
        }
        super.okPressed();
    }

    private void validate(Text text) {
        IStatus[] iStatusArray = new IStatus[3];
        if (text == this.fType) {
            iStatusArray[0] = this.validateType();
            iStatusArray[1] = this.validateName();
            iStatusArray[2] = this.validateDefaultValue();
        } else if (text == this.fName) {
            iStatusArray[0] = this.validateName();
            iStatusArray[1] = this.validateType();
            iStatusArray[2] = this.validateDefaultValue();
        } else {
            iStatusArray[0] = this.validateDefaultValue();
            iStatusArray[1] = this.validateName();
            iStatusArray[2] = this.validateType();
        }
        int n = 0;
        while (n < iStatusArray.length) {
            IStatus iStatus = iStatusArray[n];
            if (iStatus != null && !iStatus.isOK()) {
                this.updateStatus(iStatus);
                return;
            }
            ++n;
        }
        this.updateStatus((IStatus)this.createOkStatus());
    }

    private IStatus validateType() {
        if (this.fType == null) {
            return null;
        }
        String string = this.fType.getText();
        RefactoringStatus refactoringStatus = TypeContextChecker.checkParameterTypeSyntax(string, this.fContext.getCuHandle().getJavaProject());
        if (refactoringStatus == null || refactoringStatus.isOK()) {
            return this.createOkStatus();
        }
        if (refactoringStatus.hasError()) {
            return this.createErrorStatus(refactoringStatus.getEntryWithHighestSeverity().getMessage());
        }
        return this.createWarningStatus(refactoringStatus.getEntryWithHighestSeverity().getMessage());
    }

    private IStatus validateName() {
        if (this.fName == null) {
            return null;
        }
        String string = this.fName.getText();
        if (string.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.ParameterEditDialog_name_error);
        }
        IStatus iStatus = JavaConventions.validateFieldName((String)string);
        if (iStatus.matches(4)) {
            return iStatus;
        }
        if (!Checks.startsWithLowerCase(string)) {
            return this.createWarningStatus(RefactoringCoreMessages.ExtractTempRefactoring_convention);
        }
        return this.createOkStatus();
    }

    private IStatus validateDefaultValue() {
        if (this.fDefaultValue == null) {
            return null;
        }
        String string = this.fDefaultValue.getText();
        if (string.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.ParameterEditDialog_defaultValue_error);
        }
        if (ChangeSignatureRefactoring.isValidExpression(string)) {
            return this.createOkStatus();
        }
        String string2 = Messages.format(RefactoringMessages.ParameterEditDialog_defaultValue_invalid, new String[]{string});
        return this.createErrorStatus(string2);
    }

    private Status createOkStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    private Status createWarningStatus(String string) {
        return new Status(2, JavaPlugin.getPluginId(), 2, string, null);
    }

    private Status createErrorStatus(String string) {
        return new Status(4, JavaPlugin.getPluginId(), 4, string, null);
    }
}

