/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class InlineMethodAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public InlineMethodAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InlineMethodAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.InlineMethodAction_inline_Method);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.inline_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(iStructuredSelection));
            }
            catch (JavaModelException javaModelException) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) break block2;
                JavaPlugin.log(javaModelException);
            }
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isInlineMethodAvailable(iStructuredSelection));
            IMethod iMethod = (IMethod)iStructuredSelection.getFirstElement();
            ISourceRange iSourceRange = iMethod.getNameRange();
            this.run(iSourceRange.getOffset(), iSourceRange.getLength(), iMethod.getTypeRoot());
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), RefactoringMessages.InlineMethodAction_dialog_title, RefactoringMessages.InlineMethodAction_unexpected_exception);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection iTextSelection) {
        ITypeRoot iTypeRoot = SelectionConverter.getInputAsTypeRoot(this.fEditor);
        if (iTypeRoot == null) {
            return;
        }
        if (!JavaElementUtil.isSourceAvailable((ISourceReference)iTypeRoot)) {
            return;
        }
        this.run(iTextSelection.getOffset(), iTextSelection.getLength(), iTypeRoot);
    }

    private void run(int n, int n2, ITypeRoot iTypeRoot) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iTypeRoot)) {
            return;
        }
        try {
            CompilationUnit compilationUnit = RefactoringASTParser.parseWithASTProvider(iTypeRoot, true, null);
            if (!RefactoringExecutionStarter.startInlineMethodRefactoring(iTypeRoot, compilationUnit, n, n2, this.getShell())) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.InlineMethodAction_dialog_title, (String)RefactoringMessages.InlineMethodAction_no_method_invocation_or_declaration_selected);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), RefactoringMessages.InlineMethodAction_dialog_title, RefactoringMessages.InlineMethodAction_unexpected_exception);
        }
    }

    public boolean tryInlineMethod(ITypeRoot iTypeRoot, CompilationUnit compilationUnit, ITextSelection iTextSelection, Shell shell) {
        try {
            if (RefactoringExecutionStarter.startInlineMethodRefactoring(iTypeRoot, compilationUnit, iTextSelection.getOffset(), iTextSelection.getLength(), shell)) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return false;
    }
}

