/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;

public class RefactoringActions {
    public static IType getEnclosingOrPrimaryType(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        if (iJavaElement != null) {
            return RefactoringActions.convertToEnclosingOrPrimaryType(iJavaElement);
        }
        return null;
    }

    public static IType getEnclosingOrPrimaryType(JavaEditor javaEditor) throws JavaModelException {
        return RefactoringActions.convertToEnclosingOrPrimaryType(SelectionConverter.resolveEnclosingElement(javaEditor, (ITextSelection)javaEditor.getSelectionProvider().getSelection()));
    }

    private static IType convertToEnclosingOrPrimaryType(IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement instanceof IType) {
            return (IType)iJavaElement;
        }
        IType iType = (IType)iJavaElement.getAncestor(7);
        if (iType != null) {
            return iType;
        }
        if (iJavaElement instanceof ICompilationUnit) {
            return ((ICompilationUnit)iJavaElement).findPrimaryType();
        }
        if (iJavaElement instanceof IClassFile) {
            return ((IClassFile)iJavaElement).getType();
        }
        return null;
    }

    public static IType getEnclosingType(JavaTextSelection javaTextSelection) throws JavaModelException {
        return RefactoringActions.convertToEnclosingType(javaTextSelection.resolveEnclosingElement());
    }

    public static IType getEnclosingType(JavaEditor javaEditor) throws JavaModelException {
        return RefactoringActions.convertToEnclosingType(SelectionConverter.resolveEnclosingElement(javaEditor, (ITextSelection)javaEditor.getSelectionProvider().getSelection()));
    }

    private static IType convertToEnclosingType(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        if (!(iJavaElement instanceof IType)) {
            iJavaElement = iJavaElement.getAncestor(7);
        }
        return (IType)iJavaElement;
    }
}

