/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.code;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.RowLayouter;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;

public class ExtractMethodInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ExtractMethodInputPage";
    private ExtractMethodRefactoring fRefactoring;
    private Text fTextField;
    private boolean fFirstTime;
    private JavaSourceViewer fSignaturePreview;
    private Document fSignaturePreviewDocument;
    private IDialogSettings fSettings;
    private static final String DESCRIPTION = RefactoringMessages.ExtractMethodInputPage_description;
    private static final String THROW_RUNTIME_EXCEPTIONS = "ThrowRuntimeExceptions";
    private static final String GENERATE_JAVADOC = "GenerateJavadoc";

    public ExtractMethodInputPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR_CU);
        this.setDescription(DESCRIPTION);
        this.fFirstTime = true;
        this.fSignaturePreviewDocument = new Document();
    }

    public void createControl(Composite composite) {
        int n;
        Object object;
        this.fRefactoring = (ExtractMethodRefactoring)this.getRefactoring();
        this.loadSettings();
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        RowLayouter rowLayouter = new RowLayouter(2);
        GridData gridData = null;
        this.initializeDialogUnits((Control)composite2);
        Label label = new Label(composite2, 0);
        label.setText(this.getLabelText());
        this.fTextField = this.createTextInputField(composite2, 2048);
        this.fTextField.setLayoutData((Object)new GridData(768));
        rowLayouter.perform((Control)label, (Control)this.fTextField, 1);
        ASTNode[] aSTNodeArray = this.fRefactoring.getDestinations();
        if (aSTNodeArray.length > 1) {
            label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ExtractMethodInputPage_destination_type);
            object = new Combo(composite2, 12);
            n = 0;
            while (n < aSTNodeArray.length) {
                ASTNode aSTNode = aSTNodeArray[n];
                object.add(this.getLabel(aSTNode));
                ++n;
            }
            object.select(0);
            object.setLayoutData((Object)new GridData(768));
            object.addSelectionListener(new SelectionListener((Combo)object){
                private final /* synthetic */ Combo val$combo;
                {
                    this.val$combo = combo;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractMethodInputPage.this.fRefactoring.setDestination(this.val$combo.getSelectionIndex());
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
        }
        if (!this.fRefactoring.getParameterInfos().isEmpty()) {
            object = new ChangeParametersControl(composite2, 0, RefactoringMessages.ExtractMethodInputPage_parameters, new IParameterListChangeListener(){

                public void parameterChanged(ParameterInfo parameterInfo) {
                    ExtractMethodInputPage.this.parameterModified();
                }

                public void parameterListChanged() {
                    ExtractMethodInputPage.this.parameterModified();
                }

                public void parameterAdded(ParameterInfo parameterInfo) {
                    ExtractMethodInputPage.this.updatePreview(ExtractMethodInputPage.this.getText());
                }
            }, ChangeParametersControl.Mode.EXTRACT_METHOD);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            object.setLayoutData((Object)gridData);
            ((ChangeParametersControl)((Object)object)).setInput(this.fRefactoring.getParameterInfos());
        }
        object = new Button(composite2, 32);
        object.setText(RefactoringMessages.ExtractMethodInputPage_generateJavadocComment);
        n = this.computeGenerateJavadoc();
        this.setGenerateJavadoc(n != 0);
        object.setSelection(n != 0);
        object.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExtractMethodInputPage.this.setGenerateJavadoc(((Button)selectionEvent.widget).getSelection());
            }
        });
        rowLayouter.perform((Control)object);
        int n2 = this.fRefactoring.getNumberOfDuplicates();
        object = new Button(composite2, 32);
        if (n2 == 0) {
            object.setText(RefactoringMessages.ExtractMethodInputPage_duplicates_none);
        } else if (n2 == 1) {
            object.setText(RefactoringMessages.ExtractMethodInputPage_duplicates_single);
        } else {
            object.setText(Messages.format(RefactoringMessages.ExtractMethodInputPage_duplicates_multi, new Integer(n2)));
        }
        object.setSelection(this.fRefactoring.getReplaceDuplicates());
        object.setEnabled(n2 > 0);
        object.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExtractMethodInputPage.this.fRefactoring.setReplaceDuplicates(((Button)selectionEvent.widget).getSelection());
            }
        });
        rowLayouter.perform((Control)object);
        label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(768));
        rowLayouter.perform((Control)label);
        this.createSignaturePreview(composite2, rowLayouter);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.extract_method_wizard_page_context");
    }

    private String getLabel(ASTNode aSTNode) {
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).getName().getIdentifier();
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            if (aSTNode.getLocationInParent() == ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)aSTNode.getParent();
                return Messages.format(RefactoringMessages.ExtractMethodInputPage_anonymous_type_label, ASTNodes.asString((ASTNode)classInstanceCreation.getType()));
            }
            if (aSTNode.getLocationInParent() == EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY) {
                EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)aSTNode.getParent();
                return enumConstantDeclaration.getName().getIdentifier();
            }
        }
        return "UNKNOWN";
    }

    private Text createTextInputField(Composite composite, int n) {
        Text text = new Text(composite, n);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExtractMethodInputPage.this.textModified(ExtractMethodInputPage.this.getText());
            }
        });
        TextFieldNavigationHandler.install(text);
        return text;
    }

    private String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    private String getLabelText() {
        return RefactoringMessages.ExtractMethodInputPage_label_text;
    }

    private void setVisibility(Integer n) {
        this.fRefactoring.setVisibility(n);
        this.updatePreview(this.getText());
    }

    private void setRethrowRuntimeException(boolean bl) {
        this.fSettings.put(THROW_RUNTIME_EXCEPTIONS, bl);
        this.fRefactoring.setThrowRuntimeExceptions(bl);
        this.updatePreview(this.getText());
    }

    private boolean computeGenerateJavadoc() {
        boolean bl = this.fRefactoring.getGenerateJavadoc();
        if (bl) {
            return bl;
        }
        return this.fSettings.getBoolean(GENERATE_JAVADOC);
    }

    private void setGenerateJavadoc(boolean bl) {
        this.fSettings.put(GENERATE_JAVADOC, bl);
        this.fRefactoring.setGenerateJavadoc(bl);
    }

    private void createSignaturePreview(Composite composite, RowLayouter rowLayouter) {
        Label label = new Label(composite, 0);
        label.setText(RefactoringMessages.ExtractMethodInputPage_signature_preview);
        rowLayouter.perform((Control)label);
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fSignaturePreview = new JavaSourceViewer(composite, null, null, false, 584, iPreferenceStore);
        this.fSignaturePreview.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), iPreferenceStore, null, null));
        this.fSignaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
        this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
        this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
        this.fSignaturePreview.setEditable(false);
        Control control = this.fSignaturePreview.getControl();
        PixelConverter pixelConverter = new PixelConverter(control);
        GridData gridData = new GridData(1808);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
        control.setLayoutData((Object)gridData);
        rowLayouter.perform(control);
    }

    private void updatePreview(String string) {
        String string2;
        if (this.fSignaturePreview == null) {
            return;
        }
        if (string.length() == 0) {
            string = "someMethodName";
        }
        int n = this.fSignaturePreview.getTextWidget().getTopPixel();
        try {
            string2 = this.fRefactoring.getSignature(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = "";
        }
        this.fSignaturePreviewDocument.set(string2);
        this.fSignaturePreview.getTextWidget().setTopPixel(n);
    }

    private void loadSettings() {
        this.fSettings = this.getDialogSettings().getSection("ExtractMethodWizard");
        if (this.fSettings == null) {
            this.fSettings = this.getDialogSettings().addNewSection("ExtractMethodWizard");
            this.fSettings.put(THROW_RUNTIME_EXCEPTIONS, false);
            this.fSettings.put(GENERATE_JAVADOC, JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.fRefactoring.getCompilationUnit().getJavaProject()).createComments);
        }
        this.fRefactoring.setThrowRuntimeExceptions(this.fSettings.getBoolean(THROW_RUNTIME_EXCEPTIONS));
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.setPageComplete(false);
                this.updatePreview(this.getText());
                this.fTextField.setFocus();
            } else {
                this.setPageComplete(this.validatePage(true));
            }
        }
        super.setVisible(bl);
    }

    private void textModified(String string) {
        this.fRefactoring.setMethodName(string);
        RefactoringStatus refactoringStatus = this.validatePage(true);
        if (!refactoringStatus.hasFatalError()) {
            this.updatePreview(string);
        } else {
            this.fSignaturePreviewDocument.set("");
        }
        this.setPageComplete(refactoringStatus);
    }

    private void parameterModified() {
        this.updatePreview(this.getText());
        this.setPageComplete(this.validatePage(false));
    }

    private RefactoringStatus validatePage(boolean bl) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (bl) {
            refactoringStatus.merge(this.validateMethodName());
            refactoringStatus.merge(this.validateParameters());
        } else {
            refactoringStatus.merge(this.validateParameters());
            refactoringStatus.merge(this.validateMethodName());
        }
        return refactoringStatus;
    }

    private RefactoringStatus validateMethodName() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        String string = this.getText();
        if ("".equals(string)) {
            refactoringStatus.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyMethodName);
            return refactoringStatus;
        }
        refactoringStatus.merge(this.fRefactoring.checkMethodName());
        return refactoringStatus;
    }

    private RefactoringStatus validateParameters() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        List list = this.fRefactoring.getParameterInfos();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (!"".equals(parameterInfo.getNewName())) continue;
            refactoringStatus.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyParameterName);
            return refactoringStatus;
        }
        refactoringStatus.merge(this.fRefactoring.checkParameterNames());
        refactoringStatus.merge(this.fRefactoring.checkVarargOrder());
        return refactoringStatus;
    }
}

