/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class AccessorDescription {
    private static final String KEY_ACCESSOR_NAME = "accessorName";
    private static final String KEY_ACCESSOR_PACK = "accessorPackage";
    private static final String KEY_RESOURCE_BUNDLE_NAME = "bundleName";
    private static final String KEY_RESOURCE_BUNDLE_PACK = "bundlePackage";
    private final IPackageFragment fResourceBundlePackage;
    private final String fAccessorClassName;
    private final IPackageFragment fAccessorClassPackage;
    private final String fResourceBundleName;

    public AccessorDescription(String string, IPackageFragment iPackageFragment, String string2, IPackageFragment iPackageFragment2) {
        this.fAccessorClassName = string;
        this.fAccessorClassPackage = iPackageFragment;
        this.fResourceBundleName = string2;
        this.fResourceBundlePackage = iPackageFragment2;
    }

    public String getLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAccessorClassPackage().getElementName());
        if (stringBuffer.length() > 0) {
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getAccessorClassName());
        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
        IPath iPath = this.getResourceBundlePackage().getPath().append(this.getResourceBundleName());
        stringBuffer.append(iPath.makeRelative().toString());
        return stringBuffer.toString();
    }

    public void serialize(IDialogSettings iDialogSettings) {
        iDialogSettings.put(KEY_ACCESSOR_NAME, this.getAccessorClassName());
        iDialogSettings.put(KEY_ACCESSOR_PACK, this.getAccessorClassPackage().getHandleIdentifier());
        iDialogSettings.put(KEY_RESOURCE_BUNDLE_NAME, this.getResourceBundleName());
        iDialogSettings.put(KEY_RESOURCE_BUNDLE_PACK, this.getResourceBundlePackage().getHandleIdentifier());
    }

    public String getAccessorClassName() {
        return this.fAccessorClassName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorClassPackage;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            AccessorDescription accessorDescription = (AccessorDescription)object;
            return accessorDescription == this || accessorDescription.fAccessorClassName.equals(this.fAccessorClassName) && accessorDescription.fAccessorClassPackage.equals(this.fAccessorClassPackage) && accessorDescription.fResourceBundleName.equals(this.fResourceBundleName) && accessorDescription.fResourceBundlePackage.equals(this.fResourceBundlePackage);
        }
        return false;
    }

    public int hashCode() {
        return this.fAccessorClassName.hashCode() + this.fAccessorClassPackage.hashCode() + this.fResourceBundleName.hashCode() + this.fResourceBundlePackage.hashCode();
    }

    public static AccessorDescription deserialize(IDialogSettings iDialogSettings) {
        String string = iDialogSettings.get(KEY_ACCESSOR_NAME);
        if (string == null) {
            return null;
        }
        String string2 = iDialogSettings.get(KEY_ACCESSOR_PACK);
        if (string2 == null) {
            return null;
        }
        IJavaElement iJavaElement = JavaCore.create((String)string2);
        if (!(iJavaElement instanceof IPackageFragment) || !iJavaElement.exists()) {
            return null;
        }
        String string3 = iDialogSettings.get(KEY_RESOURCE_BUNDLE_NAME);
        if (string3 == null) {
            return null;
        }
        String string4 = iDialogSettings.get(KEY_RESOURCE_BUNDLE_PACK);
        if (string4 == null) {
            return null;
        }
        IJavaElement iJavaElement2 = JavaCore.create((String)string4);
        if (!(iJavaElement2 instanceof IPackageFragment) || !iJavaElement2.exists()) {
            return null;
        }
        return new AccessorDescription(string, (IPackageFragment)iJavaElement, string3, (IPackageFragment)iJavaElement2);
    }
}

