/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class RenameKeysDialog
extends StatusDialog {
    private StringDialogField fNameField;
    private List fSelectedSubstitutions;
    private int fCommonPrefixLength;

    public RenameKeysDialog(Shell shell, List list) {
        super(shell);
        this.setTitle(NLSUIMessages.RenameKeysDialog_title);
        this.fSelectedSubstitutions = list;
        String string = this.getInitialPrefix(list);
        this.fCommonPrefixLength = string.length();
        this.fNameField = new StringDialogField();
        this.fNameField.setText(string);
        if (string.length() == 0) {
            this.fNameField.setLabelText(NLSUIMessages.RenameKeysDialog_description_noprefix);
        } else {
            this.fNameField.setLabelText(String.valueOf(NLSUIMessages.RenameKeysDialog_description_withprefix) + string + ':');
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.fNameField.doFillIntoGrid(composite2, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        return composite2;
    }

    protected void okPressed() {
        String string = this.fNameField.getText();
        int n = 0;
        while (n < this.fSelectedSubstitutions.size()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)this.fSelectedSubstitutions.get(n);
            String string2 = String.valueOf(string) + nLSSubstitution.getKey().substring(this.fCommonPrefixLength);
            nLSSubstitution.setKey(string2);
            ++n;
        }
        super.okPressed();
    }

    private String getInitialPrefix(List list) {
        String string = null;
        int n = 0;
        while (n < list.size()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)list.get(n);
            String string2 = nLSSubstitution.getKey();
            if (string == null) {
                string = string2;
            } else if (!string2.startsWith(string) && (string = this.getCommonPrefix(string, string2)).length() == 0) {
                return string;
            }
            ++n;
        }
        return string;
    }

    private String getCommonPrefix(String string, String string2) {
        String string3 = string.length() <= string2.length() ? string : string2;
        int n = string3.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                return string.substring(0, n2);
            }
            ++n2;
        }
        return string3;
    }
}

