/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaSourcePackageFragmentRootCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.SourceChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;

class SourceFolderSelectionDialogButtonField
extends StringButtonDialogField
implements IDialogFieldListener {
    private IPackageFragmentRoot fRoot;
    private SourceChangeListener fListener;
    private IDialogFieldListener fUpdateListener;

    public SourceFolderSelectionDialogButtonField(String string, String string2, IStringButtonAdapter iStringButtonAdapter) {
        super(iStringButtonAdapter);
        this.setContentAssistProcessor(new JavaSourcePackageFragmentRootCompletionProcessor());
        this.setLabelText(string);
        this.setButtonLabel(string2);
        this.setDialogFieldListener(this);
    }

    public void dialogFieldChanged(DialogField dialogField) {
        this.setRoot(this.getRootFromString(this.getText()));
    }

    public void setUpdateListener(IDialogFieldListener iDialogFieldListener) {
        this.fUpdateListener = iDialogFieldListener;
    }

    public Control[] doFillIntoGrid(Composite composite, int n, int n2) {
        Control[] controlArray = super.doFillIntoGrid(composite, n);
        Text text = this.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, n2);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        return controlArray;
    }

    public void setSourceChangeListener(SourceChangeListener sourceChangeListener) {
        this.fListener = sourceChangeListener;
    }

    private IPackageFragmentRoot getRootFromString(String string) {
        if (string.length() == 0) {
            return null;
        }
        Path path = new Path(string);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)path);
        if (iResource == null) {
            return null;
        }
        int n = iResource.getType();
        if (n == 4 || n == 2) {
            IProject iProject = iResource.getProject();
            if (!iProject.isOpen()) {
                return null;
            }
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot(iResource);
            if (iPackageFragmentRoot.exists()) {
                return iPackageFragmentRoot;
            }
        }
        return null;
    }

    public void setRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        this.fRoot = iPackageFragmentRoot;
        if (this.fRoot != null) {
            String string = this.getRootString();
            if (!this.getText().equals(string)) {
                this.setText(string);
            }
        }
        this.fListener.sourceRootChanged(this.fRoot);
        if (this.fUpdateListener != null) {
            this.fUpdateListener.dialogFieldChanged(this);
        }
    }

    public IPackageFragmentRoot getRoot() {
        return this.fRoot;
    }

    private String getRootString() {
        return this.fRoot == null ? "" : this.fRoot.getPath().makeRelative().toString();
    }
}

