/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.LineReader;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.Properties;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;

class NLSSearchResultRequestor
extends SearchRequestor {
    private static final StringMatcher fgGetClassNameMatcher = new StringMatcher("*.class.getName()*", false, false);
    private NLSSearchResult fResult;
    private IFile fPropertiesFile;
    private Properties fProperties;
    private HashSet fUsedPropertyNames;

    public NLSSearchResultRequestor(IFile iFile, NLSSearchResult nLSSearchResult) {
        this.fPropertiesFile = iFile;
        this.fResult = nLSSearchResult;
    }

    public void beginReporting() {
        this.loadProperties();
        this.fUsedPropertyNames = new HashSet(this.fProperties.size());
    }

    public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
        Object object;
        String string;
        if (searchMatch.getAccuracy() == 1) {
            return;
        }
        int n = searchMatch.getOffset();
        int n2 = searchMatch.getLength();
        if (n == -1 || n2 == -1) {
            return;
        }
        if (!(searchMatch.getElement() instanceof IJavaElement)) {
            return;
        }
        IJavaElement iJavaElement = (IJavaElement)searchMatch.getElement();
        if (iJavaElement.getElementType() == 13) {
            return;
        }
        if (iJavaElement.getElementType() == 6) {
            return;
        }
        if (iJavaElement.getElementType() == 7) {
            return;
        }
        if (iJavaElement.getElementType() == 8 && (string = (object = (IField)iJavaElement).getSource()) != null && fgGetClassNameMatcher.match(string)) {
            return;
        }
        if (iJavaElement instanceof ISourceReference && (object = ((ISourceReference)iJavaElement).getSource()) != null && ((String)object).indexOf("NLS.initializeMessages") != -1) {
            return;
        }
        object = new Position(n, n2);
        string = this.findKey((Position)object, iJavaElement);
        if (string != null && this.isKeyDefined(string)) {
            return;
        }
        ICompilationUnit[] iCompilationUnitArray = JavaModelUtil.getAllCompilationUnits(new IJavaElement[]{iJavaElement});
        IJavaElement iJavaElement2 = iJavaElement;
        if (iCompilationUnitArray != null && iCompilationUnitArray.length == 1) {
            iJavaElement2 = iCompilationUnitArray[0];
        }
        this.fResult.addMatch(new Match((Object)iJavaElement2, object.getOffset(), object.getLength()));
    }

    public void reportUnusedPropertyNames(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", this.fProperties.size());
        boolean bl = false;
        iProgressMonitor.setTaskName(NLSSearchMessages.NLSSearchResultRequestor_searching);
        String string = Messages.format(NLSSearchMessages.NLSSearchResultCollector_unusedKeys, this.getPropertiesName(this.fPropertiesFile));
        FileEntry fileEntry = new FileEntry(this.fPropertiesFile, string);
        Enumeration<?> enumeration = this.fProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.fUsedPropertyNames.contains(string2)) {
                this.addMatch(fileEntry, string2);
                bl = true;
            }
            iProgressMonitor.worked(1);
        }
        if (bl) {
            this.fResult.addFileEntryGroup(fileEntry);
        }
        iProgressMonitor.done();
    }

    private String getPropertiesName(IFile iFile) {
        String string = iFile.getFullPath().removeLastSegments(1).toOSString();
        return String.valueOf(iFile.getName()) + " - " + string;
    }

    private void addMatch(FileEntry fileEntry, String string) {
        int n;
        String string2 = PropertyFileDocumentModel.unwindEscapeChars(string);
        int n2 = this.findPropertyNameStartPosition(string2);
        if (n2 == -1) {
            n2 = 0;
            n = 0;
        } else {
            n = string2.length();
        }
        this.fResult.addMatch(new Match((Object)fileEntry, n2, n));
    }

    private boolean isKeyDefined(String string) {
        if (string == null) {
            return true;
        }
        this.fUsedPropertyNames.add(string);
        return this.fProperties.getProperty(string) != null;
    }

    public boolean hasPropertyKey(String string) {
        return this.fProperties.containsKey(string);
    }

    public boolean isUsedPropertyKey(String string) {
        return this.fUsedPropertyNames.contains(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findKey(Position position, IJavaElement iJavaElement) throws CoreException {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
        if (iCompilationUnit == null) {
            return null;
        }
        String string = iCompilationUnit.getSource();
        if (string == null) {
            return null;
        }
        IScanner iScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        iScanner.setSource(string.toCharArray());
        iScanner.resetTo(position.getOffset() + position.getLength(), string.length());
        try {
            if (iScanner.getNextToken() != 6) {
                return null;
            }
            if (iScanner.getNextToken() != 5) {
                return null;
            }
            String string2 = new String(iScanner.getCurrentTokenSource());
            int n = iScanner.getCurrentTokenStartPosition();
            int n2 = iScanner.getCurrentTokenEndPosition();
            if (iScanner.getNextToken() != 7) {
                position.setOffset(n);
                position.setLength(n2 - n + 1);
                return string2;
            }
            if (iScanner.getNextToken() != 45) {
                return null;
            }
            n = iScanner.getCurrentTokenStartPosition() + 1;
            n2 = iScanner.getCurrentTokenEndPosition();
            position.setOffset(n);
            position.setLength(n2 - n);
            return string.substring(n, n2);
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findPropertyNameStartPosition(String var1_1) {
        var2_2 = null;
        var3_3 = null;
        try {
            var4_4 = this.fPropertiesFile.getCharset();
        }
        catch (CoreException v0) {
            var4_4 = "ISO-8859-1";
        }
        try {
            var2_2 = this.createInputStream(this.fPropertiesFile);
            var3_3 = new LineReader(var2_2, var4_4);
        }
        catch (CoreException var5_5) {
            JavaPlugin.log(var5_5);
            return -1;
        }
        catch (IOException v1) {
            if (var2_2 == null) return -1;
            try {
                var2_2.close();
                return -1;
            }
            catch (IOException var5_6) {
                JavaPlugin.log(var5_6);
            }
            return -1;
        }
        var5_7 = 0;
        try {
            try {
                var6_8 = new StringBuffer(80);
                var7_10 = var3_3.readLine(var6_8);
                var8_11 = var1_1.length();
                while (true) {
                    block20: {
                        if (var7_10 > 0) break block20;
                        if (var7_10 != -17) {
                            var5_7 = -1;
                        }
                        break;
                    }
                    var9_12 = var6_8.toString();
                    var10_13 = var9_12.indexOf(var1_1);
                    var11_14 = var10_13 + var8_11;
                    var12_15 = '\u0000';
                    v2 = var13_16 = var11_14 >= var9_12.length();
                    if (var10_13 > -1 && !var13_16) {
                        var12_15 = var9_12.charAt(var11_14);
                    }
                    if (var9_12.trim().startsWith(var1_1) && (var13_16 || Character.isWhitespace(var12_15) || var12_15 == '=')) {
                        var5_7 += var9_12.indexOf(var1_1);
                        var7_10 = -17;
                        continue;
                    }
                    var5_7 += var9_12.length() + var7_10;
                    var6_8.setLength(0);
                    var7_10 = var3_3.readLine(var6_8);
                }
            }
            catch (IOException var6_9) {
                JavaPlugin.log(var6_9);
                var14_17 = null;
                try {
                    var3_3.close();
                    return -1;
                }
                catch (IOException var16_20) {
                    JavaPlugin.log(var16_20);
                }
                return -1;
            }
        }
        catch (Throwable var15_23) {
            var14_18 = null;
            ** try [egrp 5[TRYBLOCK] [7 : 287->294)] { 
lbl64:
            // 1 sources

            var3_3.close();
            throw var15_23;
lbl66:
            // 1 sources

            catch (IOException var16_21) {
                JavaPlugin.log(var16_21);
            }
            throw var15_23;
        }
        {
            var14_19 = null;
        }
        try {}
        catch (IOException var16_22) {
            JavaPlugin.log(var16_22);
            return var5_7;
        }
        var3_3.close();
        return var5_7;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProperties() {
        BufferedInputStream bufferedInputStream;
        HashSet hashSet = new HashSet();
        this.fProperties = new Properties(hashSet);
        try {
            bufferedInputStream = new BufferedInputStream(this.createInputStream(this.fPropertiesFile));
        }
        catch (CoreException coreException) {
            this.fProperties = new Properties();
            return;
        }
        try {
            try {
                this.fProperties.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                this.fProperties = new Properties();
                Object var3_3 = null;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException2) {}
                this.reportDuplicateKeys(hashSet);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {}
            catch (IOException iOException) {}
            ((InputStream)bufferedInputStream).close();
            this.reportDuplicateKeys(hashSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)bufferedInputStream).close();
        this.reportDuplicateKeys(hashSet);
    }

    private InputStream createInputStream(IFile iFile) throws CoreException {
        ITextFileBuffer iTextFileBuffer;
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        if (iTextFileBufferManager != null && (iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(iFile.getFullPath(), LocationKind.IFILE)) != null) {
            return new ByteArrayInputStream(iTextFileBuffer.getDocument().get().getBytes());
        }
        return iFile.getContents();
    }

    private void reportDuplicateKeys(Set set) {
        if (set.size() == 0) {
            return;
        }
        String string = Messages.format(NLSSearchMessages.NLSSearchResultCollector_duplicateKeys, this.getPropertiesName(this.fPropertiesFile));
        FileEntry fileEntry = new FileEntry(this.fPropertiesFile, string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.addMatch(fileEntry, string2);
        }
        this.fResult.addFileEntryGroup(fileEntry);
    }
}

