/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypedSource;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.TypedSourceTransfer;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class PasteAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;

    public PasteAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard) {
        super(iWorkbenchSite);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.setText(ReorgMessages.PasteAction_4);
        this.setDescription(ReorgMessages.PasteAction_5);
        ISharedImages iSharedImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.paste_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
    }

    private Paster[] createEnabledPasters(TransferData[] transferDataArray) throws JavaModelException {
        Shell shell = this.getShell();
        ArrayList<Paster> arrayList = new ArrayList<Paster>(2);
        Paster paster = new ProjectPaster(shell, this.fClipboard);
        if (paster.canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if ((paster = new JavaElementAndResourcePaster(shell, this.fClipboard)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if ((paster = new TypedSourcePaster(shell, this.fClipboard)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if ((paster = new FilePaster(shell, this.fClipboard)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if ((paster = new WorkingSetPaster(shell, this.fClipboard)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        if ((paster = new TextPaster(shell, this.fClipboard)).canEnable(transferDataArray)) {
            arrayList.add(paster);
        }
        return arrayList.toArray(new Paster[arrayList.size()]);
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] objectArray = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                objectArray[0] = clipboard.getContents(transfer);
            }
        });
        return objectArray[0];
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] transferDataArray) {
        int n = 0;
        while (n < transferDataArray.length) {
            if (transfer.isSupportedType(transferDataArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            TransferData[] transferDataArray = this.fClipboard.getAvailableTypes();
            List list = iStructuredSelection.toList();
            IResource[] iResourceArray = ReorgUtils.getResources(list);
            IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(list);
            IWorkingSet[] iWorkingSetArray = ReorgUtils.getWorkingSets(list);
            Paster[] pasterArray = this.createEnabledPasters(transferDataArray);
            int n = 0;
            while (n < pasterArray.length) {
                if (pasterArray[n].canPasteOn(iJavaElementArray, iResourceArray, iWorkingSetArray)) {
                    pasterArray[n].paste(iJavaElementArray, iResourceArray, iWorkingSetArray, transferDataArray);
                    return;
                }
                ++n;
            }
            String string = iResourceArray.length + iJavaElementArray.length + iWorkingSetArray.length == 0 ? ReorgMessages.PasteAction_cannot_no_selection : ReorgMessages.PasteAction_cannot_selection;
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ReorgMessages.PasteAction_name, (String)string);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static class FilePaster
    extends Paster {
        protected FilePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray, TransferData[] transferDataArray) throws JavaModelException {
            String[] stringArray = this.getClipboardFiles(transferDataArray);
            if (stringArray == null) {
                return;
            }
            IContainer iContainer = this.getAsContainer(this.getTarget(iJavaElementArray, iResourceArray));
            if (iContainer == null) {
                return;
            }
            new CopyFilesAndFoldersOperation(this.getShell()).copyFiles(stringArray, iContainer);
        }

        private Object getTarget(IJavaElement[] iJavaElementArray, IResource[] iResourceArray) {
            if (iJavaElementArray.length + iResourceArray.length == 1) {
                if (iJavaElementArray.length == 1) {
                    return iJavaElementArray[0];
                }
                return iResourceArray[0];
            }
            return this.getCommonParent(iJavaElementArray, iResourceArray);
        }

        public boolean canPasteOn(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray) throws JavaModelException {
            Object object = this.getTarget(iJavaElementArray, iResourceArray);
            return object != null && this.canPasteFilesOn(this.getAsContainer(object)) && iWorkingSetArray.length == 0;
        }

        public boolean canEnable(TransferData[] transferDataArray) throws JavaModelException {
            return PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), transferDataArray);
        }

        private boolean canPasteFilesOn(Object object) {
            boolean bl = object instanceof IPackageFragment;
            boolean bl2 = object instanceof IJavaProject;
            boolean bl3 = object instanceof IPackageFragmentRoot;
            boolean bl4 = object instanceof IContainer;
            if (!(bl || bl2 || bl3 || bl4)) {
                return false;
            }
            if (bl4) {
                return true;
            }
            IJavaElement iJavaElement = (IJavaElement)object;
            return !iJavaElement.isReadOnly();
        }

        private IContainer getAsContainer(Object object) throws JavaModelException {
            if (object == null) {
                return null;
            }
            if (object instanceof IContainer) {
                return (IContainer)object;
            }
            if (object instanceof IFile) {
                return ((IFile)object).getParent();
            }
            return this.getAsContainer(((IJavaElement)object).getCorrespondingResource());
        }

        private String[] getClipboardFiles(TransferData[] transferDataArray) {
            FileTransfer fileTransfer = FileTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)fileTransfer, transferDataArray)) {
                return (String[])PasteAction.getContents(this.getClipboard(), (Transfer)fileTransfer, this.getShell());
            }
            return null;
        }

        private Object getCommonParent(IJavaElement[] iJavaElementArray, IResource[] iResourceArray) {
            return new ParentChecker(iResourceArray, iJavaElementArray).getCommonParent();
        }
    }

    private static class JavaElementAndResourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected JavaElementAndResourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray, TransferData[] transferDataArray) throws JavaModelException, InterruptedException, InvocationTargetException {
            Object object;
            IJavaElement[] iJavaElementArray2;
            IResource[] iResourceArray2 = this.getClipboardResources(transferDataArray);
            if (iResourceArray2 == null) {
                iResourceArray2 = new IResource[]{};
            }
            if ((iJavaElementArray2 = this.getClipboardJavaElements(transferDataArray)) == null) {
                iJavaElementArray2 = new IJavaElement[]{};
            }
            if ((object = this.getTarget(iJavaElementArray, iResourceArray)) instanceof IJavaElement) {
                ReorgCopyStarter.create(iJavaElementArray2, iResourceArray2, (IJavaElement)object).run(this.getShell());
            } else if (object instanceof IResource) {
                ReorgCopyStarter.create(iJavaElementArray2, iResourceArray2, (IResource)object).run(this.getShell());
            }
        }

        private Object getTarget(IJavaElement[] iJavaElementArray, IResource[] iResourceArray) {
            if (iJavaElementArray.length + iResourceArray.length == 1) {
                if (iJavaElementArray.length == 1) {
                    return iJavaElementArray[0];
                }
                return iResourceArray[0];
            }
            return this.getCommonParent(iJavaElementArray, iResourceArray);
        }

        private Object getCommonParent(IJavaElement[] iJavaElementArray, IResource[] iResourceArray) {
            return new ParentChecker(iResourceArray, iJavaElementArray).getCommonParent();
        }

        public boolean canPasteOn(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray) throws JavaModelException {
            Object object;
            IJavaElement[] iJavaElementArray2;
            if (iWorkingSetArray.length != 0) {
                return false;
            }
            IResource[] iResourceArray2 = this.getClipboardResources(this.fAvailableTypes);
            if (iResourceArray2 == null) {
                iResourceArray2 = new IResource[]{};
            }
            if ((iJavaElementArray2 = this.getClipboardJavaElements(this.fAvailableTypes)) == null) {
                iJavaElementArray2 = new IJavaElement[]{};
            }
            if ((object = this.getTarget(iJavaElementArray, iResourceArray)) instanceof IJavaElement) {
                return ReorgCopyStarter.create(iJavaElementArray2, iResourceArray2, (IJavaElement)object) != null;
            }
            if (object instanceof IResource) {
                return ReorgCopyStarter.create(iJavaElementArray2, iResourceArray2, (IResource)object) != null;
            }
            return false;
        }

        public boolean canEnable(TransferData[] transferDataArray) {
            this.fAvailableTypes = transferDataArray;
            return PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), transferDataArray) || PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), transferDataArray);
        }
    }

    private static abstract class Paster {
        private final Shell fShell;
        private final Clipboard fClipboard2;

        protected Paster(Shell shell, Clipboard clipboard) {
            this.fShell = shell;
            this.fClipboard2 = clipboard;
        }

        protected final Shell getShell() {
            return this.fShell;
        }

        protected final Clipboard getClipboard() {
            return this.fClipboard2;
        }

        protected final IResource[] getClipboardResources(TransferData[] transferDataArray) {
            ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)resourceTransfer, transferDataArray)) {
                return (IResource[])PasteAction.getContents(this.fClipboard2, (Transfer)resourceTransfer, this.getShell());
            }
            return null;
        }

        protected final IJavaElement[] getClipboardJavaElements(TransferData[] transferDataArray) {
            JavaElementTransfer javaElementTransfer = JavaElementTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)javaElementTransfer, transferDataArray)) {
                return (IJavaElement[])PasteAction.getContents(this.fClipboard2, (Transfer)javaElementTransfer, this.getShell());
            }
            return null;
        }

        protected final TypedSource[] getClipboardTypedSources(TransferData[] transferDataArray) {
            TypedSourceTransfer typedSourceTransfer = TypedSourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)typedSourceTransfer, transferDataArray)) {
                return (TypedSource[])PasteAction.getContents(this.fClipboard2, (Transfer)typedSourceTransfer, this.getShell());
            }
            return null;
        }

        protected final String getClipboardText(TransferData[] transferDataArray) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)textTransfer, transferDataArray)) {
                return (String)PasteAction.getContents(this.fClipboard2, (Transfer)textTransfer, this.getShell());
            }
            return null;
        }

        public abstract boolean canEnable(TransferData[] var1) throws JavaModelException;

        public abstract boolean canPasteOn(IJavaElement[] var1, IResource[] var2, IWorkingSet[] var3) throws JavaModelException;

        public abstract void paste(IJavaElement[] var1, IResource[] var2, IWorkingSet[] var3, TransferData[] var4) throws JavaModelException, InterruptedException, InvocationTargetException;
    }

    private static class ProjectPaster
    extends Paster {
        protected ProjectPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] transferDataArray) {
            boolean bl = PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), transferDataArray);
            boolean bl2 = PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), transferDataArray);
            if (!bl2) {
                return this.canPasteSimpleProjects(transferDataArray);
            }
            if (!bl) {
                return this.canPasteJavaProjects(transferDataArray);
            }
            return this.canPasteJavaProjects(transferDataArray) && this.canPasteSimpleProjects(transferDataArray);
        }

        public void paste(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray, TransferData[] transferDataArray) {
            this.pasteProjects(transferDataArray);
        }

        private void pasteProjects(TransferData[] transferDataArray) {
            this.pasteProjects(this.getProjectsToPaste(transferDataArray));
        }

        private void pasteProjects(IProject[] iProjectArray) {
            Shell shell = this.getShell();
            int n = 0;
            while (n < iProjectArray.length) {
                new CopyProjectOperation(shell).copyProject(iProjectArray[n]);
                ++n;
            }
        }

        private IProject[] getProjectsToPaste(TransferData[] transferDataArray) {
            IResource[] iResourceArray = this.getClipboardResources(transferDataArray);
            IJavaElement[] iJavaElementArray = this.getClipboardJavaElements(transferDataArray);
            HashSet<IResource> hashSet = new HashSet<IResource>();
            if (iResourceArray != null) {
                hashSet.addAll(Arrays.asList(iResourceArray));
            }
            if (iJavaElementArray != null) {
                hashSet.addAll(Arrays.asList(ReorgUtils.getNotNulls(ReorgUtils.getResources(iJavaElementArray))));
            }
            Assert.isTrue((hashSet.size() > 0 ? 1 : 0) != 0);
            return hashSet.toArray(new IProject[hashSet.size()]);
        }

        public boolean canPasteOn(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray) {
            return iWorkingSetArray.length == 0;
        }

        private boolean canPasteJavaProjects(TransferData[] transferDataArray) {
            IJavaElement[] iJavaElementArray = this.getClipboardJavaElements(transferDataArray);
            return iJavaElementArray != null && iJavaElementArray.length != 0 && !ReorgUtils.hasElementsNotOfType(iJavaElementArray, 2);
        }

        private boolean canPasteSimpleProjects(TransferData[] transferDataArray) {
            IResource[] iResourceArray = this.getClipboardResources(transferDataArray);
            if (iResourceArray == null || iResourceArray.length == 0) {
                return false;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].getType() != 4 || !((IProject)iResourceArray[n]).isOpen()) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    private static class TextPaster
    extends Paster {
        private IPackageFragmentRoot fDestination;
        private IPackageFragment fDestinationPack;
        private ParsedCu[] fParsedCus;
        private TransferData[] fAvailableTypes;

        protected TextPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] transferDataArray) {
            this.fAvailableTypes = transferDataArray;
            return PasteAction.isAvailable((Transfer)TextTransfer.getInstance(), transferDataArray);
        }

        public boolean canPasteOn(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray) throws JavaModelException {
            if (iWorkingSetArray.length != 0) {
                return false;
            }
            if (iResourceArray.length != 0) {
                return false;
            }
            if (iJavaElementArray.length > 1) {
                return false;
            }
            String string = this.getClipboardText(this.fAvailableTypes);
            IJavaProject iJavaProject = null;
            IJavaElement iJavaElement = null;
            if (iJavaElementArray.length == 1) {
                iJavaElement = iJavaElementArray[0];
                iJavaProject = iJavaElement.getJavaProject();
            }
            this.fParsedCus = ParsedCu.parse(iJavaProject, string);
            if (this.fParsedCus.length == 0) {
                return false;
            }
            if (iJavaElement == null) {
                return true;
            }
            switch (iJavaElement.getElementType()) {
                case 2: {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = ((IJavaProject)iJavaElement).getPackageFragmentRoots();
                    int n = 0;
                    while (n < iPackageFragmentRootArray.length) {
                        IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
                        if (this.isWritable(iPackageFragmentRoot)) {
                            this.fDestination = iPackageFragmentRoot;
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                case 3: {
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                    if (this.isWritable(iPackageFragmentRoot)) {
                        this.fDestination = iPackageFragmentRoot;
                        return true;
                    }
                    return false;
                }
                case 4: {
                    IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
                    if (this.isWritable(iPackageFragmentRoot)) {
                        this.fDestination = iPackageFragmentRoot;
                        if (this.fParsedCus.length == 1) {
                            this.fDestinationPack = iPackageFragment;
                        }
                        return true;
                    }
                    return false;
                }
                case 5: {
                    IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement.getParent();
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
                    if (this.isWritable(iPackageFragmentRoot)) {
                        this.fDestination = iPackageFragmentRoot;
                        if (this.fParsedCus.length == 1) {
                            this.fDestinationPack = iPackageFragment;
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isWritable(IPackageFragmentRoot iPackageFragmentRoot) {
            try {
                return iPackageFragmentRoot.exists() && !iPackageFragmentRoot.isArchive() && !iPackageFragmentRoot.isReadOnly() && iPackageFragmentRoot.getKind() == 1;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        public void paste(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray, TransferData[] transferDataArray) throws JavaModelException, InterruptedException, InvocationTargetException {
            IEditorPart[] iEditorPartArray = new IEditorPart[1];
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(this, iEditorPartArray){
                private IPath fVMPath;
                private String fCompilerCompliance;
                final /* synthetic */ TextPaster this$1;
                private final /* synthetic */ IEditorPart[] val$editorPart;
                {
                    this.this$1 = textPaster;
                    this.val$editorPart = iEditorPartArray;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    ArrayList<E> arrayList = new ArrayList<E>();
                    try {
                        try {
                            JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(this, arrayList){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ ArrayList val$cus;
                                {
                                    this.this$2 = var1_1;
                                    this.val$cus = arrayList;
                                }

                                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                                    iProgressMonitor.beginTask("", 1 + TextPaster.access$0(1.access$2(this.this$2)).length);
                                    if (TextPaster.access$1(1.access$2(this.this$2)) == null) {
                                        TextPaster.access$2(1.access$2(this.this$2), 1.access$0(this.this$2, new SubProgressMonitor(iProgressMonitor, 1)));
                                    } else {
                                        iProgressMonitor.worked(1);
                                    }
                                    IConfirmQuery iConfirmQuery = new ReorgQueries(1.access$2(this.this$2).getShell()).createYesYesToAllNoNoToAllQuery(ReorgMessages.PasteAction_TextPaster_confirmOverwriting, true, 6);
                                    int n = 0;
                                    while (n < TextPaster.access$0(1.access$2(this.this$2)).length) {
                                        if (iProgressMonitor.isCanceled()) break;
                                        ICompilationUnit iCompilationUnit = 1.access$1(this.this$2, TextPaster.access$0(1.access$2(this.this$2))[n], new SubProgressMonitor(iProgressMonitor, 1), iConfirmQuery);
                                        if (iCompilationUnit != null) {
                                            this.val$cus.add(iCompilationUnit);
                                        }
                                        ++n;
                                    }
                                }
                            }, (IProgressMonitor)iProgressMonitor);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                        }
                        catch (CoreException coreException) {
                            throw new InvocationTargetException(coreException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var4_7 = null;
                    }
                    iProgressMonitor.done();
                    IFile[] iFileArray = ResourceUtil.getFiles(arrayList.toArray(new ICompilationUnit[arrayList.size()]));
                    SelectionUtil.selectAndReveal((IResource[])iFileArray, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private ICompilationUnit pasteCU(ParsedCu parsedCu, SubProgressMonitor subProgressMonitor, IConfirmQuery iConfirmQuery) throws CoreException, OperationCanceledException {
                    ICompilationUnit iCompilationUnit;
                    block17: {
                        block15: {
                            subProgressMonitor.beginTask("", 4);
                            try {
                                String string;
                                IPackageFragment iPackageFragment;
                                if (TextPaster.access$3(this.this$1) != null) {
                                    iPackageFragment = TextPaster.access$3(this.this$1);
                                    subProgressMonitor.worked(1);
                                } else {
                                    string = parsedCu.getPackageName();
                                    iPackageFragment = TextPaster.access$1(this.this$1).getPackageFragment(string);
                                    if (!iPackageFragment.exists()) {
                                        JavaModelUtil.getPackageFragmentRoot((IJavaElement)iPackageFragment).createPackageFragment(string, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                                    } else {
                                        subProgressMonitor.worked(1);
                                    }
                                }
                                string = String.valueOf(parsedCu.getTypeName()) + ".js";
                                ICompilationUnit iCompilationUnit2 = iPackageFragment.getCompilationUnit(string);
                                boolean bl = iCompilationUnit2.exists();
                                if (bl) {
                                    String string2 = Messages.format(ReorgMessages.PasteAction_TextPaster_exists, new Object[]{string});
                                    boolean bl2 = iConfirmQuery.confirm(string2);
                                    if (!bl2) {
                                        Object var10_10 = null;
                                        break block15;
                                    }
                                    this.val$editorPart[0] = TextPaster.access$4(this.this$1, iCompilationUnit2);
                                }
                                iPackageFragment.createCompilationUnit(string, parsedCu.getText(), true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                                if (!bl) {
                                    this.val$editorPart[0] = TextPaster.access$4(this.this$1, iCompilationUnit2);
                                }
                                if (TextPaster.access$3(this.this$1) != null && !TextPaster.access$3(this.this$1).getElementName().equals(parsedCu.getPackageName())) {
                                    if (TextPaster.access$3(this.this$1).getElementName().length() == 0) {
                                        this.removePackageDeclaration(iCompilationUnit2);
                                    } else {
                                        iCompilationUnit2.createPackageDeclaration(TextPaster.access$3(this.this$1).getElementName(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                                    }
                                    if (!bl && this.val$editorPart[0] != null) {
                                        this.val$editorPart[0].doSave((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                                    } else {
                                        subProgressMonitor.worked(1);
                                    }
                                } else {
                                    subProgressMonitor.worked(1);
                                }
                                iCompilationUnit = iCompilationUnit2;
                                break block17;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                subProgressMonitor.done();
                                throw throwable;
                            }
                        }
                        subProgressMonitor.done();
                        return null;
                    }
                    Object var10_11 = null;
                    subProgressMonitor.done();
                    return iCompilationUnit;
                }

                private IPackageFragmentRoot createNewProject(SubProgressMonitor subProgressMonitor) throws CoreException {
                    IProject iProject;
                    Object object;
                    String string;
                    IProject iProject2;
                    subProgressMonitor.beginTask("", 10);
                    int n = 1;
                    do {
                        string = Messages.format(ReorgMessages.PasteAction_projectName, n == 1 ? "" : new Integer(n));
                        iProject2 = JavaPlugin.getWorkspace().getRoot().getProject(string);
                        ++n;
                    } while (iProject2.exists());
                    BuildPathsBlock.createProject(iProject2, null, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 3));
                    BuildPathsBlock.addJavaNature(iProject2, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                    string = JavaCore.create((IProject)iProject2);
                    IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
                    String string2 = iPreferenceStore.getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersSrcName");
                    if (iPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersInNewProjects") && string2.length() > 0) {
                        object = iProject2.getFolder(string2);
                        if (!object.exists()) {
                            object.create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        }
                        iProject = object;
                    } else {
                        iProject = iProject2;
                    }
                    this.computeLatestVM();
                    if (this.fCompilerCompliance != null) {
                        object = string.getOptions(false);
                        JavaModelUtil.setCompilanceOptions((Map)object, this.fCompilerCompliance);
                        JavaModelUtil.setDefaultClassfileOptions((Map)object, this.fCompilerCompliance);
                        string.setOptions((Map)object);
                    }
                    object = JavaCore.newSourceEntry((IPath)iProject.getFullPath());
                    IClasspathEntry iClasspathEntry = JavaCore.newContainerEntry((IPath)this.fVMPath);
                    IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[]{object, iClasspathEntry};
                    string.setRawClasspath(iClasspathEntryArray, null, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                    return string.getPackageFragmentRoot((IResource)iProject);
                }

                private void computeLatestVM() {
                }

                private String getVMVersion(IVMInstall iVMInstall) {
                    if (iVMInstall instanceof IVMInstall2) {
                        IVMInstall2 iVMInstall2 = (IVMInstall2)((Object)iVMInstall);
                        return JavaModelUtil.getCompilerCompliance(iVMInstall2, null);
                    }
                    return null;
                }

                /*
                 * Exception decompiling
                 */
                private void removePackageDeclaration(ICompilationUnit var1_1) throws JavaModelException, CoreException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 89->93)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                static /* synthetic */ IPackageFragmentRoot access$0(1 var0, SubProgressMonitor subProgressMonitor) throws CoreException {
                    return var0.createNewProject(subProgressMonitor);
                }

                static /* synthetic */ ICompilationUnit access$1(1 var0, ParsedCu parsedCu, SubProgressMonitor subProgressMonitor, IConfirmQuery iConfirmQuery) throws CoreException, OperationCanceledException {
                    return var0.pasteCU(parsedCu, subProgressMonitor, iConfirmQuery);
                }

                static /* synthetic */ TextPaster access$2(1 var0) {
                    return var0.this$1;
                }
            };
            Object object = JavaPlugin.getActiveWorkbenchWindow();
            if (object == null) {
                object = new BusyIndicatorRunnableContext();
            }
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)object, iRunnableWithProgress, (ISchedulingRule)JavaPlugin.getWorkspace().getRoot());
            if (iEditorPartArray[0] != null) {
                iEditorPartArray[0].getEditorSite().getPage().activate((IWorkbenchPart)iEditorPartArray[0]);
            }
        }

        private IEditorPart openCu(ICompilationUnit iCompilationUnit) {
            try {
                return JavaUI.openInEditor((IJavaElement)iCompilationUnit, true, true);
            }
            catch (PartInitException partInitException) {
                JavaPlugin.log(partInitException);
                return null;
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                return null;
            }
        }

        static /* synthetic */ ParsedCu[] access$0(TextPaster textPaster) {
            return textPaster.fParsedCus;
        }

        static /* synthetic */ IPackageFragmentRoot access$1(TextPaster textPaster) {
            return textPaster.fDestination;
        }

        static /* synthetic */ void access$2(TextPaster textPaster, IPackageFragmentRoot iPackageFragmentRoot) {
            textPaster.fDestination = iPackageFragmentRoot;
        }

        static /* synthetic */ IPackageFragment access$3(TextPaster textPaster) {
            return textPaster.fDestinationPack;
        }

        static /* synthetic */ IEditorPart access$4(TextPaster textPaster, ICompilationUnit iCompilationUnit) {
            return textPaster.openCu(iCompilationUnit);
        }

        private static class ParsedCu {
            private final String fText;
            private final String fTypeName;
            private final String fPackageName;

            public static ParsedCu[] parse(IJavaProject iJavaProject, String string) {
                IScanner iScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                iScanner.setSource(string.toCharArray());
                ArrayList<ParsedCu> arrayList = new ArrayList<ParsedCu>();
                int n = 0;
                boolean bl = false;
                while (true) {
                    int n2;
                    try {
                        n2 = iScanner.getNextToken();
                    }
                    catch (InvalidInputException invalidInputException) {
                        n2 = 158;
                    }
                    if (n2 == 214 && bl) {
                        int n3 = iScanner.getCurrentTokenStartPosition();
                        ParsedCu parsedCu = ParsedCu.parseCu(iJavaProject, string.substring(n, n3));
                        if (parsedCu != null) {
                            arrayList.add(parsedCu);
                            n = n3;
                        }
                    } else if (n2 == 158) {
                        ParsedCu parsedCu = ParsedCu.parseCu(iJavaProject, string.substring(n, string.length()));
                        if (parsedCu == null) break;
                        arrayList.add(parsedCu);
                        break;
                    }
                    bl = true;
                }
                return arrayList.toArray(new ParsedCu[arrayList.size()]);
            }

            private static ParsedCu parseCu(IJavaProject iJavaProject, String string) {
                String string2 = "";
                ASTParser aSTParser = ASTParser.newParser((int)3);
                aSTParser.setProject(iJavaProject);
                aSTParser.setSource(string.toCharArray());
                aSTParser.setStatementsRecovery(true);
                CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
                if (compilationUnit == null) {
                    return null;
                }
                int n = compilationUnit.types().size();
                String string3 = null;
                if (n > 0) {
                    int n2 = 2;
                    ListIterator listIterator = compilationUnit.types().listIterator(n);
                    while (listIterator.hasPrevious()) {
                        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)listIterator.previous();
                        int n3 = JdtFlags.getVisibilityCode((BodyDeclaration)abstractTypeDeclaration);
                        if (JdtFlags.isHigherVisibility(n2, n3)) continue;
                        n2 = n3;
                        string3 = abstractTypeDeclaration.getName().getIdentifier();
                    }
                }
                if (string3 == null) {
                    return null;
                }
                PackageDeclaration packageDeclaration = compilationUnit.getPackage();
                if (packageDeclaration != null) {
                    string2 = packageDeclaration.getName().getFullyQualifiedName();
                }
                return new ParsedCu(string, string3, string2);
            }

            private ParsedCu(String string, String string2, String string3) {
                this.fText = string;
                this.fTypeName = string2;
                this.fPackageName = string3;
            }

            public String getTypeName() {
                return this.fTypeName;
            }

            public String getPackageName() {
                return this.fPackageName;
            }

            public String getText() {
                return this.fText;
            }
        }
    }

    private static class TypedSourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected TypedSourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] transferDataArray) throws JavaModelException {
            this.fAvailableTypes = transferDataArray;
            return PasteAction.isAvailable((Transfer)TypedSourceTransfer.getInstance(), transferDataArray);
        }

        public boolean canPasteOn(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray) throws JavaModelException {
            if (iResourceArray.length != 0 || iWorkingSetArray.length != 0) {
                return false;
            }
            TypedSource[] typedSourceArray = this.getClipboardTypedSources(this.fAvailableTypes);
            IJavaElement iJavaElement = TypedSourcePaster.getTarget(iJavaElementArray, iResourceArray);
            if (iJavaElement instanceof IJavaElement) {
                return ReorgTypedSourcePasteStarter.create(typedSourceArray, iJavaElement) != null;
            }
            return false;
        }

        public void paste(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray, TransferData[] transferDataArray) throws JavaModelException, InterruptedException, InvocationTargetException {
            TypedSource[] typedSourceArray = this.getClipboardTypedSources(transferDataArray);
            IJavaElement iJavaElement = TypedSourcePaster.getTarget(iJavaElementArray, iResourceArray);
            ReorgTypedSourcePasteStarter.create(typedSourceArray, iJavaElement).run(this.getShell());
        }

        private static IJavaElement getTarget(IJavaElement[] iJavaElementArray, IResource[] iResourceArray) {
            Assert.isTrue((iResourceArray.length == 0 ? 1 : 0) != 0);
            if (iJavaElementArray.length == 1) {
                return TypedSourcePaster.getAsTypeOrCu(iJavaElementArray[0]);
            }
            Object object = new ParentChecker(iResourceArray, iJavaElementArray).getCommonParent();
            if (object instanceof IJavaElement) {
                return TypedSourcePaster.getAsTypeOrCu((IJavaElement)object);
            }
            return null;
        }

        private static IJavaElement getAsTypeOrCu(IJavaElement iJavaElement) {
            if (iJavaElement.getElementType() == 5 || iJavaElement.getElementType() == 7) {
                return iJavaElement;
            }
            IJavaElement iJavaElement2 = iJavaElement.getAncestor(7);
            if (iJavaElement2 != null) {
                return iJavaElement2;
            }
            return ReorgUtils.getCompilationUnit(iJavaElement);
        }

        private static class PasteTypedSourcesRefactoring
        extends Refactoring {
            private final TypedSource[] fSources;
            private IJavaElement fDestination;

            static PasteTypedSourcesRefactoring create(TypedSource[] typedSourceArray) {
                if (!PasteTypedSourcesRefactoring.isAvailable(typedSourceArray)) {
                    return null;
                }
                return new PasteTypedSourcesRefactoring(typedSourceArray);
            }

            public RefactoringStatus setDestination(IJavaElement iJavaElement) {
                this.fDestination = iJavaElement;
                if (ReorgUtils.getCompilationUnit(iJavaElement) == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_wrong_destination);
                }
                if (!iJavaElement.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_element_doesnot_exist);
                }
                if (!this.canPasteAll(iJavaElement)) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_invalid_destination);
                }
                return new RefactoringStatus();
            }

            private boolean canPasteAll(IJavaElement iJavaElement) {
                int n = 0;
                while (n < this.fSources.length) {
                    if (!PasteTypedSourcesRefactoring.canPaste(this.fSources[n].getType(), iJavaElement)) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }

            private static boolean canPaste(int n, IJavaElement iJavaElement) {
                IType iType = PasteTypedSourcesRefactoring.getAncestorType(iJavaElement);
                if (iType != null) {
                    return PasteTypedSourcesRefactoring.canPasteToType(n);
                }
                return PasteTypedSourcesRefactoring.canPasteToCu(n);
            }

            private static boolean canPasteToType(int n) {
                return n == 7 || n == 8 || n == 10 || n == 9;
            }

            private static boolean canPasteToCu(int n) {
                return n == 11 || n == 7 || n == 13;
            }

            PasteTypedSourcesRefactoring(TypedSource[] typedSourceArray) {
                Assert.isNotNull((Object)typedSourceArray);
                Assert.isTrue((typedSourceArray.length != 0 ? 1 : 0) != 0);
                this.fSources = typedSourceArray;
            }

            private static boolean isAvailable(TypedSource[] typedSourceArray) {
                return typedSourceArray != null && typedSourceArray.length > 0;
            }

            public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
                return new RefactoringStatus();
            }

            public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
                RefactoringStatus refactoringStatus = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.getDestinationCu()}), this.getValidationContext());
                return refactoringStatus;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
                ITextFileBuffer iTextFileBuffer;
                ASTParser aSTParser = ASTParser.newParser((int)3);
                aSTParser.setSource(this.getDestinationCu());
                CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(iProgressMonitor);
                ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
                TypedSource typedSource = null;
                int n = this.fSources.length - 1;
                while (n >= 0) {
                    typedSource = this.fSources[n];
                    iTextFileBuffer = this.getDestinationNodeForSourceElement(this.fDestination, typedSource.getType(), compilationUnit);
                    if (iTextFileBuffer != null) {
                        if (iTextFileBuffer instanceof CompilationUnit) {
                            PasteTypedSourcesRefactoring.insertToCu(aSTRewrite, this.createNewNodeToInsertToCu(typedSource, aSTRewrite), (CompilationUnit)iTextFileBuffer);
                        } else if (iTextFileBuffer instanceof AbstractTypeDeclaration) {
                            PasteTypedSourcesRefactoring.insertToType(aSTRewrite, this.createNewNodeToInsertToType(typedSource, aSTRewrite), (AbstractTypeDeclaration)iTextFileBuffer);
                        }
                    }
                    --n;
                }
                CompilationUnitChange compilationUnitChange = new CompilationUnitChange(ReorgMessages.PasteAction_change_name, this.getDestinationCu());
                try {
                    iTextFileBuffer = RefactoringFileBuffers.acquire(this.getDestinationCu());
                    TextEdit textEdit = aSTRewrite.rewriteAST(iTextFileBuffer.getDocument(), this.fDestination.getJavaProject().getOptions(true));
                    if (this.getDestinationCu().isWorkingCopy()) {
                        compilationUnitChange.setSaveMode(4);
                    }
                    TextChangeCompatibility.addTextEdit((TextChange)compilationUnitChange, ReorgMessages.PasteAction_edit_name, textEdit);
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    RefactoringFileBuffers.release(this.getDestinationCu());
                    throw throwable;
                }
                RefactoringFileBuffers.release(this.getDestinationCu());
                return compilationUnitChange;
            }

            private static void insertToType(ASTRewrite aSTRewrite, ASTNode aSTNode, AbstractTypeDeclaration abstractTypeDeclaration) {
                switch (aSTNode.getNodeType()) {
                    case 23: 
                    case 28: 
                    case 31: 
                    case 55: 
                    case 71: 
                    case 81: {
                        aSTRewrite.getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertAt(aSTNode, ASTNodes.getInsertionIndex((BodyDeclaration)aSTNode, abstractTypeDeclaration.bodyDeclarations()), null);
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)String.valueOf(aSTNode.getNodeType()));
                    }
                }
            }

            private static void insertToCu(ASTRewrite aSTRewrite, ASTNode aSTNode, CompilationUnit compilationUnit) {
                switch (aSTNode.getNodeType()) {
                    case 55: 
                    case 71: 
                    case 81: {
                        aSTRewrite.getListRewrite((ASTNode)compilationUnit, CompilationUnit.TYPES_PROPERTY).insertAt(aSTNode, ASTNodes.getInsertionIndex((BodyDeclaration)((AbstractTypeDeclaration)aSTNode), compilationUnit.types()), null);
                        break;
                    }
                    case 26: {
                        aSTRewrite.getListRewrite((ASTNode)compilationUnit, CompilationUnit.IMPORTS_PROPERTY).insertLast(aSTNode, null);
                        break;
                    }
                    case 35: {
                        if (compilationUnit.getPackage() != null) break;
                        aSTRewrite.set((ASTNode)compilationUnit, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)aSTNode, null);
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)String.valueOf(aSTNode.getNodeType()));
                    }
                }
            }

            private ASTNode getDestinationNodeForSourceElement(IJavaElement iJavaElement, int n, CompilationUnit compilationUnit) throws JavaModelException {
                IType iType = PasteTypedSourcesRefactoring.getAncestorType(iJavaElement);
                if (iType != null) {
                    return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, compilationUnit);
                }
                if (n == 7 || n == 11 || n == 13 || n == 12) {
                    return compilationUnit;
                }
                return null;
            }

            private static IType getAncestorType(IJavaElement iJavaElement) {
                return iJavaElement.getElementType() == 7 ? (IType)iJavaElement : (IType)iJavaElement.getAncestor(7);
            }

            private ASTNode createNewNodeToInsertToCu(TypedSource typedSource, ASTRewrite aSTRewrite) {
                switch (typedSource.getType()) {
                    case 7: {
                        return aSTRewrite.createStringPlaceholder(typedSource.getSource(), 55);
                    }
                    case 11: {
                        return aSTRewrite.createStringPlaceholder(typedSource.getSource(), 35);
                    }
                    case 13: {
                        return aSTRewrite.createStringPlaceholder(typedSource.getSource(), 26);
                    }
                }
                Assert.isTrue((boolean)false, (String)String.valueOf(typedSource.getType()));
                return null;
            }

            private ASTNode createNewNodeToInsertToType(TypedSource typedSource, ASTRewrite aSTRewrite) {
                switch (typedSource.getType()) {
                    case 7: {
                        return aSTRewrite.createStringPlaceholder(typedSource.getSource(), 55);
                    }
                    case 9: {
                        return aSTRewrite.createStringPlaceholder(typedSource.getSource(), 31);
                    }
                    case 8: {
                        return aSTRewrite.createStringPlaceholder(typedSource.getSource(), 23);
                    }
                    case 10: {
                        return aSTRewrite.createStringPlaceholder(typedSource.getSource(), 28);
                    }
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            private ICompilationUnit getDestinationCu() {
                return ReorgUtils.getCompilationUnit(this.fDestination);
            }

            public String getName() {
                return ReorgMessages.PasteAction_name;
            }
        }

        private static class ReorgTypedSourcePasteStarter {
            private final PasteTypedSourcesRefactoring fPasteRefactoring;

            private ReorgTypedSourcePasteStarter(PasteTypedSourcesRefactoring pasteTypedSourcesRefactoring) {
                Assert.isNotNull((Object)((Object)pasteTypedSourcesRefactoring));
                this.fPasteRefactoring = pasteTypedSourcesRefactoring;
            }

            public static ReorgTypedSourcePasteStarter create(TypedSource[] typedSourceArray, IJavaElement iJavaElement) {
                Assert.isNotNull((Object)typedSourceArray);
                Assert.isNotNull((Object)iJavaElement);
                PasteTypedSourcesRefactoring pasteTypedSourcesRefactoring = PasteTypedSourcesRefactoring.create(typedSourceArray);
                if (pasteTypedSourcesRefactoring == null) {
                    return null;
                }
                if (!pasteTypedSourcesRefactoring.setDestination(iJavaElement).isOK()) {
                    return null;
                }
                return new ReorgTypedSourcePasteStarter(pasteTypedSourcesRefactoring);
            }

            public void run(Shell shell) throws InterruptedException, InvocationTargetException {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                new RefactoringExecutionHelper(this.fPasteRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), 5, shell, (IRunnableContext)progressMonitorDialog).perform(false, false);
            }
        }
    }

    private static class WorkingSetPaster
    extends Paster {
        protected WorkingSetPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray, TransferData[] transferDataArray) throws JavaModelException, InterruptedException, InvocationTargetException {
            Object[] objectArray;
            IWorkingSet iWorkingSet = iWorkingSetArray[0];
            HashSet<IAdaptable> hashSet = new HashSet<IAdaptable>(Arrays.asList(iWorkingSet.getElements()));
            IJavaElement[] iJavaElementArray2 = this.getClipboardJavaElements(transferDataArray);
            if (iJavaElementArray2 != null) {
                int n = 0;
                while (n < iJavaElementArray2.length) {
                    if (!ReorgUtils.containsElementOrParent(hashSet, iJavaElementArray2[n])) {
                        hashSet.add((IAdaptable)iJavaElementArray2[n]);
                    }
                    ++n;
                }
            }
            if ((objectArray = this.getClipboardResources(transferDataArray)) != null) {
                IJavaElement iJavaElement;
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                ReorgUtils.splitIntoJavaElementsAndResources(objectArray, arrayList, arrayList2);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    iJavaElement = (IJavaElement)iterator.next();
                    if (ReorgUtils.containsElementOrParent(hashSet, iJavaElement)) continue;
                    hashSet.add((IAdaptable)iJavaElement);
                }
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    iJavaElement = (IResource)iterator.next();
                    if (ReorgUtils.containsElementOrParent(hashSet, (IResource)iJavaElement)) continue;
                    hashSet.add((IAdaptable)iJavaElement);
                }
            }
            iWorkingSet.setElements(hashSet.toArray(new IAdaptable[hashSet.size()]));
        }

        public boolean canEnable(TransferData[] transferDataArray) throws JavaModelException {
            return PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), transferDataArray) || PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), transferDataArray);
        }

        public boolean canPasteOn(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IWorkingSet[] iWorkingSetArray) throws JavaModelException {
            if (iResourceArray.length != 0 || iJavaElementArray.length != 0 || iWorkingSetArray.length != 1) {
                return false;
            }
            IWorkingSet iWorkingSet = iWorkingSetArray[0];
            return !"org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet".equals(iWorkingSet.getId());
        }
    }
}

