/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.ui.dialogs.ListDialog;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class ReorgQueries
implements IReorgQueries {
    private final Wizard fWizard;
    private final Shell fShell;

    public ReorgQueries(Wizard wizard) {
        Assert.isNotNull((Object)wizard);
        this.fWizard = wizard;
        this.fShell = null;
    }

    public ReorgQueries(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.fWizard = null;
        this.fShell = shell;
    }

    private Shell getShell() {
        Assert.isTrue((this.fShell == null || this.fWizard == null ? 1 : 0) != 0);
        Assert.isTrue((this.fShell != null || this.fWizard != null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        return this.fShell;
    }

    public IConfirmQuery createYesYesToAllNoNoToAllQuery(String string, boolean bl, int n) {
        return new YesYesToAllNoNoToAllQuery(this.getShell(), bl, string);
    }

    public IConfirmQuery createYesNoQuery(String string, boolean bl, int n) {
        return new YesNoQuery(this.getShell(), bl, string);
    }

    public IConfirmQuery createSkipQuery(String string, int n) {
        return new SkipQuery(this.getShell(), string);
    }

    private static class SkipQuery
    implements IConfirmQuery {
        private final Shell fShell;
        private final String fDialogTitle;
        private boolean fSkipAll;

        SkipQuery(Shell shell, String string) {
            this.fShell = shell;
            this.fDialogTitle = string;
            this.fSkipAll = false;
        }

        public boolean confirm(String string) throws OperationCanceledException {
            if (this.fSkipAll) {
                return false;
            }
            int[] nArray = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(string, nArray));
            return this.getResult(nArray);
        }

        public boolean confirm(String string, Object[] objectArray) throws OperationCanceledException {
            throw new UnsupportedOperationException("Not supported for skip queries");
        }

        private Runnable createQueryRunnable(String string, int[] nArray) {
            return new Runnable(this, string, nArray){
                final /* synthetic */ SkipQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = skipQuery;
                    this.val$question = string;
                    this.val$result = nArray;
                }

                public void run() {
                    MessageDialog messageDialog = new MessageDialog(SkipQuery.access$0(this.this$1), SkipQuery.access$1(this.this$1), null, this.val$question, 3, this.getButtonLabels(), 0);
                    messageDialog.open();
                    switch (messageDialog.getReturnCode()) {
                        case -1: {
                            this.val$result[0] = 1;
                            break;
                        }
                        default: {
                            this.val$result[0] = messageDialog.getReturnCode();
                        }
                    }
                }

                private String[] getButtonLabels() {
                    return new String[]{IDialogConstants.SKIP_LABEL, ReorgMessages.ReorgQueries_skip_all, IDialogConstants.CANCEL_LABEL};
                }
            };
        }

        private boolean getResult(int[] nArray) throws OperationCanceledException {
            switch (nArray[0]) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.fSkipAll = true;
                    return false;
                }
                case 2: {
                    throw new OperationCanceledException();
                }
            }
            return false;
        }

        static /* synthetic */ Shell access$0(SkipQuery skipQuery) {
            return skipQuery.fShell;
        }

        static /* synthetic */ String access$1(SkipQuery skipQuery) {
            return skipQuery.fDialogTitle;
        }
    }

    private static final class YesNoListDialog
    extends ListDialog {
        private final boolean fYesToAllNoToAll;

        private YesNoListDialog(Shell shell, boolean bl) {
            super(shell, 67632);
            this.fYesToAllNoToAll = bl;
        }

        protected void buttonPressed(int n) {
            super.buttonPressed(n);
            this.setReturnCode(n);
            this.close();
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 2, IDialogConstants.YES_LABEL, true);
            if (this.fYesToAllNoToAll) {
                this.createButton(composite, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            }
            this.createButton(composite, 3, IDialogConstants.NO_LABEL, false);
            if (this.fYesToAllNoToAll) {
                this.createButton(composite, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            }
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    private static class YesNoQuery
    implements IConfirmQuery {
        private final Shell fShell;
        private final String fDialogTitle;
        private final boolean fAllowCancel;

        YesNoQuery(Shell shell, boolean bl, String string) {
            this.fShell = shell;
            this.fDialogTitle = string;
            this.fAllowCancel = bl;
        }

        public boolean confirm(String string) throws OperationCanceledException {
            int[] nArray = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(string, nArray));
            return this.getResult(nArray);
        }

        public boolean confirm(String string, Object[] objectArray) throws OperationCanceledException {
            int[] nArray = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(string, objectArray, nArray));
            return this.getResult(nArray);
        }

        private Runnable createQueryRunnable(String string, int[] nArray) {
            return new Runnable(this, string, nArray){
                final /* synthetic */ YesNoQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesNoQuery;
                    this.val$question = string;
                    this.val$result = nArray;
                }

                public void run() {
                    MessageDialog messageDialog = new MessageDialog(YesNoQuery.access$0(this.this$1), YesNoQuery.access$1(this.this$1), null, this.val$question, 3, this.getButtonLabels(), 0);
                    messageDialog.open();
                    switch (messageDialog.getReturnCode()) {
                        case -1: {
                            this.val$result[0] = YesNoQuery.access$2(this.this$1) ? 1 : 3;
                            break;
                        }
                        case 0: {
                            this.val$result[0] = 2;
                            break;
                        }
                        case 1: {
                            this.val$result[0] = 3;
                            break;
                        }
                        case 2: {
                            if (YesNoQuery.access$2(this.this$1)) {
                                this.val$result[0] = 1;
                                break;
                            }
                            Assert.isTrue((boolean)false);
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                        }
                    }
                }

                private String[] getButtonLabels() {
                    if (YesNoQuery.access$2(this.this$1)) {
                        return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                    return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                }
            };
        }

        private Runnable createQueryRunnable(String string, Object[] objectArray, int[] nArray) {
            return new Runnable(this, string, objectArray, nArray){
                final /* synthetic */ YesNoQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ Object[] val$elements;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesNoQuery;
                    this.val$question = string;
                    this.val$elements = objectArray;
                    this.val$result = nArray;
                }

                public void run() {
                    YesNoListDialog yesNoListDialog = new YesNoListDialog(YesNoQuery.access$0(this.this$1), false);
                    yesNoListDialog.setAddCancelButton(false);
                    yesNoListDialog.setBlockOnOpen(true);
                    yesNoListDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    yesNoListDialog.setLabelProvider((ILabelProvider)new JavaElementLabelProvider());
                    yesNoListDialog.setTitle(YesNoQuery.access$1(this.this$1));
                    yesNoListDialog.setMessage(this.val$question);
                    yesNoListDialog.setInput(this.val$elements);
                    yesNoListDialog.open();
                    this.val$result[0] = yesNoListDialog.getReturnCode();
                }
            };
        }

        private boolean getResult(int[] nArray) throws OperationCanceledException {
            switch (nArray[0]) {
                case 2: {
                    return true;
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        static /* synthetic */ Shell access$0(YesNoQuery yesNoQuery) {
            return yesNoQuery.fShell;
        }

        static /* synthetic */ String access$1(YesNoQuery yesNoQuery) {
            return yesNoQuery.fDialogTitle;
        }

        static /* synthetic */ boolean access$2(YesNoQuery yesNoQuery) {
            return yesNoQuery.fAllowCancel;
        }
    }

    private static class YesYesToAllNoNoToAllQuery
    implements IConfirmQuery {
        private final boolean fAllowCancel;
        private boolean fYesToAll = false;
        private boolean fNoToAll = false;
        private final Shell fShell;
        private final String fDialogTitle;

        YesYesToAllNoNoToAllQuery(Shell shell, boolean bl, String string) {
            this.fShell = shell;
            this.fDialogTitle = string;
            this.fAllowCancel = bl;
        }

        public boolean confirm(String string) throws OperationCanceledException {
            if (this.fYesToAll) {
                return true;
            }
            if (this.fNoToAll) {
                return false;
            }
            int[] nArray = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(string, nArray));
            return this.getResult(nArray);
        }

        public boolean confirm(String string, Object[] objectArray) throws OperationCanceledException {
            if (this.fYesToAll) {
                return true;
            }
            if (this.fNoToAll) {
                return false;
            }
            int[] nArray = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(string, objectArray, nArray));
            return this.getResult(nArray);
        }

        private Runnable createQueryRunnable(String string, int[] nArray) {
            return new Runnable(this, string, nArray){
                final /* synthetic */ YesYesToAllNoNoToAllQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesYesToAllNoNoToAllQuery;
                    this.val$question = string;
                    this.val$result = nArray;
                }

                public void run() {
                    int[] nArray = this.getResultIDs();
                    MessageDialog messageDialog = new MessageDialog(YesYesToAllNoNoToAllQuery.access$0(this.this$1), YesYesToAllNoNoToAllQuery.access$1(this.this$1), null, this.val$question, 3, this.getButtonLabels(), 0);
                    messageDialog.open();
                    this.val$result[0] = messageDialog.getReturnCode() == -1 ? (YesYesToAllNoNoToAllQuery.access$2(this.this$1) ? 1 : 3) : nArray[messageDialog.getReturnCode()];
                }

                private String[] getButtonLabels() {
                    if (YesYesToAllNoNoToAllQuery.access$2(this.this$1)) {
                        return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                    return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
                }

                private int[] getResultIDs() {
                    if (YesYesToAllNoNoToAllQuery.access$2(this.this$1)) {
                        return new int[]{2, 4, 3, 21, 1};
                    }
                    return new int[]{2, 4, 3, 21};
                }
            };
        }

        private Runnable createQueryRunnable(String string, Object[] objectArray, int[] nArray) {
            return new Runnable(this, string, objectArray, nArray){
                final /* synthetic */ YesYesToAllNoNoToAllQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ Object[] val$elements;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesYesToAllNoNoToAllQuery;
                    this.val$question = string;
                    this.val$elements = objectArray;
                    this.val$result = nArray;
                }

                public void run() {
                    YesNoListDialog yesNoListDialog = new YesNoListDialog(YesYesToAllNoNoToAllQuery.access$0(this.this$1), true);
                    yesNoListDialog.setAddCancelButton(false);
                    yesNoListDialog.setBlockOnOpen(true);
                    yesNoListDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    yesNoListDialog.setLabelProvider((ILabelProvider)new JavaElementLabelProvider());
                    yesNoListDialog.setTitle(YesYesToAllNoNoToAllQuery.access$1(this.this$1));
                    yesNoListDialog.setMessage(this.val$question);
                    yesNoListDialog.setInput(this.val$elements);
                    yesNoListDialog.open();
                    this.val$result[0] = yesNoListDialog.getReturnCode();
                }
            };
        }

        private boolean getResult(int[] nArray) throws OperationCanceledException {
            switch (nArray[0]) {
                case 4: {
                    this.fYesToAll = true;
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    return false;
                }
                case 21: {
                    this.fNoToAll = true;
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        static /* synthetic */ Shell access$0(YesYesToAllNoNoToAllQuery yesYesToAllNoNoToAllQuery) {
            return yesYesToAllNoNoToAllQuery.fShell;
        }

        static /* synthetic */ String access$1(YesYesToAllNoNoToAllQuery yesYesToAllNoNoToAllQuery) {
            return yesYesToAllNoNoToAllQuery.fDialogTitle;
        }

        static /* synthetic */ boolean access$2(YesYesToAllNoNoToAllQuery yesYesToAllNoNoToAllQuery) {
            return yesYesToAllNoNoToAllQuery.fAllowCancel;
        }
    }
}

