/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;

public class JavaSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final Match[] NO_MATCHES = new Match[0];
    private final JavaSearchQuery fQuery;
    private final Map fElementsToParticipants;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JavaSearchResult(JavaSearchQuery javaSearchQuery) {
        this.fQuery = javaSearchQuery;
        this.fElementsToParticipants = new HashMap();
        this.setActiveMatchFilters(JavaMatchFilter.getLastUsedFilters());
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart iEditorPart) {
        return this.computeContainedMatches((IAdaptable)iEditorPart.getEditorInput());
    }

    public void setActiveMatchFilters(MatchFilter[] matchFilterArray) {
        super.setActiveMatchFilters(matchFilterArray);
        JavaMatchFilter.setLastUsedFilters(matchFilterArray);
    }

    public MatchFilter[] getAllMatchFilters() {
        return JavaMatchFilter.allFilters(this.fQuery);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
        return this.computeContainedMatches((IAdaptable)iFile);
    }

    private Match[] computeContainedMatches(IAdaptable iAdaptable) {
        IFile iFile;
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJavaElement iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz2);
        HashSet hashSet = new HashSet();
        if (iJavaElement != null) {
            this.collectMatches(hashSet, iJavaElement);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iFile = (IFile)iAdaptable.getAdapter((Class)clazz)) != null) {
            this.collectMatches(hashSet, iFile);
        }
        if (!hashSet.isEmpty()) {
            return hashSet.toArray(new Match[hashSet.size()]);
        }
        return NO_MATCHES;
    }

    private void collectMatches(Set set, IFile iFile) {
        Match[] matchArray = this.getMatches(iFile);
        if (matchArray.length != 0) {
            int n = 0;
            while (n < matchArray.length) {
                set.add(matchArray[n]);
                ++n;
            }
        }
    }

    private void collectMatches(Set set, IJavaElement iJavaElement) {
        Match[] matchArray = this.getMatches(iJavaElement);
        if (matchArray.length != 0) {
            int n = 0;
            while (n < matchArray.length) {
                set.add(matchArray[n]);
                ++n;
            }
        }
        if (iJavaElement instanceof IParent) {
            IParent iParent = (IParent)iJavaElement;
            try {
                IJavaElement[] iJavaElementArray = iParent.getChildren();
                int n = 0;
                while (n < iJavaElementArray.length) {
                    this.collectMatches(set, iJavaElementArray[n]);
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public IFile getFile(Object object) {
        if (object instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)object;
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
            if (iCompilationUnit != null) {
                return (IFile)iCompilationUnit.getResource();
            }
            IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
            if (iClassFile != null) {
                return (IFile)iClassFile.getResource();
            }
            return null;
        }
        if (object instanceof IFile) {
            return (IFile)object;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart iEditorPart) {
        Object object = match.getElement();
        if (object instanceof IJavaElement) {
            if ((object = ((IJavaElement)object).getOpenable()) != null) {
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object.equals(iEditorInput.getAdapter((Class)clazz))) {
                    return true;
                }
            }
            return false;
        }
        if (object instanceof IFile) {
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return object.equals(iEditorInput.getAdapter((Class)clazz));
        }
        return false;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    synchronized IMatchPresentation getSearchParticpant(Object object) {
        return (IMatchPresentation)this.fElementsToParticipants.get(object);
    }

    boolean addMatch(Match match, IMatchPresentation iMatchPresentation) {
        Object object = match.getElement();
        if (this.fElementsToParticipants.get(object) != null) {
            JavaPlugin.log((IStatus)new Status(2, JavaPlugin.getPluginId(), 0, "A second search participant was found for an element", null));
            return false;
        }
        this.fElementsToParticipants.put(object, iMatchPresentation);
        this.addMatch(match);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            this.fElementsToParticipants.clear();
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            if (this.getMatchCount(match.getElement()) == 1) {
                this.fElementsToParticipants.remove(match.getElement());
            }
        }
        super.removeMatch(match);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

