/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public class LevelTreeContentProvider
extends JavaSearchContentProvider
implements ITreeContentProvider {
    private Map fChildrenMap;
    private StandardJavaElementContentProvider fContentProvider;
    public static final int LEVEL_TYPE = 1;
    public static final int LEVEL_FILE = 2;
    public static final int LEVEL_PACKAGE = 3;
    public static final int LEVEL_PROJECT = 4;
    private static final int[][] JAVA_ELEMENT_TYPES = new int[][]{{7}, {6, 5}, {4}, {2, 3}, {1}};
    private static final int[][] RESOURCE_TYPES = new int[][]{new int[0], {1}, {2}, {4}, {8}};
    private static final int MAX_LEVEL = JAVA_ELEMENT_TYPES.length - 1;
    private int fCurrentLevel;

    public LevelTreeContentProvider(JavaSearchResultPage javaSearchResultPage, int n) {
        super(javaSearchResultPage);
        this.fCurrentLevel = n;
        this.fContentProvider = new FastJavaElementProvider();
    }

    public Object getParent(Object object) {
        IJavaElement iJavaElement;
        Object object2 = this.internalGetParent(object);
        if (object2 instanceof IJavaElement) {
            iJavaElement = (IJavaElement)object2;
            int n = this.fCurrentLevel;
            while (n < MAX_LEVEL + 1) {
                int n2 = 0;
                while (n2 < JAVA_ELEMENT_TYPES[n].length) {
                    if (iJavaElement.getElementType() == JAVA_ELEMENT_TYPES[n][n2]) {
                        return null;
                    }
                    ++n2;
                }
                ++n;
            }
        } else if (object2 instanceof IResource) {
            iJavaElement = (IResource)object2;
            int n = this.fCurrentLevel;
            while (n < MAX_LEVEL + 1) {
                int n3 = 0;
                while (n3 < RESOURCE_TYPES[n].length) {
                    if (iJavaElement.getType() == RESOURCE_TYPES[n][n3]) {
                        return null;
                    }
                    ++n3;
                }
                ++n;
            }
        }
        if (this.fCurrentLevel != 2 && object instanceof IType) {
            iJavaElement = (IType)object;
            if (object2 instanceof ICompilationUnit || object2 instanceof IClassFile) {
                object2 = iJavaElement.getPackageFragment();
            }
        }
        return object2;
    }

    private Object internalGetParent(Object object) {
        return this.fContentProvider.getParent(object);
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    protected synchronized void initialize(JavaSearchResult javaSearchResult) {
        super.initialize(javaSearchResult);
        this.fChildrenMap = new HashMap();
        if (javaSearchResult != null) {
            Object[] objectArray = javaSearchResult.getElements();
            int n = 0;
            while (n < objectArray.length) {
                if (this.getPage().getDisplayedMatchCount(objectArray[n]) > 0) {
                    this.insert(null, null, objectArray[n]);
                }
                ++n;
            }
        }
    }

    protected void insert(Map map, Set set, Object object) {
        Object object2 = this.getParent(object);
        while (object2 != null) {
            if (this.insertChild(object2, object)) {
                if (map != null) {
                    this.insertInto(object2, object, map);
                }
            } else {
                if (set != null) {
                    set.add(object2);
                }
                return;
            }
            object = object2;
            object2 = this.getParent(object);
        }
        if (this.insertChild((Object)this.getSearchResult(), object) && map != null) {
            this.insertInto((Object)this.getSearchResult(), object, map);
        }
    }

    private boolean insertChild(Object object, Object object2) {
        return this.insertInto(object, object2, this.fChildrenMap);
    }

    private boolean insertInto(Object object, Object object2, Map map) {
        HashSet<Object> hashSet = (HashSet<Object>)map.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            map.put(object, hashSet);
        }
        return hashSet.add(object2);
    }

    protected void remove(Set set, Set set2, Object object) {
        if (this.hasChildren(object)) {
            if (set2 != null) {
                set2.add(object);
            }
        } else if (this.getPage().getDisplayedMatchCount(object) == 0) {
            this.fChildrenMap.remove(object);
            Object object2 = this.getParent(object);
            if (object2 != null) {
                if (this.removeFromSiblings(object, object2)) {
                    this.remove(set, set2, object2);
                }
            } else if (this.removeFromSiblings(object, (Object)this.getSearchResult()) && set != null) {
                set.add(object);
            }
        } else if (set2 != null) {
            set2.add(object);
        }
    }

    private boolean removeFromSiblings(Object object, Object object2) {
        Set set = (Set)this.fChildrenMap.get(object2);
        if (set != null) {
            return set.remove(object);
        }
        return false;
    }

    public Object[] getChildren(Object object) {
        Set set = (Set)this.fChildrenMap.get(object);
        if (set == null) {
            return this.EMPTY_ARR;
        }
        int n = this.getPage().getElementLimit();
        if (n != -1 && n < set.size()) {
            Object[] objectArray = new Object[n];
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = iterator.next();
                ++n2;
            }
            return objectArray;
        }
        return set.toArray();
    }

    public boolean hasChildren(Object object) {
        Set set = (Set)this.fChildrenMap.get(object);
        return set != null && !set.isEmpty();
    }

    public synchronized void elementsChanged(Object[] objectArray) {
        if (this.getSearchResult() == null) {
            return;
        }
        AbstractTreeViewer abstractTreeViewer = (AbstractTreeViewer)this.getPage().getViewer();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < objectArray.length) {
            if (this.getPage().getDisplayedMatchCount(objectArray[n]) > 0) {
                this.insert(hashMap, hashSet2, objectArray[n]);
            } else {
                this.remove(hashSet, hashSet2, objectArray[n]);
            }
            ++n;
        }
        abstractTreeViewer.remove(hashSet.toArray());
        Iterator<Object> iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            HashSet hashSet3 = (HashSet)hashMap.get(k);
            abstractTreeViewer.add(k, hashSet3.toArray());
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            abstractTreeViewer.refresh(iterator.next());
        }
    }

    public void clear() {
        this.initialize(this.getSearchResult());
        this.getPage().getViewer().refresh();
    }

    public void setLevel(int n) {
        this.fCurrentLevel = n;
        this.initialize(this.getSearchResult());
        this.getPage().getViewer().refresh();
    }

    static class FastJavaElementProvider
    extends StandardJavaElementContentProvider {
        FastJavaElementProvider() {
        }

        public Object getParent(Object object) {
            return this.internalGetParent(object);
        }
    }
}

