/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementLine;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesSearchQuery;

public class OccurrencesSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    protected static final Match[] NO_MATCHES = new Match[0];
    private OccurrencesSearchQuery fQuery;

    public OccurrencesSearchResult(OccurrencesSearchQuery occurrencesSearchQuery) {
        this.fQuery = occurrencesSearchQuery;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
        Object[] objectArray = this.getElements();
        if (objectArray.length == 0) {
            return NO_MATCHES;
        }
        JavaElementLine javaElementLine = (JavaElementLine)objectArray[0];
        try {
            if (iFile.equals((Object)javaElementLine.getJavaElement().getCorrespondingResource())) {
                return this.collectMatches(objectArray);
            }
        }
        catch (JavaModelException javaModelException) {}
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return this.computeContainedMatches(abstractTextSearchResult, iFileEditorInput.getFile());
        }
        if (iEditorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)iEditorInput;
            IClassFile iClassFile = iClassFileEditorInput.getClassFile();
            Object[] objectArray = this.getElements();
            if (objectArray.length == 0) {
                return NO_MATCHES;
            }
            JavaElementLine javaElementLine = (JavaElementLine)objectArray[0];
            if (javaElementLine.getJavaElement().equals(iClassFile)) {
                return this.collectMatches(objectArray);
            }
        }
        return NO_MATCHES;
    }

    public IFile getFile(Object object) {
        JavaElementLine javaElementLine = (JavaElementLine)object;
        IResource iResource = null;
        try {
            iResource = javaElementLine.getJavaElement().getCorrespondingResource();
        }
        catch (JavaModelException javaModelException) {}
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart iEditorPart) {
        Object object = match.getElement();
        IJavaElement iJavaElement = ((JavaElementLine)object).getJavaElement();
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            try {
                return ((IFileEditorInput)iEditorInput).getFile().equals((Object)iJavaElement.getCorrespondingResource());
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        if (iEditorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)iEditorInput).getClassFile().equals(iJavaElement);
        }
        return false;
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    private Match[] collectMatches(Object[] objectArray) {
        Match[] matchArray = new Match[this.getMatchCount()];
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Match[] matchArray2 = this.getMatches(objectArray[n2]);
            int n3 = 0;
            while (n3 < matchArray2.length) {
                matchArray[n++] = matchArray2[n3];
                ++n3;
            }
            ++n2;
        }
        return matchArray;
    }
}

