/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.search.SearchParticipantDescriptor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchParticipantRecord;

public class SearchParticipantsExtensionPoint {
    private Set fActiveParticipants = null;
    private static SearchParticipantsExtensionPoint fgInstance;

    public boolean hasAnyParticipants() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.jsdt.ui.queryParticipants").length > 0;
    }

    private synchronized Set getAllParticipants() {
        if (this.fActiveParticipants != null) {
            return this.fActiveParticipants;
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.jsdt.ui.queryParticipants");
        this.fActiveParticipants = new HashSet(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            SearchParticipantDescriptor searchParticipantDescriptor = new SearchParticipantDescriptor(iConfigurationElementArray[n]);
            IStatus iStatus = searchParticipantDescriptor.checkSyntax();
            if (iStatus.isOK()) {
                this.fActiveParticipants.add(searchParticipantDescriptor);
            } else {
                JavaPlugin.log(iStatus);
            }
            ++n;
        }
        return this.fActiveParticipants;
    }

    private void collectParticipants(Set set, IProject[] iProjectArray) {
        Iterator iterator = this.getAllParticipants().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            SearchParticipantDescriptor searchParticipantDescriptor = (SearchParticipantDescriptor)iterator.next();
            if (!searchParticipantDescriptor.isEnabled()) continue;
            String string = searchParticipantDescriptor.getID();
            int n = 0;
            while (n < iProjectArray.length) {
                if (!hashSet.contains(string)) {
                    try {
                        if (iProjectArray[n].hasNature(searchParticipantDescriptor.getNature())) {
                            set.add(new SearchParticipantRecord(searchParticipantDescriptor, searchParticipantDescriptor.create()));
                            hashSet.add(string);
                        }
                    }
                    catch (CoreException coreException) {
                        JavaPlugin.log(coreException.getStatus());
                        searchParticipantDescriptor.disable();
                    }
                }
                ++n;
            }
        }
    }

    public SearchParticipantRecord[] getSearchParticipants(IProject[] iProjectArray) throws CoreException {
        HashSet hashSet = new HashSet();
        this.collectParticipants(hashSet, iProjectArray);
        SearchParticipantRecord[] searchParticipantRecordArray = new SearchParticipantRecord[hashSet.size()];
        return hashSet.toArray(searchParticipantRecordArray);
    }

    public static SearchParticipantsExtensionPoint getInstance() {
        if (fgInstance == null) {
            fgInstance = new SearchParticipantsExtensionPoint();
        }
        return fgInstance;
    }

    public static void debugSetInstance(SearchParticipantsExtensionPoint searchParticipantsExtensionPoint) {
        fgInstance = searchParticipantsExtensionPoint;
    }
}

